/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.resourcemanager;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEvent;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.ApplicationMasterLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.appmaster.AMSimulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockAMLauncher
extends ApplicationMasterLauncher
implements EventHandler<AMLauncherEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(MockAMLauncher.class);
    private SLSRunner slsRunner;

    public MockAMLauncher(SLSRunner slsRunner, RMContext rmContext) {
        super(rmContext);
        this.slsRunner = slsRunner;
    }

    protected void serviceInit(Configuration conf) throws Exception {
    }

    protected void serviceStart() throws Exception {
    }

    protected void serviceStop() throws Exception {
    }

    private void setupAMRMToken(RMAppAttempt appAttempt) {
        Token amrmToken = this.context.getAMRMTokenSecretManager().createAndGetAMRMToken(appAttempt.getAppAttemptId());
        ((RMAppAttemptImpl)appAttempt).setAMRMToken(amrmToken);
    }

    public void handle(AMLauncherEvent event) {
        ApplicationId appId = event.getAppAttempt().getAppAttemptId().getApplicationId();
        AMSimulator ams = this.slsRunner.getAMSimulatorByAppId(appId);
        if (ams == null) {
            throw new YarnRuntimeException("Didn't find any AMSimulator for applicationId=" + appId);
        }
        Container amContainer = event.getAppAttempt().getMasterContainer();
        switch ((AMLauncherEventType)event.getType()) {
            case LAUNCH: {
                try {
                    this.setupAMRMToken(event.getAppAttempt());
                    this.context.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(event.getAppAttempt().getAppAttemptId(), RMAppAttemptEventType.LAUNCHED));
                    ams.notifyAMContainerLaunched(event.getAppAttempt().getMasterContainer());
                    LOG.info("Notify AM launcher launched:" + amContainer.getId());
                    this.slsRunner.getNmMap().get(amContainer.getNodeId()).addNewContainer(amContainer, -1L, appId);
                    ams.getRanNodes().add(amContainer.getNodeId());
                    return;
                }
                catch (Exception e) {
                    throw new YarnRuntimeException((Throwable)e);
                }
            }
            case CLEANUP: {
                this.slsRunner.getNmMap().get(amContainer.getNodeId()).cleanupContainer(amContainer.getId());
                break;
            }
            default: {
                throw new YarnRuntimeException("Didn't find any AMSimulator for applicationId=" + appId);
            }
        }
    }
}

