/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.annotations;

import java.lang.annotation.Annotation;
import org.apache.hadoop.shaded.javax.servlet.ServletContextAttributeListener;
import org.apache.hadoop.shaded.javax.servlet.ServletContextListener;
import org.apache.hadoop.shaded.javax.servlet.ServletRequestAttributeListener;
import org.apache.hadoop.shaded.javax.servlet.ServletRequestListener;
import org.apache.hadoop.shaded.javax.servlet.annotation.WebListener;
import org.apache.hadoop.shaded.javax.servlet.http.HttpSessionAttributeListener;
import org.apache.hadoop.shaded.javax.servlet.http.HttpSessionIdListener;
import org.apache.hadoop.shaded.javax.servlet.http.HttpSessionListener;
import org.apache.hadoop.shaded.org.eclipse.jetty.servlet.ListenerHolder;
import org.apache.hadoop.shaded.org.eclipse.jetty.servlet.Source;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Logger;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.resource.Resource;
import org.apache.hadoop.shaded.org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.apache.hadoop.shaded.org.eclipse.jetty.webapp.MetaData;
import org.apache.hadoop.shaded.org.eclipse.jetty.webapp.Origin;
import org.apache.hadoop.shaded.org.eclipse.jetty.webapp.WebAppContext;

public class WebListenerAnnotation
extends DiscoveredAnnotation {
    private static final Logger LOG = Log.getLogger(WebListenerAnnotation.class);

    public WebListenerAnnotation(WebAppContext context, String className) {
        super(context, className);
    }

    public WebListenerAnnotation(WebAppContext context, String className, Resource resource) {
        super(context, className, resource);
    }

    public void apply() {
        Class clazz = this.getTargetClass();
        if (clazz == null) {
            LOG.warn(this._className + " cannot be loaded", new Object[0]);
            return;
        }
        try {
            if (ServletContextListener.class.isAssignableFrom(clazz) || ServletContextAttributeListener.class.isAssignableFrom(clazz) || ServletRequestListener.class.isAssignableFrom(clazz) || ServletRequestAttributeListener.class.isAssignableFrom(clazz) || HttpSessionListener.class.isAssignableFrom(clazz) || HttpSessionAttributeListener.class.isAssignableFrom(clazz) || HttpSessionIdListener.class.isAssignableFrom(clazz)) {
                MetaData metaData = this._context.getMetaData();
                if (metaData.getOrigin(clazz.getName() + ".listener") == Origin.NotSet) {
                    ListenerHolder h = this._context.getServletHandler().newListenerHolder(new Source(Source.Origin.ANNOTATION, clazz.getName()));
                    h.setHeldClass(clazz);
                    this._context.getServletHandler().addListener(h);
                    metaData.setOrigin(clazz.getName() + ".listener", (Annotation)clazz.getAnnotation(WebListener.class), clazz);
                }
            } else {
                LOG.warn(clazz.getName() + " does not implement one of the servlet listener interfaces", new Object[0]);
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }
}

