/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.http;

import org.apache.hadoop.shaded.org.glassfish.grizzly.ThreadCache;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.HttpCodecFilter;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.HttpPacketParsing;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.HttpResponsePacket;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.ProcessingState;

class HttpResponsePacketImpl
extends HttpResponsePacket
implements HttpPacketParsing {
    private static final ThreadCache.CachedTypeIndex<HttpResponsePacketImpl> CACHE_IDX = ThreadCache.obtainIndex(HttpResponsePacketImpl.class, 16);
    private boolean isHeaderParsed;
    private final HttpCodecFilter.HeaderParsingState headerParsingState = new HttpCodecFilter.HeaderParsingState();
    private final HttpCodecFilter.ContentParsingState contentParsingState = new HttpCodecFilter.ContentParsingState();

    public static HttpResponsePacketImpl create() {
        HttpResponsePacketImpl httpResponseImpl = ThreadCache.takeFromCache(CACHE_IDX);
        if (httpResponseImpl != null) {
            return httpResponseImpl;
        }
        return new HttpResponsePacketImpl();
    }

    private HttpResponsePacketImpl() {
    }

    public void initialize(HttpCodecFilter filter, int initialOffset, int maxHeaderSize, int maxNumberOfHeaders) {
        this.headerParsingState.initialize(filter, initialOffset, maxHeaderSize);
        this.headers.setMaxNumHeaders(maxNumberOfHeaders);
        this.contentParsingState.trailerHeaders.setMaxNumHeaders(maxNumberOfHeaders);
    }

    @Override
    public HttpCodecFilter.HeaderParsingState getHeaderParsingState() {
        return this.headerParsingState;
    }

    @Override
    public HttpCodecFilter.ContentParsingState getContentParsingState() {
        return this.contentParsingState;
    }

    @Override
    public ProcessingState getProcessingState() {
        return this.getRequest().getProcessingState();
    }

    @Override
    public boolean isHeaderParsed() {
        return this.isHeaderParsed;
    }

    @Override
    public void setHeaderParsed(boolean isHeaderParsed) {
        this.isHeaderParsed = isHeaderParsed;
    }

    @Override
    protected void reset() {
        this.headerParsingState.recycle();
        this.contentParsingState.recycle();
        this.isHeaderParsed = false;
        super.reset();
    }

    @Override
    public void recycle() {
        if (this.getRequest().isExpectContent()) {
            return;
        }
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, this);
    }
}

