/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.nustaq.serialization;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class FSTClazzLineageInfo {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final LineageInfo OBJECT_LINEAGE_INFO = new LineageInfo(new LinkedHashSet<Class<Object>>(Collections.singletonList(Object.class)), 0);
    private static final ConcurrentMap<Class<?>, LineageInfo> lineageInfos = new ConcurrentHashMap();
    public static final Comparator<Class> SPECIFICITY_CLASS_COMPARATOR = new Comparator<Class>(){

        @Override
        public int compare(Class c1, Class c2) {
            return FSTClazzLineageInfo.getLineageInfo(c2).specificity - FSTClazzLineageInfo.getLineageInfo(c1).specificity;
        }
    };

    private FSTClazzLineageInfo() {
    }

    public static int getSpecificity(Class<?> clazz) {
        if (clazz == null) {
            return 0;
        }
        LineageInfo lineageInfo = FSTClazzLineageInfo.getLineageInfo(clazz);
        return lineageInfo == null ? 0 : lineageInfo.specificity;
    }

    public static Class<?>[] getLineage(Class<?> clazz) {
        LineageInfo lineageInfo = FSTClazzLineageInfo.getLineageInfo(clazz);
        return lineageInfo == null ? EMPTY_CLASS_ARRAY : lineageInfo.lineage.toArray(new Class[lineageInfo.lineage.size()]);
    }

    private static LineageInfo getLineageInfo(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.equals(Object.class)) {
            return OBJECT_LINEAGE_INFO;
        }
        LineageInfo lineageInfo = (LineageInfo)lineageInfos.get(clazz);
        if (lineageInfo != null) {
            return lineageInfo;
        }
        int specificity = 1;
        LinkedHashSet ancestors = new LinkedHashSet();
        Class<?> sc = FSTClazzLineageInfo.getSuperclass(clazz);
        LineageInfo sl = FSTClazzLineageInfo.getLineageInfo(sc);
        if (sl != null) {
            ancestors.addAll(sl.lineage);
            specificity += sl.specificity;
        }
        for (Class<?> i : FSTClazzLineageInfo.getInterfaces(clazz)) {
            LineageInfo il = FSTClazzLineageInfo.getLineageInfo(i);
            if (il == null) continue;
            ancestors.removeAll(il.lineage);
            ancestors.addAll(il.lineage);
            specificity += il.specificity;
        }
        Class[] array = ancestors.toArray(new Class[ancestors.size()]);
        Arrays.sort(array, SPECIFICITY_CLASS_COMPARATOR);
        LinkedHashSet lineage = new LinkedHashSet(array.length + 1);
        lineage.add(clazz);
        Collections.addAll(lineage, array);
        LineageInfo result = new LineageInfo(lineage, specificity);
        lineageInfos.putIfAbsent(clazz, result);
        return result;
    }

    private static Class<?> getSuperclass(Class<?> c) {
        if (c == null) {
            return null;
        }
        return c.getSuperclass();
    }

    private static Class<?>[] getInterfaces(Class<?> c) {
        if (c == null) {
            return null;
        }
        return c.getInterfaces();
    }

    private static final class LineageInfo {
        private final LinkedHashSet<Class<?>> lineage;
        private final int specificity;

        private LineageInfo(LinkedHashSet<Class<?>> lineage, int specificity) {
            this.lineage = lineage;
            this.specificity = specificity;
        }
    }
}

