/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.processor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.algorithm.iterators.PopularTagsIterator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.algorithm.iterators.SerialIterator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.api.ConstraintPlacementAlgorithmInput;

public class BatchedRequests
implements ConstraintPlacementAlgorithmInput,
Iterable<SchedulingRequest> {
    private final int placementAttempt;
    private final ApplicationId applicationId;
    private final Collection<SchedulingRequest> requests;
    private final Map<String, Set<NodeId>> blacklist = new HashMap<String, Set<NodeId>>();
    private IteratorType iteratorType;

    public BatchedRequests(IteratorType type, ApplicationId applicationId, Collection<SchedulingRequest> requests, int attempt) {
        this.iteratorType = type;
        this.applicationId = applicationId;
        this.requests = requests;
        this.placementAttempt = attempt;
    }

    @Override
    public Iterator<SchedulingRequest> iterator() {
        switch (this.iteratorType) {
            case SERIAL: {
                return new SerialIterator(this.requests);
            }
            case POPULAR_TAGS: {
                return new PopularTagsIterator(this.requests);
            }
        }
        return null;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    @Override
    public Collection<SchedulingRequest> getSchedulingRequests() {
        return this.requests;
    }

    public void addToBatch(SchedulingRequest req) {
        this.requests.add(req);
    }

    public void addToBlacklist(Set<String> tags, SchedulerNode node) {
        if (tags != null && !tags.isEmpty() && node != null) {
            this.blacklist.computeIfAbsent(tags.iterator().next(), k -> new HashSet()).add(node.getNodeID());
        }
    }

    public int getPlacementAttempt() {
        return this.placementAttempt;
    }

    public Set<NodeId> getBlacklist(String tag) {
        return this.blacklist.getOrDefault(tag, Collections.emptySet());
    }

    public IteratorType getIteratorType() {
        return this.iteratorType;
    }

    public static enum IteratorType {
        SERIAL,
        POPULAR_TAGS;

    }
}

