/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.crypto;

import com.aliyun.oss.crypto.ContentCryptoMode;
import com.aliyun.oss.crypto.CryptoStorageMethod;
import java.io.Serializable;
import java.security.Provider;
import java.security.SecureRandom;

public class CryptoConfiguration
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -610360281849259785L;
    private static final SecureRandom SRAND = new SecureRandom();
    private ContentCryptoMode contentCryptoMode;
    private CryptoStorageMethod storageMethod;
    private Provider contentCryptoProvider;
    private SecureRandom secureRandom;
    public static final CryptoConfiguration DEFAULT = new CryptoConfiguration();

    public CryptoConfiguration() {
        this.contentCryptoMode = ContentCryptoMode.AES_CTR_MODE;
        this.storageMethod = CryptoStorageMethod.ObjectMetadata;
        this.secureRandom = SRAND;
        this.contentCryptoProvider = null;
    }

    public CryptoConfiguration(ContentCryptoMode contentCryptoMode, CryptoStorageMethod storageMethod, SecureRandom secureRandom, Provider contentCryptoProvider) {
        this.contentCryptoMode = contentCryptoMode;
        this.storageMethod = storageMethod;
        this.secureRandom = secureRandom;
        this.contentCryptoProvider = contentCryptoProvider;
    }

    public void setContentCryptoMode(ContentCryptoMode contentCryptoMode) {
        this.contentCryptoMode = contentCryptoMode;
    }

    public ContentCryptoMode getContentCryptoMode() {
        return this.contentCryptoMode;
    }

    public void setStorageMethod(CryptoStorageMethod storageMethod) {
        this.storageMethod = storageMethod;
    }

    public CryptoStorageMethod getStorageMethod() {
        return this.storageMethod;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    public CryptoConfiguration withSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public void setContentCryptoProvider(Provider contentCryptoProvider) {
        this.contentCryptoProvider = contentCryptoProvider;
    }

    public CryptoConfiguration withContentCryptoProvider(Provider contentCryptoProvider) {
        this.contentCryptoProvider = contentCryptoProvider;
        return this;
    }

    public Provider getContentCryptoProvider() {
        return this.contentCryptoProvider;
    }

    public CryptoConfiguration clone() {
        CryptoConfiguration config = new CryptoConfiguration();
        config.setContentCryptoMode(this.contentCryptoMode);
        config.setSecureRandom(this.secureRandom);
        config.setStorageMethod(this.storageMethod);
        config.setContentCryptoProvider(this.contentCryptoProvider);
        return config;
    }
}

