/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.federation.resolver.PathLocation;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface FileSubclusterResolver {
    public PathLocation getDestinationForPath(String var1) throws IOException;

    public List<String> getMountPoints(String var1) throws IOException;

    public String getDefaultNamespace();

    public static List<String> getMountPoints(String path, Collection<String> mountPoints) {
        TreeSet<String> children = new TreeSet<String>();
        boolean exists = false;
        Iterator<String> iterator = mountPoints.iterator();
        while (iterator.hasNext()) {
            String subPath;
            String child = subPath = iterator.next();
            if (!path.equals("/")) {
                int ini = path.length();
                child = subPath.substring(ini);
            }
            if (child.isEmpty()) {
                exists = true;
                continue;
            }
            if (!child.startsWith("/")) continue;
            exists = true;
            int fin = (child = child.substring(1)).indexOf("/");
            if (fin > -1) {
                child = child.substring(0, fin);
            }
            if (child.isEmpty()) continue;
            children.add(child);
        }
        if (!exists) {
            return null;
        }
        return new LinkedList<String>(children);
    }
}

