/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.NameNodeProxiesClient;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionContext {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionContext.class);
    private final NameNodeProxiesClient.ProxyAndInfo<?> client;
    private int numThreads = 0;
    private boolean closed = false;
    private long lastActiveTs = 0L;
    private static final long ACTIVE_WINDOW_TIME = TimeUnit.SECONDS.toMillis(30L);
    private final int maxConcurrencyPerConn;

    public ConnectionContext(NameNodeProxiesClient.ProxyAndInfo<?> connection, Configuration conf) {
        this.client = connection;
        this.maxConcurrencyPerConn = conf.getInt("dfs.federation.router.max.concurrency.per.connection", 1);
    }

    public synchronized boolean isActive() {
        return this.numThreads > 0;
    }

    public synchronized boolean isActiveRecently() {
        return Time.monotonicNow() - this.lastActiveTs <= ACTIVE_WINDOW_TIME;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized boolean isUsable() {
        return this.hasAvailableConcurrency() && !this.isClosed();
    }

    private synchronized boolean hasAvailableConcurrency() {
        return this.numThreads < this.maxConcurrencyPerConn;
    }

    public synchronized boolean isIdle() {
        return !this.isActive() && !this.isClosed();
    }

    public synchronized NameNodeProxiesClient.ProxyAndInfo<?> getClient() {
        ++this.numThreads;
        this.lastActiveTs = Time.monotonicNow();
        return this.client;
    }

    public synchronized void release() {
        if (this.numThreads > 0) {
            --this.numThreads;
        }
    }

    public synchronized void close(boolean force) {
        if (!force && this.numThreads > 0) {
            LOG.error("Active connection with {} handlers will be closed, ConnectionContext is {}", (Object)this.numThreads, (Object)this);
        }
        this.closed = true;
        Object proxy = this.client.getProxy();
        RPC.stopProxy((Object)proxy);
    }

    public synchronized void close() {
        this.close(false);
    }

    public String toString() {
        InetSocketAddress addr = this.client.getAddress();
        Object proxy = this.client.getProxy();
        Class<?> clazz = proxy.getClass();
        StringBuilder sb = new StringBuilder();
        sb.append("hashcode:").append(this.hashCode()).append(" ").append(clazz.getSimpleName()).append("@").append(addr).append("x").append(this.numThreads);
        if (this.closed) {
            sb.append("[CLOSED]");
        }
        return sb.toString();
    }
}

