/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.security.token;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.router.security.token.SQLConnectionFactory;

class HikariDataSourceConnectionFactory
implements SQLConnectionFactory {
    protected static final String HIKARI_PROPS = "sql-dt-secret-manager.connection.hikari.";
    private final HikariDataSource dataSource;

    HikariDataSourceConnectionFactory(Configuration conf) {
        Properties properties = new Properties();
        properties.setProperty("jdbcUrl", conf.get("sql-dt-secret-manager.connection.url"));
        properties.setProperty("username", conf.get("sql-dt-secret-manager.connection.username"));
        properties.setProperty("password", conf.get("sql-dt-secret-manager.connection.password"));
        properties.setProperty("driverClassName", conf.get("sql-dt-secret-manager.connection.driver"));
        properties.putAll((Map<?, ?>)conf.getPropsWithPrefix(HIKARI_PROPS));
        HikariConfig hikariConfig = new HikariConfig(properties);
        this.dataSource = new HikariDataSource(hikariConfig);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public void shutdown() {
        this.dataSource.close();
    }

    @VisibleForTesting
    HikariDataSource getDataSource() {
        return this.dataSource;
    }
}

