/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.utils;

import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.server.federation.store.exception.FederationStateStoreInvalidInputException;
import org.apache.hadoop.yarn.server.federation.store.records.AddReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.ReservationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationMembershipStateStoreInputValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FederationReservationHomeSubClusterStoreInputValidator {
    private static final Logger LOG = LoggerFactory.getLogger(FederationReservationHomeSubClusterStoreInputValidator.class);

    private FederationReservationHomeSubClusterStoreInputValidator() {
    }

    public static void validate(AddReservationHomeSubClusterRequest request) throws FederationStateStoreInvalidInputException {
        if (request == null) {
            String message = "Missing AddReservationHomeSubCluster Request. Please try again by specifying an AddReservationHomeSubCluster information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        FederationReservationHomeSubClusterStoreInputValidator.checkReservationHomeSubCluster(request.getReservationHomeSubCluster());
    }

    public static void validate(GetReservationHomeSubClusterRequest request) throws FederationStateStoreInvalidInputException {
        if (request == null) {
            String message = "Missing GetReservationHomeSubCluster Request. Please try again by specifying an Reservation Id information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        FederationReservationHomeSubClusterStoreInputValidator.checkReservationId(request.getReservationId());
    }

    private static void checkReservationHomeSubCluster(ReservationHomeSubCluster reservationHomeSubCluster) throws FederationStateStoreInvalidInputException {
        if (reservationHomeSubCluster == null) {
            String message = "Missing ReservationHomeSubCluster Info. Please try again by specifying an ReservationHomeSubCluster information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        FederationReservationHomeSubClusterStoreInputValidator.checkReservationId(reservationHomeSubCluster.getReservationId());
        FederationMembershipStateStoreInputValidator.checkSubClusterId(reservationHomeSubCluster.getHomeSubCluster());
    }

    private static void checkReservationId(ReservationId reservationId) throws FederationStateStoreInvalidInputException {
        if (reservationId == null) {
            String message = "Missing ReservationId. Please try again by specifying an ReservationId.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
    }

    public static void validate(UpdateReservationHomeSubClusterRequest request) throws FederationStateStoreInvalidInputException {
        if (request == null) {
            String message = "Missing UpdateReservationHomeSubCluster Request. Please try again by specifying an ReservationHomeSubCluster information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        FederationReservationHomeSubClusterStoreInputValidator.checkReservationHomeSubCluster(request.getReservationHomeSubCluster());
    }

    public static void validate(DeleteReservationHomeSubClusterRequest request) throws FederationStateStoreInvalidInputException {
        if (request == null) {
            String message = "Missing DeleteReservationHomeSubCluster Request. Please try again by specifying an ReservationHomeSubCluster information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        FederationReservationHomeSubClusterStoreInputValidator.checkReservationId(request.getReservationId());
    }
}

