/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.volume.csi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.yarn.api.CsiAdaptorProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.NodePublishVolumeRequest;
import org.apache.hadoop.yarn.api.protocolrecords.NodeUnpublishVolumeRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ValidateVolumeCapabilitiesRequest;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.OCIContainerRuntime;
import org.apache.hadoop.yarn.server.volume.csi.VolumeMetaData;
import org.apache.hadoop.yarn.server.volume.csi.exception.InvalidVolumeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerVolumePublisher {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerVolumePublisher.class);
    private final Container container;
    private final String localMountRoot;
    private final OCIContainerRuntime runtime;

    public ContainerVolumePublisher(Container container, String localMountRoot, OCIContainerRuntime runtime) {
        LOG.info("Initiate container volume publisher, containerID={}, volume local mount rootDir={}", (Object)container.getContainerId().toString(), (Object)localMountRoot);
        this.container = container;
        this.localMountRoot = localMountRoot;
        this.runtime = runtime;
    }

    public Map<String, String> publishVolumes() throws YarnException, IOException {
        LOG.info("publishing volumes");
        HashMap<String, String> volumeMounts = new HashMap<String, String>();
        List<VolumeMetaData> volumes = this.getVolumes();
        LOG.info("Found {} volumes to be published on this node", (Object)volumes.size());
        for (VolumeMetaData volume : volumes) {
            Map<String, String> bindings = this.publishVolume(volume);
            if (bindings == null || bindings.isEmpty()) continue;
            volumeMounts.putAll(bindings);
        }
        return volumeMounts;
    }

    public void unpublishVolumes() throws YarnException, IOException {
        LOG.info("Un-publishing Volumes");
        List<VolumeMetaData> volumes = this.getVolumes();
        LOG.info("Volumes to un-publish {}", (Object)volumes.size());
        for (VolumeMetaData volume : volumes) {
            this.unpublishVolume(volume);
        }
    }

    private File getLocalVolumeMountPath(String containerWorkDir, String volumeId) {
        return new File(containerWorkDir, volumeId + "_mount");
    }

    private File getLocalVolumeStagingPath(String containerWorkDir, String volumeId) {
        return new File(containerWorkDir, volumeId + "_staging");
    }

    private List<VolumeMetaData> getVolumes() throws InvalidVolumeException {
        ArrayList<VolumeMetaData> volumes = new ArrayList<VolumeMetaData>();
        Resource containerResource = this.container.getResource();
        if (containerResource != null) {
            for (ResourceInformation resourceInformation : containerResource.getAllResourcesListCopy()) {
                if (!resourceInformation.getTags().contains("system:csi-volume")) continue;
                volumes.addAll(VolumeMetaData.fromResource((ResourceInformation)resourceInformation));
            }
        }
        if (volumes.size() > 0) {
            LOG.info("Total number of volumes require provisioning is {}", (Object)volumes.size());
        }
        return volumes;
    }

    private Map<String, String> publishVolume(VolumeMetaData volume) throws IOException, YarnException {
        HashMap<String, String> bindVolumes = new HashMap<String, String>();
        File localMount = this.getLocalVolumeMountPath(this.localMountRoot, volume.getVolumeId().toString());
        File localStaging = this.getLocalVolumeStagingPath(this.localMountRoot, volume.getVolumeId().toString());
        LOG.info("Volume {}, local mount path: {}, local staging path {}", new Object[]{volume.getVolumeId().toString(), localMount, localStaging});
        NodePublishVolumeRequest publishRequest = NodePublishVolumeRequest.newInstance((String)volume.getVolumeId().getId(), (boolean)false, (String)localMount.getAbsolutePath(), (String)localStaging.getAbsolutePath(), (ValidateVolumeCapabilitiesRequest.VolumeCapability)new ValidateVolumeCapabilitiesRequest.VolumeCapability(ValidateVolumeCapabilitiesRequest.AccessMode.SINGLE_NODE_WRITER, ValidateVolumeCapabilitiesRequest.VolumeType.FILE_SYSTEM, (List)ImmutableList.of()), (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
        if (this.runtime.getCsiClients().get(volume.getDriverName()) == null) {
            throw new YarnException("No csi-adaptor is found that can talk to csi-driver " + volume.getDriverName());
        }
        LOG.info("Publish volume on NM, request {}", (Object)publishRequest.toString());
        this.runtime.getCsiClients().get(volume.getDriverName()).nodePublishVolume(publishRequest);
        String containerMountPath = volume.getMountPoint();
        bindVolumes.put(localMount.getAbsolutePath(), containerMountPath);
        return bindVolumes;
    }

    private void unpublishVolume(VolumeMetaData volume) throws YarnException, IOException {
        CsiAdaptorProtocol csiClient = this.runtime.getCsiClients().get(volume.getDriverName());
        if (csiClient == null) {
            throw new YarnException("No csi-adaptor is found that can talk to csi-driver " + volume.getDriverName());
        }
        File localMount = this.getLocalVolumeMountPath(this.container.getCsiVolumesRootDir(), volume.getVolumeId().toString());
        if (!localMount.exists()) {
            LOG.info("Local mount {} no longer exist, skipping cleaning up the volume", (Object)localMount.getAbsolutePath());
            return;
        }
        NodeUnpublishVolumeRequest unpublishRequest = NodeUnpublishVolumeRequest.newInstance((String)volume.getVolumeId().getId(), (String)localMount.getAbsolutePath());
        LOG.info("Un-publish volume {}, request {}", (Object)volume.getVolumeId().toString(), (Object)unpublishRequest.toString());
        csiClient.nodeUnpublishVolume(unpublishRequest);
    }
}

