/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.util;

import rx.Observable;

public class Optional<T> {
    private final T value;
    private final boolean present;

    private Optional(T value, boolean present) {
        this.value = value;
        this.present = present;
    }

    public boolean isPresent() {
        return this.present;
    }

    public T get() {
        if (this.present) {
            return this.value;
        }
        throw new NotPresentException();
    }

    public T or(T alternative) {
        if (this.present) {
            return this.value;
        }
        return alternative;
    }

    public Observable<T> toObservable() {
        if (this.present) {
            return Observable.just(this.value);
        }
        return Observable.empty();
    }

    public static <T> Optional<T> fromNullable(T t) {
        if (t == null) {
            return Optional.absent();
        }
        return Optional.of(t);
    }

    public static <T> Optional<T> of(T t) {
        return new Optional<T>(t, true);
    }

    public static <T> Optional<T> absent() {
        return new Optional<Object>(null, false);
    }

    public static class NotPresentException
    extends RuntimeException {
        private static final long serialVersionUID = -4444814681271790328L;
    }
}

