/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import com.google.common.base.Stopwatch;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import io.netty.channel.ChannelHandlerContext;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public final class RntbdRequestArgs {
    private final UUID activityId;
    private final long birthTime;
    private final Stopwatch lifetime;
    private final String replicaPath;
    private final RxDocumentServiceRequest serviceRequest;

    public RntbdRequestArgs(RxDocumentServiceRequest serviceRequest, String replicaPath) {
        this.activityId = UUID.fromString(serviceRequest.getActivityId());
        this.birthTime = System.nanoTime();
        this.lifetime = Stopwatch.createStarted();
        this.replicaPath = StringUtils.stripEnd((String)replicaPath, (String)"/");
        this.serviceRequest = serviceRequest;
    }

    public UUID getActivityId() {
        return this.activityId;
    }

    public long getBirthTime() {
        return this.birthTime;
    }

    public Duration getLifetime() {
        return this.lifetime.elapsed();
    }

    public String getReplicaPath() {
        return this.replicaPath;
    }

    RxDocumentServiceRequest getServiceRequest() {
        return this.serviceRequest;
    }

    public String toString() {
        return "[activityId: " + this.serviceRequest.getActivityId() + ", operationType: " + this.serviceRequest.getOperationType() + ", resourceType: " + this.serviceRequest.getResourceType() + ", replicaPath: " + this.replicaPath + "]";
    }

    public void traceOperation(Logger logger, ChannelHandlerContext context, String operationName, Object ... args) {
        Objects.requireNonNull(logger);
        if (logger.isTraceEnabled()) {
            BigDecimal lifetime = BigDecimal.valueOf(this.lifetime.elapsed().toNanos(), 6);
            logger.info("{},{},\"{}({})\",\"{}\",\"{}\"", new Object[]{this.birthTime, lifetime, operationName, Stream.of(args).map(arg -> arg == null ? "null" : arg.toString()).collect(Collectors.joining(",")), this, context});
        }
    }
}

