/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.multiary;

import org.ojalgo.access.Access1D;
import org.ojalgo.function.multiary.ApproximateFunction;
import org.ojalgo.function.multiary.CompoundFunction;
import org.ojalgo.function.multiary.LinearFunction;
import org.ojalgo.function.multiary.MultiaryFunction;
import org.ojalgo.function.multiary.QuadraticFunction;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;

public final class SecondOrderApproximation<N extends Number>
extends ApproximateFunction<N> {
    private final CompoundFunction<N> myDelegate;

    public SecondOrderApproximation(MultiaryFunction.TwiceDifferentiable<N> function, Access1D<N> point) {
        super(function, point);
        PhysicalStore<double> tmpHessian = function.getHessian(point).copy();
        Object tmpGradient = ((MatrixStore.LogicalBuilder)function.getGradient(point).logical().transpose()).get();
        tmpHessian.modifyAll(tmpHessian.physical().function().multiply().first(0.5));
        QuadraticFunction<N> tmpQuadratic = new QuadraticFunction<N>(tmpHessian);
        LinearFunction tmpLinear = new LinearFunction(tmpGradient);
        this.myDelegate = new CompoundFunction<N>(tmpQuadratic, tmpLinear);
        this.myDelegate.setConstant((Number)function.invoke(point));
    }

    @Override
    public int arity() {
        return this.myDelegate.arity();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SecondOrderApproximation)) {
            return false;
        }
        SecondOrderApproximation other = (SecondOrderApproximation)obj;
        return !(this.myDelegate == null ? other.myDelegate != null : !this.myDelegate.equals(other.myDelegate));
    }

    @Override
    public MatrixStore<N> getGradient(Access1D<N> point) {
        return this.myDelegate.getGradient(this.shift(point));
    }

    @Override
    public MatrixStore<N> getHessian(Access1D<N> point) {
        return this.myDelegate.getHessian(null);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myDelegate == null ? 0 : this.myDelegate.hashCode());
        return result;
    }

    @Override
    public N invoke(Access1D<N> arg) {
        return this.myDelegate.invoke(this.shift(arg));
    }

    public String toString() {
        return this.myDelegate.toString();
    }

    @Override
    protected PhysicalStore.Factory<N, ?> factory() {
        return this.myDelegate.factory();
    }
}

