/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.ComplexNumber;

public final class MultiplyHermitianAndVector
extends MatrixOperation {
    public static final MultiplyHermitianAndVector SETUP = new MultiplyHermitianAndVector();
    public static int THRESHOLD = 256;

    public static void invoke(BigDecimal[] productMatrix, int firstRow, int rowLimit, BigDecimal[] hermitianMatrix, BigDecimal[] rightVector, int firstColumn) {
        int structure = rightVector.length;
        for (int i = firstRow; i < rowLimit; ++i) {
            int c;
            BigDecimal tmpVal = BigMath.ZERO;
            for (c = firstColumn; c < i; ++c) {
                tmpVal = tmpVal.add(hermitianMatrix[i + c * structure].multiply(rightVector[c]));
            }
            for (c = i; c < structure; ++c) {
                tmpVal = tmpVal.add(hermitianMatrix[c + i * structure].multiply(rightVector[c]));
            }
            productMatrix[i] = tmpVal;
        }
    }

    public static void invoke(ComplexNumber[] productMatrix, int firstRow, int rowLimit, ComplexNumber[] hermitianMatrix, ComplexNumber[] rightVector, int firstColumn) {
        int structure = rightVector.length;
        for (int i = firstRow; i < rowLimit; ++i) {
            int c;
            ComplexNumber tmpVal = ComplexNumber.ZERO;
            for (c = firstColumn; c < i; ++c) {
                tmpVal = tmpVal.add(hermitianMatrix[i + c * structure].multiply(rightVector[c]));
            }
            for (c = i; c < structure; ++c) {
                tmpVal = tmpVal.add(hermitianMatrix[c + i * structure].conjugate().multiply(rightVector[c]));
            }
            productMatrix[i] = tmpVal;
        }
    }

    public static void invoke(double[] productMatrix, int firstRow, int rowLimit, double[] hermitianMatrix, double[] rightVector, int firstColumn) {
        int structure = rightVector.length;
        for (int i = firstRow; i < rowLimit; ++i) {
            int c;
            double tmpVal = PrimitiveMath.ZERO;
            for (c = firstColumn; c < i; ++c) {
                tmpVal += hermitianMatrix[i + c * structure] * rightVector[c];
            }
            for (c = i; c < structure; ++c) {
                tmpVal += hermitianMatrix[c + i * structure] * rightVector[c];
            }
            productMatrix[i] = tmpVal;
        }
    }

    private MultiplyHermitianAndVector() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

