/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminEndpoint;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.rsgroup.RSGroupMajorCompactionTTL;
import org.apache.hadoop.hbase.util.compaction.TestMajorCompactorTTL;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class TestRSGroupMajorCompactionTTL
extends TestMajorCompactorTTL {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSGroupMajorCompactionTTL.class);
    private static final int NUM_SLAVES_BASE = 6;

    @Before
    public void setUp() throws Exception {
        this.utility = new HBaseTestingUtility();
        Configuration conf = this.utility.getConfiguration();
        conf.set("hbase.master.loadbalancer.class", RSGroupBasedLoadBalancer.class.getName());
        conf.set("hbase.coprocessor.master.classes", RSGroupAdminEndpoint.class.getName());
        conf.setInt("hbase.master.wait.on.regionservers.mintostart", 6);
        conf.setInt("hbase.hfile.compaction.discharger.interval", 10);
        this.utility.startMiniCluster(6);
        MiniHBaseCluster cluster = this.utility.getHBaseCluster();
        final HMaster master = cluster.getMaster();
        this.utility.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() {
                return master.isInitialized() && ((RSGroupBasedLoadBalancer)master.getLoadBalancer()).isOnline();
            }
        });
        this.admin = this.utility.getAdmin();
    }

    @After
    public void tearDown() throws Exception {
        this.utility.shutdownMiniCluster();
    }

    @Test
    public void testCompactingTables() throws Exception {
        ArrayList tableNames = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            tableNames.add(this.createTable(this.name.getMethodName() + "___" + i));
        }
        Thread.sleep(10000L);
        for (TableName tableName : tableNames) {
            int numberOfRegions = this.admin.getRegions(tableName).size();
            int numHFiles = this.utility.getNumHFiles(tableName, FAMILY);
            this.modifyTTL(tableName);
        }
        RSGroupMajorCompactionTTL compactor = new RSGroupMajorCompactionTTL();
        compactor.compactTTLRegionsOnGroup(this.utility.getConfiguration(), "default", 1, 200L, -1, -1, false, false);
        for (TableName tableName : tableNames) {
            int numberOfRegions = this.admin.getRegions(tableName).size();
            int numHFiles = this.utility.getNumHFiles(tableName, FAMILY);
            Assert.assertEquals((long)numberOfRegions, (long)numHFiles);
        }
    }
}

