/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.aircompressor;

import io.airlift.compress.lzo.LzoCompressor;
import io.airlift.compress.lzo.LzoDecompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.compress.CompressionUtil;
import org.apache.hadoop.hbase.io.compress.aircompressor.HadoopCompressor;
import org.apache.hadoop.hbase.io.compress.aircompressor.HadoopDecompressor;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class LzoCodec
implements Configurable,
CompressionCodec {
    public static final String LZO_BUFFER_SIZE_KEY = "hbase.io.compress.lzo.buffersize";
    private Configuration conf = new Configuration();
    private int bufferSize = LzoCodec.getBufferSize(this.conf);

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.bufferSize = LzoCodec.getBufferSize(conf);
    }

    public Compressor createCompressor() {
        return new HadoopLzoCompressor();
    }

    public Decompressor createDecompressor() {
        return new HadoopLzoDecompressor();
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, this.createDecompressor());
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor d) throws IOException {
        return new BlockDecompressorStream(in, d, this.bufferSize);
    }

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return this.createOutputStream(out, this.createCompressor());
    }

    public CompressionOutputStream createOutputStream(OutputStream out, Compressor c) throws IOException {
        return new BlockCompressorStream(out, c, this.bufferSize, CompressionUtil.compressionOverhead((int)this.bufferSize));
    }

    public Class<? extends Compressor> getCompressorType() {
        return HadoopLzoCompressor.class;
    }

    public Class<? extends Decompressor> getDecompressorType() {
        return HadoopLzoDecompressor.class;
    }

    public String getDefaultExtension() {
        return ".lzo";
    }

    static int getBufferSize(Configuration conf) {
        return conf.getInt(LZO_BUFFER_SIZE_KEY, conf.getInt("io.compression.codec.lzo.buffersize", 65536));
    }

    @InterfaceAudience.Private
    public class HadoopLzoDecompressor
    extends HadoopDecompressor<LzoDecompressor> {
        HadoopLzoDecompressor(LzoDecompressor decompressor) {
            super(decompressor, LzoCodec.getBufferSize(LzoCodec.this.conf));
        }

        HadoopLzoDecompressor() {
            this(new LzoDecompressor());
        }
    }

    @InterfaceAudience.Private
    public class HadoopLzoCompressor
    extends HadoopCompressor<LzoCompressor> {
        HadoopLzoCompressor(LzoCompressor compressor) {
            super(compressor, LzoCodec.getBufferSize(LzoCodec.this.conf));
        }

        HadoopLzoCompressor() {
            this(new LzoCompressor());
        }

        @Override
        int getLevel(Configuration conf) {
            return 0;
        }

        @Override
        int getBufferSize(Configuration conf) {
            return LzoCodec.getBufferSize(conf);
        }
    }
}

