/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.sequence;

import java.util.concurrent.atomic.AtomicLong;
import org.terracotta.management.sequence.BoundaryFlakeSequence;
import org.terracotta.management.sequence.IntCyclicRangeCounter;
import org.terracotta.management.sequence.NodeIdSource;
import org.terracotta.management.sequence.Sequence;
import org.terracotta.management.sequence.SequenceGenerator;
import org.terracotta.management.sequence.TimeSource;

public final class BoundaryFlakeSequenceGenerator
implements SequenceGenerator {
    private static final IntCyclicRangeCounter INSTANCE_ID = new IntCyclicRangeCounter(0, 262143);
    private final TimeSource timeSource;
    private final long nodeId;
    private final long instanceId;
    private final AtomicLong timeAndSeq = new AtomicLong();

    public BoundaryFlakeSequenceGenerator() {
        this(TimeSource.BEST, NodeIdSource.BEST);
    }

    public BoundaryFlakeSequenceGenerator(TimeSource timeSource, NodeIdSource nodeIdSource) {
        long clId = this.getClass().getClassLoader().hashCode();
        this.timeSource = timeSource;
        this.nodeId = nodeIdSource.getNodeId();
        this.instanceId = (clId << 18 | (long)(INSTANCE_ID.getAndIncrement() & 0x3FFFF)) << 18;
    }

    @Override
    public TimeSource getTimeSource() {
        return this.timeSource;
    }

    @Override
    public Sequence next() {
        block0: while (true) {
            long min = this.timeSource.getTimestamp() << 18;
            long max = min + 262143L;
            long current = this.timeAndSeq.get();
            long update = Math.max(min, current + 1L);
            while (true) {
                if (update >= max) continue block0;
                if (this.timeAndSeq.compareAndSet(current, update)) {
                    return new BoundaryFlakeSequence(update >>> 18, this.nodeId, this.instanceId | update & 0x3FFFFL);
                }
                current = this.timeAndSeq.get();
                update = Math.max(min, current + 1L);
            }
            break;
        }
    }

    long getInstanceId() {
        return this.instanceId;
    }

    long getNodeId() {
        return this.nodeId;
    }
}

