/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSnapshotFileLength {
    private static final long SEED = 0L;
    private static final short REPLICATION = 1;
    private static final int BLOCKSIZE = 1024;
    private static final Configuration conf = new Configuration();
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem hdfs;
    private final Path dir = new Path("/TestSnapshotFileLength");
    private final Path sub = new Path(this.dir, "sub1");
    private final String file1Name = "file1";
    private final String snapshot1 = "snapshot1";

    @Before
    public void setUp() throws Exception {
        conf.setLong("dfs.namenode.fs-limits.min-block-size", 1024L);
        conf.setInt("dfs.bytes-per-checksum", 1024);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        hdfs = cluster.getFileSystem();
    }

    @After
    public void tearDown() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testSnapshotfileLength() throws Exception {
        byte[] dataFromSnapshot;
        hdfs.mkdirs(this.sub);
        byte[] buffer = new byte[8192];
        int origLen = 1025;
        int toAppend = 1024;
        FSDataInputStream fis = null;
        FileStatus fileStatus = null;
        Path file1 = new Path(this.sub, "file1");
        DFSTestUtil.createFile((FileSystem)hdfs, file1, 1024, 0L, 1024L, (short)1, 0L);
        DFSTestUtil.appendFile((FileSystem)hdfs, file1, origLen);
        hdfs.allowSnapshot(this.sub);
        hdfs.createSnapshot(this.sub, "snapshot1");
        Path file1snap1 = SnapshotTestHelper.getSnapshotPath(this.sub, "snapshot1", "file1");
        FileChecksum snapChksum1 = hdfs.getFileChecksum(file1snap1);
        Assert.assertThat((String)"file and snapshot file checksums are not equal", (Object)hdfs.getFileChecksum(file1), (Matcher)CoreMatchers.is((Object)snapChksum1));
        FSDataOutputStream out = hdfs.append(file1);
        try {
            hdfs.getFileChecksum(file1);
            Assert.fail((String)"getFileChecksum should fail for files with blocks under construction");
        }
        catch (IOException ie) {
            Assert.assertTrue((boolean)ie.getMessage().contains("Fail to get checksum, since file " + file1 + " is under construction."));
        }
        Assert.assertThat((String)"snapshot checksum (post-open for append) has changed", (Object)hdfs.getFileChecksum(file1snap1), (Matcher)CoreMatchers.is((Object)snapChksum1));
        try {
            AppendTestUtil.write((OutputStream)out, 0, toAppend);
            out.hflush();
            dataFromSnapshot = DFSTestUtil.readFileBuffer((FileSystem)hdfs, file1snap1);
            Assert.assertThat((String)"Wrong data size in snapshot.", (Object)dataFromSnapshot.length, (Matcher)CoreMatchers.is((Object)origLen));
            Assert.assertThat((String)"snapshot checksum (post-append) has changed", (Object)hdfs.getFileChecksum(file1snap1), (Matcher)CoreMatchers.is((Object)snapChksum1));
        }
        finally {
            out.close();
        }
        Assert.assertThat((String)"file and snapshot file checksums (post-close) are equal", (Object)hdfs.getFileChecksum(file1), (Matcher)CoreMatchers.not((Object)snapChksum1));
        Assert.assertThat((String)"snapshot file checksum (post-close) has changed", (Object)hdfs.getFileChecksum(file1snap1), (Matcher)CoreMatchers.is((Object)snapChksum1));
        fileStatus = hdfs.getFileStatus(file1);
        Assert.assertThat((Object)fileStatus.getLen(), (Matcher)CoreMatchers.is((Object)((long)origLen + (long)toAppend)));
        fis = hdfs.open(file1);
        int bytesRead = fis.read(0L, buffer, 0, buffer.length);
        Assert.assertThat((Object)bytesRead, (Matcher)CoreMatchers.is((Object)(origLen + toAppend)));
        fis.close();
        fis = hdfs.open(file1snap1);
        fileStatus = hdfs.getFileStatus(file1snap1);
        Assert.assertThat((Object)fileStatus.getLen(), (Matcher)CoreMatchers.is((Object)origLen));
        bytesRead = fis.read(0L, buffer, 0, buffer.length);
        Assert.assertThat((Object)bytesRead, (Matcher)CoreMatchers.is((Object)origLen));
        fis.close();
        dataFromSnapshot = DFSTestUtil.readFileBuffer((FileSystem)hdfs, file1snap1);
        Assert.assertThat((String)"Wrong data size in snapshot.", (Object)dataFromSnapshot.length, (Matcher)CoreMatchers.is((Object)origLen));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testSnapshotFileLengthWithCatCommand() throws Exception {
        FSDataInputStream fis = null;
        FileStatus fileStatus = null;
        byte[] buffer = new byte[8192];
        hdfs.mkdirs(this.sub);
        Path file1 = new Path(this.sub, "file1");
        DFSTestUtil.createFile((FileSystem)hdfs, file1, 1024L, (short)1, 0L);
        hdfs.allowSnapshot(this.sub);
        hdfs.createSnapshot(this.sub, "snapshot1");
        DFSTestUtil.appendFile((FileSystem)hdfs, file1, 1024);
        fileStatus = hdfs.getFileStatus(file1);
        Assert.assertEquals((String)"Unexpected file length", (long)2048L, (long)fileStatus.getLen());
        fis = hdfs.open(file1);
        int bytesRead = fis.read(buffer, 0, buffer.length);
        Assert.assertEquals((String)"Unexpected # bytes read", (long)2048L, (long)bytesRead);
        fis.close();
        Path file1snap1 = SnapshotTestHelper.getSnapshotPath(this.sub, "snapshot1", "file1");
        fis = hdfs.open(file1snap1);
        fileStatus = hdfs.getFileStatus(file1snap1);
        Assert.assertEquals((long)fileStatus.getLen(), (long)1024L);
        bytesRead = fis.read(buffer, 0, buffer.length);
        Assert.assertEquals((String)"Unexpected # bytes read", (long)1024L, (long)bytesRead);
        fis.close();
        PrintStream outBackup = System.out;
        PrintStream errBackup = System.err;
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        System.setOut(new PrintStream(bao));
        System.setErr(new PrintStream(bao));
        FsShell shell = new FsShell();
        try {
            ToolRunner.run((Configuration)conf, (Tool)shell, (String[])new String[]{"-cat", "/TestSnapshotFileLength/sub1/.snapshot/snapshot1/file1"});
            Assert.assertEquals((String)"Unexpected # bytes from -cat", (long)1024L, (long)bao.size());
        }
        finally {
            System.setOut(outBackup);
            System.setErr(errBackup);
        }
    }
}

