/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.hbase.util.RetryCounterFactory;
import org.apache.hadoop.util.Shell;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ChaosAgent
implements Watcher,
Closeable,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ChaosAgent.class);
    static AtomicBoolean stopChaosAgent = new AtomicBoolean();
    private ZooKeeper zk;
    private String quorum;
    private String agentName;
    private Configuration conf;
    private RetryCounterFactory retryCounterFactory;
    private volatile boolean connected = false;
    Watcher newTaskCreatedWatcher = new Watcher(){

        public void process(WatchedEvent watchedEvent) {
            if (watchedEvent.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
                if (!("/hbase/chaosAgentTaskStatus/" + ChaosAgent.this.agentName).equals(watchedEvent.getPath())) {
                    throw new RuntimeException((Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.DATAINCONSISTENCY));
                }
                LOG.info("Change in Tasks Node, checking for Tasks again.");
                ChaosAgent.this.getTasks();
            }
        }
    };
    AsyncCallback.StatCallback setStatusOfTaskZNodeCallback = (rc, path, ctx, stat) -> {
        switch (KeeperException.Code.get((int)rc)) {
            case CONNECTIONLOSS: {
                try {
                    this.recreateZKConnection();
                }
                catch (Exception e) {
                    break;
                }
                this.setStatusOfTaskZNode(path, (String)ctx);
                break;
            }
            case OK: {
                LOG.info("Status of Task has been set");
                break;
            }
            case NONODE: {
                LOG.error("Chaos Agent status node does not exists: check for ZNode directory structure again.");
                break;
            }
            default: {
                LOG.error("Error while setting status of task ZNode: " + path, (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
            }
        }
    };
    AsyncCallback.StringCallback createZNodeCallback = (rc, path, ctx, name) -> {
        switch (KeeperException.Code.get((int)rc)) {
            case CONNECTIONLOSS: {
                try {
                    this.recreateZKConnection();
                }
                catch (Exception e) {
                    break;
                }
                this.createZNode(path, (byte[])ctx);
                break;
            }
            case OK: {
                LOG.info("ZNode created : " + path);
                break;
            }
            case NODEEXISTS: {
                LOG.warn("ZNode already registered: " + path);
                break;
            }
            default: {
                LOG.error("Error occurred while creating Persistent ZNode: " + path, (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
            }
        }
    };
    AsyncCallback.StringCallback createEphemeralZNodeCallback = (rc, path, ctx, name) -> {
        switch (KeeperException.Code.get((int)rc)) {
            case CONNECTIONLOSS: {
                try {
                    this.recreateZKConnection();
                }
                catch (Exception e) {
                    break;
                }
                this.createEphemeralZNode(path, (byte[])ctx);
                break;
            }
            case OK: {
                LOG.info("ZNode created : " + path);
                break;
            }
            case NODEEXISTS: {
                LOG.warn("ZNode already registered: " + path);
                break;
            }
            default: {
                LOG.error("Error occurred while creating Ephemeral ZNode: ", (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
            }
        }
    };
    AsyncCallback.DataCallback getTaskForExecutionCallback = new AsyncCallback.DataCallback(){

        public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
            switch (KeeperException.Code.get((int)rc)) {
                case CONNECTIONLOSS: {
                    try {
                        ChaosAgent.this.recreateZKConnection();
                    }
                    catch (Exception e) {
                        break;
                    }
                    ChaosAgent.this.zk.getData(path, false, ChaosAgent.this.getTaskForExecutionCallback, (Object)new String(data, StandardCharsets.UTF_8));
                    break;
                }
                case OK: {
                    String cmd = new String(data, StandardCharsets.UTF_8);
                    LOG.info("Executing command : " + cmd);
                    String status = "done";
                    try {
                        String user = ChaosAgent.this.conf.get("hbase.it.clustermanager.ssh.user", "");
                        switch (cmd.substring(0, 4)) {
                            case "bool": {
                                String ret = (String)ChaosAgent.this.execWithRetries(user, cmd.substring(4)).getSecond();
                                status = Boolean.toString(ret.length() > 0);
                                break;
                            }
                            case "exec": {
                                ChaosAgent.this.execWithRetries(user, cmd.substring(4));
                                break;
                            }
                            default: {
                                LOG.error("Unknown Command Type");
                                status = "error";
                                break;
                            }
                        }
                    }
                    catch (IOException e) {
                        LOG.error("Got error while executing command : " + cmd + " On agent : " + ChaosAgent.this.agentName + " Error : " + e);
                        status = "error";
                    }
                    try {
                        ChaosAgent.this.setStatusOfTaskZNode(path, status);
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e) {
                        LOG.error("Error occured after setting status: " + e);
                    }
                }
                default: {
                    LOG.error("Error occurred while getting data", (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                }
            }
        }
    };
    AsyncCallback.ChildrenCallback getTasksForAgentCallback = new AsyncCallback.ChildrenCallback(){

        public void processResult(int rc, String path, Object ctx, List<String> children) {
            switch (KeeperException.Code.get((int)rc)) {
                case CONNECTIONLOSS: {
                    try {
                        ChaosAgent.this.recreateZKConnection();
                    }
                    catch (Exception e) {
                        break;
                    }
                    ChaosAgent.this.getTasks();
                    break;
                }
                case OK: {
                    if (children == null) break;
                    try {
                        LOG.info("Executing each task as a separate thread");
                        ArrayList<Thread> tasksList = new ArrayList<Thread>();
                        for (String task : children) {
                            String threadName = ChaosAgent.this.agentName + "_" + task;
                            Thread t = new Thread(() -> {
                                LOG.info("Executing task : " + task + " of agent : " + ChaosAgent.this.agentName);
                                ChaosAgent.this.zk.getData("/hbase/chaosAgentTaskStatus/" + ChaosAgent.this.agentName + "/" + task, false, ChaosAgent.this.getTaskForExecutionCallback, (Object)task);
                            });
                            t.setName(threadName);
                            t.start();
                            tasksList.add(t);
                            for (Thread thread : tasksList) {
                                thread.join();
                            }
                        }
                        break;
                    }
                    catch (InterruptedException e) {
                        LOG.error("Error scheduling next task :  for agent : " + ChaosAgent.this.agentName + " Error : " + e);
                        break;
                    }
                }
                default: {
                    LOG.error("Error occurred while getting task", (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)path));
                }
            }
        }
    };

    public ChaosAgent(Configuration conf, String quorum, String agentName) {
        this.initChaosAgent(conf, quorum, agentName);
    }

    private void initChaosAgent(Configuration conf, String quorum, String agentName) {
        this.conf = conf;
        this.quorum = quorum;
        this.agentName = agentName;
        this.retryCounterFactory = new RetryCounterFactory(new RetryCounter.RetryConfig().setMaxAttempts(conf.getInt("hbase.it.clustermanager.retry.attempts", 5)).setSleepInterval(conf.getLong("hbase.it.clustermanager.retry.sleep.interval", 5000L)));
        try {
            this.createZKConnection(null);
            this.register();
        }
        catch (IOException e) {
            LOG.error("Error Creating Connection: " + e);
        }
    }

    private void createZKConnection(Watcher watcher) throws IOException {
        this.zk = watcher == null ? new ZooKeeper(this.quorum, 600000, (Watcher)this) : new ZooKeeper(this.quorum, 600000, watcher);
        LOG.info("ZooKeeper Connection created for ChaosAgent: " + this.agentName);
    }

    public void createZNode(String path, byte[] data) {
        this.zk.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, this.createZNodeCallback, (Object)data);
    }

    public void createEphemeralZNode(String path, byte[] data) {
        this.zk.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL, this.createEphemeralZNodeCallback, (Object)data);
    }

    private void createIfZNodeNotExists(String path) {
        try {
            if (this.zk.exists(path, false) == null) {
                this.createZNode(path, new byte[0]);
            }
        }
        catch (InterruptedException | KeeperException e) {
            LOG.error("Error checking given node : " + path + " " + e);
        }
    }

    public void setStatusOfTaskZNode(String taskZNode, String status) {
        LOG.info("Setting status of Task ZNode: " + taskZNode + " status : " + status);
        this.zk.setData(taskZNode, status.getBytes(StandardCharsets.UTF_8), -1, this.setStatusOfTaskZNodeCallback, null);
    }

    private void register() {
        this.createIfZNodeNotExists("/hbase");
        this.createIfZNodeNotExists("/hbase/chaosAgents");
        this.createIfZNodeNotExists("/hbase/chaosAgentTaskStatus");
        this.createIfZNodeNotExists("/hbase/chaosAgentTaskStatus/" + this.agentName);
        this.createEphemeralZNode("/hbase/chaosAgents/" + this.agentName, new byte[0]);
    }

    private void getTasks() {
        LOG.info("Getting Tasks for Agent: " + this.agentName + "and setting watch for new Tasks");
        this.zk.getChildren("/hbase/chaosAgentTaskStatus/" + this.agentName, this.newTaskCreatedWatcher, this.getTasksForAgentCallback, null);
    }

    private Pair<Integer, String> execWithRetries(String user, String cmd) throws IOException {
        RetryCounter retryCounter = this.retryCounterFactory.create();
        while (true) {
            try {
                return this.exec(user, cmd);
            }
            catch (IOException e) {
                this.retryOrThrow(retryCounter, e, user, cmd);
                try {
                    retryCounter.sleepUntilNextRetry();
                    continue;
                }
                catch (InterruptedException e2) {
                    LOG.warn("Sleep Interrupted: " + e2);
                    continue;
                }
            }
            break;
        }
    }

    private Pair<Integer, String> exec(String user, String cmd) throws IOException {
        LOG.info("Executing Shell command: " + cmd + " , user: " + user);
        LocalShell shell = new LocalShell(user, cmd);
        try {
            shell.execute();
        }
        catch (Shell.ExitCodeException e) {
            String output = shell.getOutput();
            throw new Shell.ExitCodeException(e.getExitCode(), "stderr: " + e.getMessage() + ", stdout: " + output);
        }
        LOG.info("Executed Shell command, exit code: {}, output n{}", (Object)shell.getExitCode(), (Object)shell.getOutput());
        return new Pair((Object)shell.getExitCode(), (Object)shell.getOutput());
    }

    private <E extends Exception> void retryOrThrow(RetryCounter retryCounter, E ex, String user, String cmd) throws E {
        if (retryCounter.shouldRetry()) {
            LOG.warn("Local command: {}, user: {}, failed at attempt {}. Retrying until maxAttempts: {}.Exception {}", new Object[]{cmd, user, retryCounter.getAttemptTimes(), retryCounter.getMaxAttempts(), ex.getMessage()});
            return;
        }
        throw ex;
    }

    private boolean isConnected() {
        return this.connected;
    }

    @Override
    public void close() throws IOException {
        LOG.info("Closing ZooKeeper Connection for Chaos Agent : " + this.agentName);
        try {
            this.zk.close();
        }
        catch (InterruptedException e) {
            LOG.error("Error while closing ZooKeeper Connection.");
        }
    }

    @Override
    public void run() {
        try {
            LOG.info("Running Chaos Agent on : " + this.agentName);
            while (!this.isConnected()) {
                Thread.sleep(100L);
            }
            this.getTasks();
            while (!stopChaosAgent.get()) {
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            LOG.error("Error while running Chaos Agent", (Throwable)e);
        }
    }

    public void process(WatchedEvent watchedEvent) {
        LOG.info("Processing event: " + watchedEvent.toString());
        if (watchedEvent.getType() == Watcher.Event.EventType.None) {
            switch (watchedEvent.getState()) {
                case SyncConnected: {
                    this.connected = true;
                    break;
                }
                case Disconnected: {
                    this.connected = false;
                    break;
                }
                case Expired: {
                    this.connected = false;
                    LOG.error("Session expired creating again");
                    try {
                        this.createZKConnection(null);
                    }
                    catch (IOException e) {
                        LOG.error("Error creating Zookeeper connection", (Throwable)e);
                    }
                }
                default: {
                    LOG.error("Unknown State");
                }
            }
        }
    }

    private void recreateZKConnection() throws Exception {
        try {
            this.zk.close();
            this.createZKConnection(this.newTaskCreatedWatcher);
            this.createEphemeralZNode("/hbase/chaosAgents/" + this.agentName, new byte[0]);
        }
        catch (IOException e) {
            LOG.error("Error creating new ZK COnnection for agent: {}", (Object)(this.agentName + e));
            throw e;
        }
    }

    protected static class LocalShell
    extends Shell.ShellCommandExecutor {
        private String user;
        private String execCommand;

        public LocalShell(String user, String execCommand) {
            super(new String[]{execCommand});
            this.user = user;
            this.execCommand = execCommand;
        }

        public String[] getExecString() {
            if (!this.user.equals("")) {
                this.execCommand = String.format("su -u %1$s %2$s", this.user, this.execCommand);
            }
            return new String[]{"/usr/bin/env", "bash", "-c", this.execCommand};
        }

        public void execute() throws IOException {
            super.execute();
        }
    }
}

