/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import org.apache.hadoop.hbase.io.MetricsIOSource;
import org.apache.hadoop.hbase.io.MetricsIOWrapper;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsIOSourceImpl
extends BaseSourceImpl
implements MetricsIOSource {
    private final MetricsIOWrapper wrapper;
    private final MetricHistogram fsReadTimeHisto;
    private final MetricHistogram fsPReadTimeHisto;
    private final MetricHistogram fsWriteTimeHisto;
    private final MutableFastCounter fsSlowReads;

    public MetricsIOSourceImpl(MetricsIOWrapper wrapper) {
        this("IO", "Metrics about FileSystem IO", "regionserver", "RegionServer,sub=IO", wrapper);
    }

    public MetricsIOSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsIOWrapper wrapper) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.wrapper = wrapper;
        this.fsReadTimeHisto = this.getMetricsRegistry().newTimeHistogram("fsReadTime", "Latency of HFile's sequential reads on this region server in milliseconds");
        this.fsPReadTimeHisto = this.getMetricsRegistry().newTimeHistogram("fsPReadTime", "Latency of HFile's positional reads on this region server in milliseconds");
        this.fsWriteTimeHisto = this.getMetricsRegistry().newTimeHistogram("fsWriteTime", "Latency of HFile's writes on this region server in milliseconds");
        this.fsSlowReads = this.getMetricsRegistry().newCounter("fsSlowReadsCount", "Number of HFile reads which were slower than a configured threshold", 0L);
    }

    @Override
    public void updateFsReadTime(long t) {
        this.fsReadTimeHisto.add(t);
    }

    @Override
    public void updateFsPReadTime(long t) {
        this.fsPReadTimeHisto.add(t);
    }

    @Override
    public void updateFsWriteTime(long t) {
        this.fsWriteTimeHisto.add(t);
    }

    @Override
    public void incrSlowFsRead() {
        this.fsSlowReads.incr();
    }

    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder mrb = metricsCollector.addRecord(this.metricsName);
        if (this.wrapper != null) {
            mrb.addCounter(Interns.info((String)"fsChecksumFailureCount", (String)"Number of checksum failures for the HBase HFile checksums at the HBase level (separate from HDFS checksums)"), this.wrapper.getChecksumFailures());
        }
        this.metricsRegistry.snapshot(mrb, all);
    }
}

