/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.codec.KeyValueCodecWithTags;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestReplicationWithWALExtendedAttributes {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationWithWALExtendedAttributes.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationWithWALExtendedAttributes.class);
    private static Configuration conf1 = HBaseConfiguration.create();
    private static Admin replicationAdmin;
    private static Connection connection1;
    private static Table htable1;
    private static Table htable2;
    private static HBaseTestingUtility utility1;
    private static HBaseTestingUtility utility2;
    private static final long SLEEP_TIME = 500L;
    private static final int NB_RETRIES = 10;
    private static final TableName TABLE_NAME;
    private static final byte[] FAMILY;
    private static final byte[] ROW;
    private static final byte[] ROW2;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Throwable throwable;
        Admin admin;
        conf1.set("zookeeper.znode.parent", "/1");
        conf1.setInt("replication.source.size.capacity", 10240);
        conf1.setLong("replication.source.sleepforretries", 100L);
        conf1.setInt("hbase.regionserver.maxlogs", 10);
        conf1.setLong("hbase.master.logcleaner.ttl", 10L);
        conf1.setInt("zookeeper.recovery.retry", 1);
        conf1.setInt("zookeeper.recovery.retry.intervalmill", 10);
        conf1.setLong("hbase.server.thread.wakefrequency", 100L);
        conf1.setInt("replication.stats.thread.period.seconds", 5);
        conf1.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        conf1.setStrings("hbase.replication.rpc.codec", new String[]{KeyValueCodecWithTags.class.getName()});
        conf1.setStrings("hbase.coprocessor.user.region.classes", new String[]{TestCoprocessorForWALAnnotationAtSource.class.getName()});
        utility1 = new HBaseTestingUtility(conf1);
        utility1.startMiniZKCluster();
        MiniZooKeeperCluster miniZK = utility1.getZkCluster();
        conf1 = utility1.getConfiguration();
        LOG.info("Setup first Zk");
        Configuration conf2 = HBaseConfiguration.create((Configuration)conf1);
        conf2.setInt("hfile.format.version", 3);
        conf2.set("zookeeper.znode.parent", "/2");
        conf2.setInt("hbase.client.retries.number", 6);
        conf2.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        conf2.setStrings("hbase.replication.rpc.codec", new String[]{KeyValueCodecWithTags.class.getName()});
        conf2.setStrings("hbase.coprocessor.user.region.classes", new String[]{TestCoprocessorForWALAnnotationAtSink.class.getName()});
        conf2.setStrings("hbase.coprocessor.regionserver.classes", new String[]{TestReplicationSinkRegionServerEndpoint.class.getName()});
        utility2 = new HBaseTestingUtility(conf2);
        utility2.setZkCluster(miniZK);
        LOG.info("Setup second Zk");
        utility1.startMiniCluster(2);
        utility2.startMiniCluster(2);
        connection1 = ConnectionFactory.createConnection((Configuration)conf1);
        replicationAdmin = connection1.getAdmin();
        ReplicationPeerConfig rpc = ReplicationPeerConfig.newBuilder().setClusterKey(utility2.getClusterKey()).build();
        replicationAdmin.addReplicationPeer("2", rpc);
        TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).setMaxVersions(3).setScope(1).build()).build();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf1);){
            admin = conn.getAdmin();
            throwable = null;
            try {
                admin.createTable(tableDescriptor, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (admin != null) {
                    if (throwable != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
        }
        conn = ConnectionFactory.createConnection((Configuration)conf2);
        var5_5 = null;
        try {
            admin = conn.getAdmin();
            throwable = null;
            try {
                admin.createTable(tableDescriptor, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (admin != null) {
                    if (throwable != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var5_5 = throwable6;
            throw throwable6;
        }
        finally {
            if (conn != null) {
                if (var5_5 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable7) {
                        var5_5.addSuppressed(throwable7);
                    }
                } else {
                    conn.close();
                }
            }
        }
        htable1 = utility1.getConnection().getTable(TABLE_NAME);
        htable2 = utility2.getConnection().getTable(TABLE_NAME);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        Closeables.close((Closeable)replicationAdmin, (boolean)true);
        Closeables.close((Closeable)connection1, (boolean)true);
        utility2.shutdownMiniCluster();
        utility1.shutdownMiniCluster();
    }

    @Test
    public void testReplicationWithWALExtendedAttributes() throws Exception {
        Put put = new Put(ROW);
        put.addColumn(FAMILY, ROW, ROW);
        htable1 = utility1.getConnection().getTable(TABLE_NAME);
        htable1.put(put);
        Put put2 = new Put(ROW2);
        put2.addColumn(FAMILY, ROW2, ROW2);
        htable1.batch(Collections.singletonList(put2), new Object[1]);
        TestReplicationWithWALExtendedAttributes.assertGetValues(new Get(ROW), ROW);
        TestReplicationWithWALExtendedAttributes.assertGetValues(new Get(ROW2), ROW2);
    }

    private static void assertGetValues(Get get, byte[] value) throws IOException, InterruptedException {
        for (int i = 0; i < 10; ++i) {
            Result res;
            if (i == 9) {
                Assert.fail((String)"Waited too much time for put replication");
            }
            if (!(res = htable2.get(get)).isEmpty()) {
                Assert.assertArrayEquals((byte[])value, (byte[])res.value());
                break;
            }
            LOG.info("Row not available");
            Thread.sleep(500L);
        }
    }

    static {
        TABLE_NAME = TableName.valueOf((String)"TestReplicationWithWALAnnotation");
        FAMILY = Bytes.toBytes((String)"f");
        ROW = Bytes.toBytes((String)"row");
        ROW2 = Bytes.toBytes((String)"row2");
    }

    public static final class TestReplicationSinkRegionServerEndpoint
    implements RegionServerCoprocessor,
    RegionServerObserver {
        public Optional<RegionServerObserver> getRegionServerObserver() {
            return Optional.of(this);
        }

        public void preReplicationSinkBatchMutate(ObserverContext<RegionServerCoprocessorEnvironment> ctx, AdminProtos.WALEntry walEntry, Mutation mutation) throws IOException {
            super.preReplicationSinkBatchMutate(ctx, walEntry, mutation);
            List attributeList = walEntry.getKey().getExtendedAttributesList();
            this.attachWALExtendedAttributesToMutation(mutation, attributeList);
        }

        public void postReplicationSinkBatchMutate(ObserverContext<RegionServerCoprocessorEnvironment> ctx, AdminProtos.WALEntry walEntry, Mutation mutation) throws IOException {
            super.postReplicationSinkBatchMutate(ctx, walEntry, mutation);
            LOG.info("WALEntry extended attributes: {}", (Object)walEntry.getKey().getExtendedAttributesList());
            LOG.info("Mutation attributes: {}", (Object)mutation.getAttributesMap());
        }

        private void attachWALExtendedAttributesToMutation(Mutation mutation, List<WALProtos.Attribute> attributeList) {
            if (attributeList != null) {
                for (WALProtos.Attribute attribute : attributeList) {
                    mutation.setAttribute(attribute.getKey(), attribute.getValue().toByteArray());
                }
            }
        }
    }

    public static class TestCoprocessorForWALAnnotationAtSink
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit) throws IOException {
            String attrVal1 = Bytes.toString((byte[])put.getAttribute("extendedAttr1"));
            String attrVal2 = Bytes.toString((byte[])put.getAttribute("extendedAttr2"));
            if (attrVal1 == null || attrVal2 == null) {
                throw new IOException("Failed to retrieve WAL annotations");
            }
            if (attrVal1.equals("Value of Extended attribute 01") && attrVal2.equals("Value of Extended attribute 02")) {
                return;
            }
            throw new IOException("Failed to retrieve WAL annotations..");
        }

        public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            String attrVal1 = Bytes.toString((byte[])((Mutation)miniBatchOp.getOperation(0)).getAttribute("extendedAttr1"));
            String attrVal2 = Bytes.toString((byte[])((Mutation)miniBatchOp.getOperation(0)).getAttribute("extendedAttr2"));
            if (attrVal1 == null || attrVal2 == null) {
                throw new IOException("Failed to retrieve WAL annotations");
            }
            if (attrVal1.equals("Value of Extended attribute 01") && attrVal2.equals("Value of Extended attribute 02")) {
                return;
            }
            throw new IOException("Failed to retrieve WAL annotations..");
        }
    }

    public static class TestCoprocessorForWALAnnotationAtSource
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preWALAppend(ObserverContext<RegionCoprocessorEnvironment> ctx, WALKey key, WALEdit edit) throws IOException {
            key.addExtendedAttribute("extendedAttr1", Bytes.toBytes((String)"Value of Extended attribute 01"));
            key.addExtendedAttribute("extendedAttr2", Bytes.toBytes((String)"Value of Extended attribute 02"));
        }
    }
}

