/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import java.util.List;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupType;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class BackupRequest {
    private BackupType type;
    private List<TableName> tableList;
    private String targetRootDir;
    private int totalTasks = -1;
    private long bandwidth = -1L;
    private boolean noChecksumVerify = false;
    private String backupSetName;
    private String yarnPoolName;

    private BackupRequest() {
    }

    private BackupRequest setBackupType(BackupType type) {
        this.type = type;
        return this;
    }

    public BackupType getBackupType() {
        return this.type;
    }

    private BackupRequest setTableList(List<TableName> tableList) {
        this.tableList = tableList;
        return this;
    }

    public List<TableName> getTableList() {
        return this.tableList;
    }

    private BackupRequest setTargetRootDir(String targetRootDir) {
        this.targetRootDir = targetRootDir;
        return this;
    }

    public String getTargetRootDir() {
        return this.targetRootDir;
    }

    private BackupRequest setTotalTasks(int totalTasks) {
        this.totalTasks = totalTasks;
        return this;
    }

    public int getTotalTasks() {
        return this.totalTasks;
    }

    private BackupRequest setBandwidth(long bandwidth) {
        this.bandwidth = bandwidth;
        return this;
    }

    public long getBandwidth() {
        return this.bandwidth;
    }

    private BackupRequest setNoChecksumVerify(boolean noChecksumVerify) {
        this.noChecksumVerify = noChecksumVerify;
        return this;
    }

    public boolean getNoChecksumVerify() {
        return this.noChecksumVerify;
    }

    public String getBackupSetName() {
        return this.backupSetName;
    }

    private BackupRequest setBackupSetName(String backupSetName) {
        this.backupSetName = backupSetName;
        return this;
    }

    public String getYarnPoolName() {
        return this.yarnPoolName;
    }

    public void setYarnPoolName(String yarnPoolName) {
        this.yarnPoolName = yarnPoolName;
    }

    public static class Builder {
        BackupRequest request = new BackupRequest();

        public Builder withBackupType(BackupType type) {
            this.request.setBackupType(type);
            return this;
        }

        public Builder withTableList(List<TableName> tables) {
            this.request.setTableList(tables);
            return this;
        }

        public Builder withTargetRootDir(String backupDir) {
            this.request.setTargetRootDir(backupDir);
            return this;
        }

        public Builder withBackupSetName(String setName) {
            this.request.setBackupSetName(setName);
            return this;
        }

        public Builder withTotalTasks(int numTasks) {
            this.request.setTotalTasks(numTasks);
            return this;
        }

        public Builder withBandwidthPerTasks(int bandwidth) {
            this.request.setBandwidth(bandwidth);
            return this;
        }

        public Builder withNoChecksumVerify(boolean noChecksumVerify) {
            this.request.setNoChecksumVerify(noChecksumVerify);
            return this;
        }

        public Builder withYarnPoolName(String name) {
            this.request.setYarnPoolName(name);
            return this;
        }

        public BackupRequest build() {
            return this.request;
        }
    }
}

