/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.master.region.MasterRegion;
import org.apache.hadoop.hbase.master.region.MasterRegionFactory;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class MasterStateStore {
    private static final Logger LOG = LoggerFactory.getLogger(MasterStateStore.class);
    private static final byte[] QUALIFIER = Bytes.toBytes("d");
    private final MasterRegion masterRegion;
    private final byte[] stateName;

    protected MasterStateStore(MasterRegion masterRegion, String stateName, ZKWatcher watcher, String zkPath) throws IOException, KeeperException {
        this.masterRegion = masterRegion;
        this.stateName = Bytes.toBytes(stateName);
        this.tryMigrate(watcher, zkPath);
    }

    protected final byte[] getState() throws IOException {
        return this.get().getValue(MasterRegionFactory.STATE_FAMILY, QUALIFIER);
    }

    protected final void setState(byte[] state) throws IOException {
        this.update(state);
    }

    private Result get() throws IOException {
        return this.masterRegion.get(new Get(this.stateName).addColumn(MasterRegionFactory.STATE_FAMILY, QUALIFIER));
    }

    private void update(byte[] s2) throws IOException {
        this.masterRegion.update(r -> r.put(new Put(this.stateName).addColumn(MasterRegionFactory.STATE_FAMILY, QUALIFIER, s2)));
    }

    private byte[] migrate(ZKWatcher watcher, String zkPath) throws KeeperException, IOException {
        byte[] zkData = ZKUtil.getDataNoWatch(watcher, zkPath, null);
        if (zkData == null || zkData.length == 0) {
            return null;
        }
        this.update(zkData);
        return zkData;
    }

    private void tryMigrate(ZKWatcher watcher, String zkPath) throws IOException, KeeperException {
        if (zkPath == null) {
            return;
        }
        Result result = this.get();
        if (result.isEmpty()) {
            this.migrate(watcher, zkPath);
        }
        try {
            ZKUtil.deleteNodeFailSilent(watcher, zkPath);
        }
        catch (Exception e) {
            LOG.warn("failed to delete migrated zk state node {}, ignore and continue", (Object)zkPath);
        }
    }
}

