/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.metrics.JvmPauseMonitorSource;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapperStub;
import org.apache.hadoop.hbase.regionserver.metrics.MetricsTableRequests;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.JvmPauseMonitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestMetricsRegionServer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetricsRegionServer.class);
    public static MetricsAssertHelper HELPER = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);
    private MetricsRegionServerWrapperStub wrapper;
    private MetricsRegionServer rsm;
    private MetricsRegionServerSource serverSource;

    @BeforeClass
    public static void classSetUp() {
        HELPER.init();
    }

    @Before
    public void setUp() {
        this.wrapper = new MetricsRegionServerWrapperStub();
        Configuration conf = new Configuration(false);
        conf.setBoolean("hbase.regionserver.enable.server.query.meter", false);
        this.rsm = new MetricsRegionServer((MetricsRegionServerWrapper)this.wrapper, conf, null);
        this.serverSource = this.rsm.getMetricsSource();
    }

    @Test
    public void testWrapperSource() {
        HELPER.assertTag("serverName", "test", (BaseSource)this.serverSource);
        HELPER.assertTag("clusterId", "tClusterId", (BaseSource)this.serverSource);
        HELPER.assertTag("zookeeperQuorum", "zk", (BaseSource)this.serverSource);
        HELPER.assertGauge("regionServerStartTime", 100L, (BaseSource)this.serverSource);
        HELPER.assertGauge("regionCount", 101L, (BaseSource)this.serverSource);
        HELPER.assertGauge("storeCount", 2L, (BaseSource)this.serverSource);
        HELPER.assertGauge("maxStoreFileCount", 23L, (BaseSource)this.serverSource);
        HELPER.assertGauge("maxStoreFileAge", 2L, (BaseSource)this.serverSource);
        HELPER.assertGauge("minStoreFileAge", 2L, (BaseSource)this.serverSource);
        HELPER.assertGauge("avgStoreFileAge", 2L, (BaseSource)this.serverSource);
        HELPER.assertGauge("numReferenceFiles", 2L, (BaseSource)this.serverSource);
        HELPER.assertGauge("hlogFileCount", 10L, (BaseSource)this.serverSource);
        HELPER.assertGauge("hlogFileSize", 1024000L, (BaseSource)this.serverSource);
        HELPER.assertGauge("storeFileCount", 300L, (BaseSource)this.serverSource);
        HELPER.assertGauge("memstoreSize", 1025L, (BaseSource)this.serverSource);
        HELPER.assertGauge("memstoreHeapSize", 500L, (BaseSource)this.serverSource);
        HELPER.assertGauge("memstoreOffHeapSize", 600L, (BaseSource)this.serverSource);
        HELPER.assertGauge("storeFileSize", 1900L, (BaseSource)this.serverSource);
        HELPER.assertCounter("totalRequestCount", 899L, (BaseSource)this.serverSource);
        HELPER.assertCounter("totalRowActionRequestCount", HELPER.getCounter("readRequestCount", (BaseSource)this.serverSource) + HELPER.getCounter("writeRequestCount", (BaseSource)this.serverSource), (BaseSource)this.serverSource);
        HELPER.assertCounter("readRequestCount", 997L, (BaseSource)this.serverSource);
        HELPER.assertCounter("filteredReadRequestCount", 1997L, (BaseSource)this.serverSource);
        HELPER.assertCounter("writeRequestCount", 707L, (BaseSource)this.serverSource);
        HELPER.assertCounter("checkMutateFailedCount", 401L, (BaseSource)this.serverSource);
        HELPER.assertCounter("checkMutatePassedCount", 405L, (BaseSource)this.serverSource);
        HELPER.assertGauge("storeFileIndexSize", 406L, (BaseSource)this.serverSource);
        HELPER.assertGauge("staticIndexSize", 407L, (BaseSource)this.serverSource);
        HELPER.assertGauge("staticBloomSize", 408L, (BaseSource)this.serverSource);
        HELPER.assertGauge("mutationsWithoutWALCount", 409L, (BaseSource)this.serverSource);
        HELPER.assertGauge("mutationsWithoutWALSize", 410L, (BaseSource)this.serverSource);
        HELPER.assertCounter("bloomFilterRequestsCount", 411L, (BaseSource)this.serverSource);
        HELPER.assertCounter("bloomFilterNegativeResultsCount", 412L, (BaseSource)this.serverSource);
        HELPER.assertCounter("bloomFilterEligibleRequestsCount", 413L, (BaseSource)this.serverSource);
        HELPER.assertGauge("percentFilesLocal", 99L, (BaseSource)this.serverSource);
        HELPER.assertGauge("percentFilesLocalSecondaryRegions", 99L, (BaseSource)this.serverSource);
        HELPER.assertGauge("compactionQueueLength", 411L, (BaseSource)this.serverSource);
        HELPER.assertGauge("flushQueueLength", 412L, (BaseSource)this.serverSource);
        HELPER.assertGauge("blockCacheFreeSize", 413L, (BaseSource)this.serverSource);
        HELPER.assertGauge("blockCacheCount", 414L, (BaseSource)this.serverSource);
        HELPER.assertGauge("blockCacheDataBlockCount", 300L, (BaseSource)this.serverSource);
        HELPER.assertGauge("blockCacheSize", 415L, (BaseSource)this.serverSource);
        HELPER.assertCounter("blockCacheHitCount", 416L, (BaseSource)this.serverSource);
        HELPER.assertCounter("blockCacheHitCachingCount", 16L, (BaseSource)this.serverSource);
        HELPER.assertCounter("blockCacheMissCount", 417L, (BaseSource)this.serverSource);
        HELPER.assertCounter("blockCacheMissCachingCount", 17L, (BaseSource)this.serverSource);
        HELPER.assertCounter("blockCacheEvictionCount", 418L, (BaseSource)this.serverSource);
        HELPER.assertGauge("blockCacheCountHitPercent", 98L, (BaseSource)this.serverSource);
        HELPER.assertGauge("blockCacheExpressHitPercent", 97L, (BaseSource)this.serverSource);
        HELPER.assertCounter("blockCacheFailedInsertionCount", 36L, (BaseSource)this.serverSource);
        HELPER.assertGauge("l1CacheFreeSize", 100L, (BaseSource)this.serverSource);
        HELPER.assertGauge("l1CacheSize", 123L, (BaseSource)this.serverSource);
        HELPER.assertGauge("l1CacheCount", 50L, (BaseSource)this.serverSource);
        HELPER.assertCounter("l1CacheEvictionCount", 1000L, (BaseSource)this.serverSource);
        HELPER.assertGauge("l1CacheHitCount", 200L, (BaseSource)this.serverSource);
        HELPER.assertGauge("l1CacheMissCount", 100L, (BaseSource)this.serverSource);
        HELPER.assertGauge("l1CacheHitRatio", 80L, (BaseSource)this.serverSource);
        HELPER.assertGauge("l1CacheMissRatio", 20L, (BaseSource)this.serverSource);
        HELPER.assertGauge("l2CacheFreeSize", 200L, (BaseSource)this.serverSource);
        HELPER.assertGauge("l2CacheSize", 456L, (BaseSource)this.serverSource);
        HELPER.assertGauge("l2CacheCount", 75L, (BaseSource)this.serverSource);
        HELPER.assertCounter("l2CacheEvictionCount", 2000L, (BaseSource)this.serverSource);
        HELPER.assertGauge("l2CacheHitCount", 800L, (BaseSource)this.serverSource);
        HELPER.assertGauge("l2CacheMissCount", 200L, (BaseSource)this.serverSource);
        HELPER.assertGauge("l2CacheHitRatio", 90L, (BaseSource)this.serverSource);
        HELPER.assertGauge("l2CacheMissRatio", 10L, (BaseSource)this.serverSource);
        HELPER.assertCounter("updatesBlockedTime", 419L, (BaseSource)this.serverSource);
    }

    @Test
    public void testConstuctor() {
        Assert.assertNotNull((String)"There should be a hadoop1/hadoop2 metrics source", (Object)this.rsm.getMetricsSource());
        Assert.assertNotNull((String)"The RegionServerMetricsWrapper should be accessable", (Object)this.rsm.getRegionServerWrapper());
    }

    @Test
    public void testSlowCount() {
        int i;
        HRegion region = (HRegion)Mockito.mock(HRegion.class);
        MetricsTableRequests metricsTableRequests = (MetricsTableRequests)Mockito.mock(MetricsTableRequests.class);
        Mockito.when((Object)region.getMetricsTableRequests()).thenReturn((Object)metricsTableRequests);
        Mockito.when((Object)metricsTableRequests.isEnableTableLatenciesMetrics()).thenReturn((Object)false);
        Mockito.when((Object)metricsTableRequests.isEnabTableQueryMeterMetrics()).thenReturn((Object)false);
        for (i = 0; i < 12; ++i) {
            this.rsm.updateAppend(region, 12L, 120L);
            this.rsm.updateAppend(region, 1002L, 10020L);
        }
        for (i = 0; i < 13; ++i) {
            this.rsm.updateDeleteBatch(region, 13L);
            this.rsm.updateDeleteBatch(region, 1003L);
        }
        for (i = 0; i < 14; ++i) {
            this.rsm.updateGet(region, 14L, 140L);
            this.rsm.updateGet(region, 1004L, 10040L);
        }
        for (i = 0; i < 15; ++i) {
            this.rsm.updateIncrement(region, 15L, 150L);
            this.rsm.updateIncrement(region, 1005L, 10050L);
        }
        for (i = 0; i < 16; ++i) {
            this.rsm.updatePutBatch(region, 16L);
            this.rsm.updatePutBatch(region, 1006L);
        }
        for (i = 0; i < 17; ++i) {
            this.rsm.updatePut(region, 17L);
            this.rsm.updateDelete(region, 17L);
            this.rsm.updatePut(region, 1006L);
            this.rsm.updateDelete(region, 1003L);
            this.rsm.updateCheckAndDelete(region, 17L);
            this.rsm.updateCheckAndPut(region, 17L);
            this.rsm.updateCheckAndMutate(region, 17L, 170L);
        }
        HELPER.assertCounter("blockBytesScannedCount", 420090L, (BaseSource)this.serverSource);
        HELPER.assertCounter("appendNumOps", 24L, (BaseSource)this.serverSource);
        HELPER.assertCounter("appendBlockBytesScannedNumOps", 24L, (BaseSource)this.serverSource);
        HELPER.assertCounter("deleteBatchNumOps", 26L, (BaseSource)this.serverSource);
        HELPER.assertCounter("getNumOps", 28L, (BaseSource)this.serverSource);
        HELPER.assertCounter("getBlockBytesScannedNumOps", 28L, (BaseSource)this.serverSource);
        HELPER.assertCounter("incrementNumOps", 30L, (BaseSource)this.serverSource);
        HELPER.assertCounter("incrementBlockBytesScannedNumOps", 30L, (BaseSource)this.serverSource);
        HELPER.assertCounter("putBatchNumOps", 32L, (BaseSource)this.serverSource);
        HELPER.assertCounter("putNumOps", 34L, (BaseSource)this.serverSource);
        HELPER.assertCounter("deleteNumOps", 34L, (BaseSource)this.serverSource);
        HELPER.assertCounter("checkAndDeleteNumOps", 17L, (BaseSource)this.serverSource);
        HELPER.assertCounter("checkAndPutNumOps", 17L, (BaseSource)this.serverSource);
        HELPER.assertCounter("checkAndMutateNumOps", 17L, (BaseSource)this.serverSource);
        HELPER.assertCounter("checkAndMutateBlockBytesScannedNumOps", 17L, (BaseSource)this.serverSource);
        HELPER.assertCounter("slowAppendCount", 12L, (BaseSource)this.serverSource);
        HELPER.assertCounter("slowDeleteCount", 17L, (BaseSource)this.serverSource);
        HELPER.assertCounter("slowGetCount", 14L, (BaseSource)this.serverSource);
        HELPER.assertCounter("slowIncrementCount", 15L, (BaseSource)this.serverSource);
        HELPER.assertCounter("slowPutCount", 17L, (BaseSource)this.serverSource);
    }

    @Test
    public void testFlush() {
        this.rsm.updateFlush(null, 1L, 2L, 3L);
        HELPER.assertCounter("flushTime_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("flushMemstoreSize_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("flushOutputSize_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("flushedMemstoreBytes", 2L, (BaseSource)this.serverSource);
        HELPER.assertCounter("flushedOutputBytes", 3L, (BaseSource)this.serverSource);
        this.rsm.updateFlush(null, 10L, 20L, 30L);
        HELPER.assertCounter("flushTimeNumOps", 2L, (BaseSource)this.serverSource);
        HELPER.assertCounter("flushMemstoreSize_num_ops", 2L, (BaseSource)this.serverSource);
        HELPER.assertCounter("flushOutputSize_num_ops", 2L, (BaseSource)this.serverSource);
        HELPER.assertCounter("flushedMemstoreBytes", 22L, (BaseSource)this.serverSource);
        HELPER.assertCounter("flushedOutputBytes", 33L, (BaseSource)this.serverSource);
    }

    @Test
    public void testCompaction() {
        this.rsm.updateCompaction(null, false, 1L, 2, 3, 4L, 5L);
        HELPER.assertCounter("compactionTime_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactionInputFileCount_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactionInputSize_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactionOutputFileCount_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactedInputBytes", 4L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactedoutputBytes", 5L, (BaseSource)this.serverSource);
        this.rsm.updateCompaction(null, false, 10L, 20, 30, 40L, 50L);
        HELPER.assertCounter("compactionTime_num_ops", 2L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactionInputFileCount_num_ops", 2L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactionInputSize_num_ops", 2L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactionOutputFileCount_num_ops", 2L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactedInputBytes", 44L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactedoutputBytes", 55L, (BaseSource)this.serverSource);
        this.rsm.updateCompaction(null, true, 100L, 200, 300, 400L, 500L);
        HELPER.assertCounter("compactionTime_num_ops", 3L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactionInputFileCount_num_ops", 3L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactionInputSize_num_ops", 3L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactionOutputFileCount_num_ops", 3L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactedInputBytes", 444L, (BaseSource)this.serverSource);
        HELPER.assertCounter("compactedoutputBytes", 555L, (BaseSource)this.serverSource);
        HELPER.assertCounter("majorCompactionTime_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("majorCompactionInputFileCount_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("majorCompactionInputSize_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("majorCompactionOutputFileCount_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("majorCompactedInputBytes", 400L, (BaseSource)this.serverSource);
        HELPER.assertCounter("majorCompactedoutputBytes", 500L, (BaseSource)this.serverSource);
    }

    @Test
    public void testPauseMonitor() {
        Configuration conf = new Configuration();
        conf.setLong("jvm.pause.info-threshold.ms", 1000L);
        conf.setLong("jvm.pause.warn-threshold.ms", 10000L);
        JvmPauseMonitor monitor = new JvmPauseMonitor(conf, (JvmPauseMonitorSource)this.serverSource);
        monitor.updateMetrics(1500L, false);
        HELPER.assertCounter("pauseInfoThresholdExceeded", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("pauseWarnThresholdExceeded", 0L, (BaseSource)this.serverSource);
        HELPER.assertCounter("pauseTimeWithoutGc_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("pauseTimeWithGc_num_ops", 0L, (BaseSource)this.serverSource);
        monitor.updateMetrics(15000L, true);
        HELPER.assertCounter("pauseInfoThresholdExceeded", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("pauseWarnThresholdExceeded", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("pauseTimeWithoutGc_num_ops", 1L, (BaseSource)this.serverSource);
        HELPER.assertCounter("pauseTimeWithGc_num_ops", 1L, (BaseSource)this.serverSource);
    }

    @Test
    public void testTableQueryMeterSwitch() {
        HRegion region = (HRegion)Mockito.mock(HRegion.class);
        MetricsTableRequests metricsTableRequests = (MetricsTableRequests)Mockito.mock(MetricsTableRequests.class);
        Mockito.when((Object)region.getMetricsTableRequests()).thenReturn((Object)metricsTableRequests);
        Mockito.when((Object)metricsTableRequests.isEnableTableLatenciesMetrics()).thenReturn((Object)false);
        Mockito.when((Object)metricsTableRequests.isEnabTableQueryMeterMetrics()).thenReturn((Object)false);
        this.rsm.updateReadQueryMeter(region, 500L);
        Assert.assertFalse((boolean)HELPER.checkGaugeExists("ServerReadQueryPerSecond_count", (BaseSource)this.serverSource));
        this.rsm.updateWriteQueryMeter(region, 500L);
        Assert.assertFalse((boolean)HELPER.checkGaugeExists("ServerWriteQueryPerSecond_count", (BaseSource)this.serverSource));
        Configuration conf = new Configuration(false);
        conf.setBoolean("hbase.regionserver.enable.server.query.meter", true);
        this.rsm = new MetricsRegionServer((MetricsRegionServerWrapper)this.wrapper, conf, null);
        this.serverSource = this.rsm.getMetricsSource();
        this.rsm.updateReadQueryMeter(region, 500L);
        Assert.assertTrue((boolean)HELPER.checkGaugeExists("ServerWriteQueryPerSecond_count", (BaseSource)this.serverSource));
        HELPER.assertGauge("ServerReadQueryPerSecond_count", 500L, (BaseSource)this.serverSource);
        Assert.assertTrue((boolean)HELPER.checkGaugeExists("ServerWriteQueryPerSecond_count", (BaseSource)this.serverSource));
        this.rsm.updateWriteQueryMeter(region, 500L);
        HELPER.assertGauge("ServerWriteQueryPerSecond_count", 500L, (BaseSource)this.serverSource);
    }

    @Test
    public void testScannerMetrics() {
        HELPER.assertCounter("scannerLeaseExpiredCount", 0L, (BaseSource)this.serverSource);
        this.rsm.incrScannerLeaseExpired();
        HELPER.assertCounter("scannerLeaseExpiredCount", 1L, (BaseSource)this.serverSource);
        HELPER.assertGauge("activeScanners", 0L, (BaseSource)this.serverSource);
    }
}

