/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestScannerBlockSizeLimits {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestScannerBlockSizeLimits.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLE = TableName.valueOf((String)"TestScannerBlockSizeLimits");
    private static final byte[] FAMILY1 = Bytes.toBytes((String)"0");
    private static final byte[] FAMILY2 = Bytes.toBytes((String)"1");
    private static final byte[] DATA = new byte[1000];
    private static final byte[][] FAMILIES = new byte[][]{FAMILY1, FAMILY2};
    private static final byte[] COLUMN1 = Bytes.toBytes((int)0);
    private static final byte[] COLUMN2 = Bytes.toBytes((int)1);
    private static final byte[] COLUMN3 = Bytes.toBytes((int)2);
    private static final byte[] COLUMN5 = Bytes.toBytes((int)5);

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.server.scanner.max.result.size", 4200);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.createTable(TABLE, FAMILIES, 1, 2048);
        TestScannerBlockSizeLimits.createTestData();
    }

    @Before
    public void setupEach() throws Exception {
        HRegionServer regionServer = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
        for (HRegion region : regionServer.getRegions(TABLE)) {
            System.out.println("Clearing cache for region " + region.getRegionInfo().getEncodedName());
            regionServer.clearRegionBlockCache((Region)region);
        }
    }

    private static void createTestData() throws IOException, InterruptedException {
        RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(TABLE);
        String regionName = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegion().getEncodedName();
        HRegion region = TEST_UTIL.getRSForFirstRegionInTable(TABLE).getRegion(regionName);
        for (int i = 1; i < 10; ++i) {
            Put put = new Put(Bytes.toBytes((int)i));
            for (int j = 0; j < 6; ++j) {
                put.addColumn(FAMILY1, Bytes.toBytes((int)j), DATA);
            }
            put.addColumn(FAMILY2, COLUMN1, DATA);
            region.put(put);
            if (i % 2 != 0) continue;
            region.flush(true);
        }
        region.flush(true);
    }

    @Test
    public void testSingleBlock() throws IOException {
        Table table = TEST_UTIL.getConnection().getTable(TABLE);
        ResultScanner scanner = table.getScanner(this.getBaseScan().withStartRow(Bytes.toBytes((int)1)).withStopRow(Bytes.toBytes((int)2)).addColumn(FAMILY1, COLUMN1).addColumn(FAMILY1, COLUMN2).setReadType(Scan.ReadType.STREAM));
        ScanMetrics metrics = scanner.getScanMetrics();
        scanner.next(100);
        Assert.assertEquals((long)4120L, (long)metrics.countOfBlockBytesScanned.get());
        Assert.assertEquals((long)1L, (long)metrics.countOfRowsScanned.get());
        Assert.assertEquals((long)1L, (long)metrics.countOfRPCcalls.get());
    }

    @Test
    public void testCheckLimitAfterFilterRowKey() throws IOException {
        Table table = TEST_UTIL.getConnection().getTable(TABLE);
        ResultScanner scanner = table.getScanner(this.getBaseScan().addColumn(FAMILY1, COLUMN1).addColumn(FAMILY1, COLUMN2).addColumn(FAMILY1, COLUMN3).addFamily(FAMILY2).setFilter((Filter)new RowFilter(CompareOperator.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((int)2)))));
        ScanMetrics metrics = scanner.getScanMetrics();
        boolean foundRow3 = false;
        for (Result result : scanner) {
            HashSet<Integer> rows = new HashSet<Integer>();
            for (Cell cell : result.rawCells()) {
                rows.add(Bytes.toInt((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength()));
            }
            if (!rows.contains(3)) continue;
            Assert.assertFalse((String)"expected row3 to come all in one result, but found it in two results", (boolean)foundRow3);
            Assert.assertEquals((long)1L, (long)rows.size());
            foundRow3 = true;
        }
        Assert.assertEquals((long)44290L, (long)metrics.countOfBlockBytesScanned.get());
        Assert.assertEquals((long)10L, (long)metrics.countOfRPCcalls.get());
    }

    @Test
    public void testCheckLimitAfterFilteringRowCellsDueToFilterRow() throws IOException {
        Table table = TEST_UTIL.getConnection().getTable(TABLE);
        ResultScanner scanner = table.getScanner(this.getBaseScan().withStartRow(Bytes.toBytes((int)1), true).addColumn(FAMILY1, COLUMN1).addColumn(FAMILY1, COLUMN2).setReadType(Scan.ReadType.STREAM).setFilter((Filter)new SkipFilter((Filter)new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"dasfasf"))))));
        for (Result result : scanner) {
            Assert.assertTrue((boolean)result.isCursor());
        }
        ScanMetrics metrics = scanner.getScanMetrics();
        Assert.assertEquals((long)18540L, (long)metrics.countOfBlockBytesScanned.get());
        Assert.assertEquals((long)4L, (long)metrics.countOfRPCcalls.get());
    }

    @Test
    public void testCheckLimitAfterFilteringCell() throws IOException {
        Table table = TEST_UTIL.getConnection().getTable(TABLE);
        ResultScanner scanner = table.getScanner(this.getBaseScan().setCaching(1).setFilter((Filter)new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(COLUMN2))));
        int cursors = 0;
        for (Result result : scanner) {
            if (!result.isCursor()) continue;
            ++cursors;
        }
        ScanMetrics metrics = scanner.getScanMetrics();
        System.out.println(metrics.countOfBlockBytesScanned.get());
        Assert.assertEquals((long)64890L, (long)metrics.countOfBlockBytesScanned.get());
        Assert.assertEquals((long)2L, (long)cursors);
        Assert.assertEquals((long)11L, (long)metrics.countOfRPCcalls.get());
    }

    @Test
    public void testCheckLimitAfterFilteringRowCells() throws IOException {
        Table table = TEST_UTIL.getConnection().getTable(TABLE);
        ResultScanner scanner = table.getScanner(this.getBaseScan().withStartRow(Bytes.toBytes((int)1), true).addColumn(FAMILY1, COLUMN1).setReadType(Scan.ReadType.STREAM).setFilter((Filter)new SingleColumnValueExcludeFilter(FAMILY1, COLUMN1, CompareOperator.EQUAL, (ByteArrayComparable)new BinaryComparator(DATA))));
        for (Result result : scanner) {
            Assert.assertTrue((boolean)result.isCursor());
        }
        ScanMetrics metrics = scanner.getScanMetrics();
        Assert.assertEquals((long)18540L, (long)metrics.countOfBlockBytesScanned.get());
        Assert.assertEquals((long)4L, (long)metrics.countOfRPCcalls.get());
    }

    @Test
    public void testSeekNextUsingHint() throws IOException {
        Table table = TEST_UTIL.getConnection().getTable(TABLE);
        ResultScanner scanner = table.getScanner(this.getBaseScan().addFamily(FAMILY1).setFilter((Filter)new ColumnPaginationFilter(1, COLUMN5)));
        scanner.next(100);
        ScanMetrics metrics = scanner.getScanMetrics();
        Assert.assertEquals((long)37080L, (long)metrics.countOfBlockBytesScanned.get());
        Assert.assertEquals((long)7L, (long)metrics.countOfRPCcalls.get());
    }

    private Scan getBaseScan() {
        return new Scan().setScanMetricsEnabled(true).setNeedCursorResult(true).setAllowPartialResults(true).setReadType(Scan.ReadType.STREAM);
    }
}

