/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.io.FileChangeWatcher;
import org.apache.hadoop.hbase.io.crypto.tls.X509Util;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IOTests.class, SmallTests.class})
public class TestFileChangeWatcher {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFileChangeWatcher.class);
    private static File tempFile;
    private static final Logger LOG;
    private static final HBaseCommonTestingUtility UTIL;
    private static final long FS_TIMEOUT = 30000L;
    private static final Duration POLL_INTERVAL;

    @BeforeClass
    public static void createTempFile() throws IOException {
        tempFile = File.createTempFile("zk_test_", "");
    }

    @AfterClass
    public static void cleanupTempDir() {
        UTIL.cleanupTestDir();
    }

    @Test
    public void testEnableCertFileReloading() throws IOException {
        Configuration myConf = new Configuration();
        String sharedPath = File.createTempFile("foo", "foo.jks").getAbsolutePath();
        myConf.set("hbase.rpc.tls.keystore.location", sharedPath);
        myConf.set("hbase.rpc.tls.truststore.location", sharedPath);
        AtomicReference keystoreWatcher = new AtomicReference();
        AtomicReference truststoreWatcher = new AtomicReference();
        X509Util.enableCertFileReloading((Configuration)myConf, keystoreWatcher, truststoreWatcher, () -> {});
        Assert.assertNotNull(keystoreWatcher.get());
        MatcherAssert.assertThat((Object)((FileChangeWatcher)keystoreWatcher.get()).getWatcherThreadName(), (Matcher)Matchers.endsWith((String)"foo.jks"));
        Assert.assertNull(truststoreWatcher.get());
        ((FileChangeWatcher)keystoreWatcher.getAndSet(null)).stop();
        truststoreWatcher.set(null);
        String truststorePath = File.createTempFile("bar", "bar.jks").getAbsolutePath();
        myConf.set("hbase.rpc.tls.truststore.location", truststorePath);
        X509Util.enableCertFileReloading((Configuration)myConf, keystoreWatcher, truststoreWatcher, () -> {});
        Assert.assertNotNull(keystoreWatcher.get());
        MatcherAssert.assertThat((Object)((FileChangeWatcher)keystoreWatcher.get()).getWatcherThreadName(), (Matcher)Matchers.endsWith((String)"foo.jks"));
        Assert.assertNotNull(truststoreWatcher.get());
        MatcherAssert.assertThat((Object)((FileChangeWatcher)truststoreWatcher.get()).getWatcherThreadName(), (Matcher)Matchers.endsWith((String)"bar.jks"));
        ((FileChangeWatcher)keystoreWatcher.getAndSet(null)).stop();
        ((FileChangeWatcher)truststoreWatcher.getAndSet(null)).stop();
    }

    @Test
    public void testNoFalseNotifications() throws IOException, InterruptedException {
        FileChangeWatcher watcher = null;
        try {
            ArrayList notifiedPaths = new ArrayList();
            watcher = new FileChangeWatcher(tempFile.toPath(), "test", POLL_INTERVAL, path -> {
                LOG.info("Got an update on path {}", (Object)path);
                List list = notifiedPaths;
                synchronized (list) {
                    notifiedPaths.add(path);
                    notifiedPaths.notifyAll();
                }
            });
            watcher.start();
            watcher.waitForState(FileChangeWatcher.State.RUNNING);
            Thread.sleep(1000L);
            Assert.assertEquals((String)"Should not have been notified", (long)0L, (long)notifiedPaths.size());
        }
        finally {
            if (watcher != null) {
                watcher.stop();
                watcher.waitForState(FileChangeWatcher.State.STOPPED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallbackWorksOnFileChanges() throws IOException, InterruptedException {
        FileChangeWatcher watcher = null;
        try {
            ArrayList notifiedPaths = new ArrayList();
            watcher = new FileChangeWatcher(tempFile.toPath(), "test", POLL_INTERVAL, path -> {
                LOG.info("Got an update on path {}", (Object)path);
                List list = notifiedPaths;
                synchronized (list) {
                    notifiedPaths.add(path);
                    notifiedPaths.notifyAll();
                }
            });
            watcher.start();
            watcher.waitForState(FileChangeWatcher.State.RUNNING);
            Thread.sleep(1000L);
            for (int i = 0; i < 3; ++i) {
                LOG.info("Modifying file, attempt {}", (Object)(i + 1));
                FileUtils.writeStringToFile((File)tempFile, (String)("Hello world " + i + "\n"), (Charset)StandardCharsets.UTF_8, (boolean)true);
                ArrayList arrayList = notifiedPaths;
                synchronized (arrayList) {
                    if (notifiedPaths.size() < i + 1) {
                        notifiedPaths.wait(30000L);
                    }
                    Assert.assertEquals((String)"Wrong number of notifications", (long)(i + 1), (long)notifiedPaths.size());
                    Path path2 = (Path)notifiedPaths.get(i);
                    Assert.assertEquals((Object)tempFile.getPath(), (Object)path2.toString());
                    continue;
                }
            }
        }
        finally {
            if (watcher != null) {
                watcher.stop();
                watcher.waitForState(FileChangeWatcher.State.STOPPED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallbackWorksOnFileTouched() throws IOException, InterruptedException {
        FileChangeWatcher watcher = null;
        try {
            ArrayList notifiedPaths = new ArrayList();
            watcher = new FileChangeWatcher(tempFile.toPath(), "test", POLL_INTERVAL, path -> {
                LOG.info("Got an update on path {}", (Object)path);
                List list = notifiedPaths;
                synchronized (list) {
                    notifiedPaths.add(path);
                    notifiedPaths.notifyAll();
                }
            });
            watcher.start();
            watcher.waitForState(FileChangeWatcher.State.RUNNING);
            Thread.sleep(1000L);
            LOG.info("Touching file");
            FileUtils.touch((File)tempFile);
            ArrayList arrayList = notifiedPaths;
            synchronized (arrayList) {
                if (notifiedPaths.isEmpty()) {
                    notifiedPaths.wait(30000L);
                }
                Assert.assertFalse((boolean)notifiedPaths.isEmpty());
                Path path2 = (Path)notifiedPaths.get(0);
                Assert.assertEquals((Object)tempFile.getPath(), (Object)path2.toString());
            }
        }
        finally {
            if (watcher != null) {
                watcher.stop();
                watcher.waitForState(FileChangeWatcher.State.STOPPED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallbackErrorDoesNotCrashWatcherThread() throws IOException, InterruptedException {
        FileChangeWatcher watcher = null;
        try {
            AtomicInteger callCount = new AtomicInteger(0);
            watcher = new FileChangeWatcher(tempFile.toPath(), "test", POLL_INTERVAL, path -> {
                int oldValue;
                LOG.info("Got an update for path {}", (Object)path);
                AtomicInteger atomicInteger = callCount;
                synchronized (atomicInteger) {
                    oldValue = callCount.getAndIncrement();
                    callCount.notifyAll();
                }
                if (oldValue == 0) {
                    throw new RuntimeException("This error should not crash the watcher thread");
                }
            });
            watcher.start();
            watcher.waitForState(FileChangeWatcher.State.RUNNING);
            Thread.sleep(1000L);
            LOG.info("Modifying file");
            FileUtils.writeStringToFile((File)tempFile, (String)"Hello world\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
            AtomicInteger atomicInteger = callCount;
            synchronized (atomicInteger) {
                while (callCount.get() == 0) {
                    callCount.wait(30000L);
                }
            }
            LOG.info("Modifying file again");
            FileUtils.writeStringToFile((File)tempFile, (String)"Hello world again\n", (Charset)StandardCharsets.UTF_8, (boolean)true);
            atomicInteger = callCount;
            synchronized (atomicInteger) {
                if (callCount.get() == 1) {
                    callCount.wait(30000L);
                }
            }
            Assert.assertTrue((callCount.get() > 1 ? 1 : 0) != 0);
        }
        finally {
            if (watcher != null) {
                watcher.stop();
                watcher.waitForState(FileChangeWatcher.State.STOPPED);
            }
        }
    }

    static {
        LOG = LoggerFactory.getLogger(TestFileChangeWatcher.class);
        UTIL = new HBaseCommonTestingUtility();
        POLL_INTERVAL = Duration.ofMillis(100L);
    }
}

