/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupRestoreFactory;
import org.apache.hadoop.hbase.backup.HBackupFileSystem;
import org.apache.hadoop.hbase.backup.RestoreJob;
import org.apache.hadoop.hbase.backup.util.BackupUtils;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.tool.BulkLoadHFilesTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RestoreTool {
    public static final Logger LOG = LoggerFactory.getLogger(RestoreTool.class);
    private static final long TABLE_AVAILABILITY_WAIT_TIME = 180000L;
    private final String[] ignoreDirs = new String[]{"recovered.edits"};
    protected Configuration conf;
    protected Path backupRootPath;
    protected Path restoreRootDir;
    protected String backupId;
    protected FileSystem fs;
    private final HashMap<TableName, Path> snapshotMap = new HashMap();

    public RestoreTool(Configuration conf, Path backupRootPath, Path restoreRootDir, String backupId) throws IOException {
        this.conf = conf;
        this.backupRootPath = backupRootPath;
        this.backupId = backupId;
        this.fs = backupRootPath.getFileSystem(conf);
        this.restoreRootDir = restoreRootDir;
    }

    Path getTableArchivePath(TableName tableName) throws IOException {
        Path baseDir = new Path(HBackupFileSystem.getTableBackupPath(tableName, this.backupRootPath, this.backupId), "archive");
        Path dataDir = new Path(baseDir, "data");
        Path archivePath = new Path(dataDir, tableName.getNamespaceAsString());
        Path tableArchivePath = new Path(archivePath, tableName.getQualifierAsString());
        if (!this.fs.exists(tableArchivePath) || !this.fs.getFileStatus(tableArchivePath).isDirectory()) {
            LOG.debug("Folder tableArchivePath: " + tableArchivePath.toString() + " does not exists");
            tableArchivePath = null;
        }
        return tableArchivePath;
    }

    ArrayList<Path> getRegionList(TableName tableName) throws IOException {
        FileStatus[] children;
        Path tableArchivePath = this.getTableArchivePath(tableName);
        ArrayList<Path> regionDirList = new ArrayList<Path>();
        for (FileStatus childStatus : children = this.fs.listStatus(tableArchivePath)) {
            Path child = childStatus.getPath();
            regionDirList.add(child);
        }
        return regionDirList;
    }

    void modifyTableSync(Connection conn, TableDescriptor desc) throws IOException {
        try (Admin admin = conn.getAdmin();){
            admin.modifyTable(desc);
            int attempt = 0;
            int maxAttempts = 600;
            while (!admin.isTableAvailable(desc.getTableName())) {
                Thread.sleep(100L);
                int n = ++attempt;
                ++attempt;
                if (n <= maxAttempts) continue;
                throw new IOException("Timeout expired " + maxAttempts * 100 + "ms");
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void incrementalRestoreTable(Connection conn, Path tableBackupPath, Path[] logDirs, TableName[] tableNames, TableName[] newTableNames, String incrBackupId, boolean keepOriginalSplits) throws IOException {
        try (Admin admin = conn.getAdmin();){
            if (tableNames.length != newTableNames.length) {
                throw new IOException("Number of source tables and target tables does not match!");
            }
            FileSystem fileSys = tableBackupPath.getFileSystem(this.conf);
            for (TableName tableName : newTableNames) {
                if (admin.tableExists(tableName)) continue;
                throw new IOException("HBase table " + tableName + " does not exist. Create the table first, e.g. by restoring a full backup.");
            }
            for (int i = 0; i < tableNames.length; ++i) {
                TableName tableName = tableNames[i];
                TableDescriptor tableDescriptor = this.getTableDescriptor(fileSys, tableName, incrBackupId);
                if (tableDescriptor == null) {
                    throw new IOException("Can't find " + tableName + "'s descriptor.");
                }
                LOG.debug("Found descriptor " + tableDescriptor + " through " + incrBackupId);
                TableName newTableName = newTableNames[i];
                TableDescriptor newTableDescriptor = admin.getDescriptor(newTableName);
                List<ColumnFamilyDescriptor> families = Arrays.asList(tableDescriptor.getColumnFamilies());
                List<ColumnFamilyDescriptor> existingFamilies = Arrays.asList(newTableDescriptor.getColumnFamilies());
                TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableDescriptor)newTableDescriptor);
                boolean schemaChangeNeeded = false;
                for (ColumnFamilyDescriptor family : families) {
                    if (existingFamilies.contains(family)) continue;
                    builder.setColumnFamily(family);
                    schemaChangeNeeded = true;
                }
                for (ColumnFamilyDescriptor family : existingFamilies) {
                    if (families.contains(family)) continue;
                    builder.removeColumnFamily(family.getName());
                    schemaChangeNeeded = true;
                }
                if (!schemaChangeNeeded) continue;
                this.modifyTableSync(conn, builder.build());
                LOG.info("Changed " + newTableDescriptor.getTableName() + " to: " + newTableDescriptor);
            }
            this.configureForRestoreJob(keepOriginalSplits);
            RestoreJob restoreService = BackupRestoreFactory.getRestoreJob(this.conf);
            restoreService.run(logDirs, tableNames, this.restoreRootDir, newTableNames, false);
        }
    }

    public void fullRestoreTable(Connection conn, Path tableBackupPath, TableName tableName, TableName newTableName, boolean truncateIfExists, boolean isKeepOriginalSplits, String lastIncrBackupId) throws IOException {
        this.createAndRestoreTable(conn, tableName, newTableName, tableBackupPath, truncateIfExists, isKeepOriginalSplits, lastIncrBackupId);
    }

    Path getTableSnapshotPath(Path backupRootPath, TableName tableName, String backupId) {
        return new Path(HBackupFileSystem.getTableBackupPath(tableName, backupRootPath, backupId), ".hbase-snapshot");
    }

    Path getTableInfoPath(TableName tableName) throws IOException {
        FileStatus snapshot;
        FileStatus[] snapshots;
        Path tableSnapShotPath = this.getTableSnapshotPath(this.backupRootPath, tableName, this.backupId);
        Path tableInfoPath = null;
        FileStatus[] fileStatusArray = snapshots = this.fs.listStatus(tableSnapShotPath, (PathFilter)new SnapshotDescriptionUtils.CompletedSnaphotDirectoriesFilter(this.fs));
        int n = fileStatusArray.length;
        for (int i = 0; i < n && !(tableInfoPath = (snapshot = fileStatusArray[i]).getPath()).getName().endsWith("data.manifest"); ++i) {
        }
        return tableInfoPath;
    }

    TableDescriptor getTableDesc(TableName tableName) throws IOException {
        SnapshotProtos.SnapshotDescription desc;
        Path tableInfoPath = this.getTableInfoPath(tableName);
        SnapshotManifest manifest = SnapshotManifest.open((Configuration)this.conf, (FileSystem)this.fs, (Path)tableInfoPath, (SnapshotProtos.SnapshotDescription)(desc = SnapshotDescriptionUtils.readSnapshotInfo((FileSystem)this.fs, (Path)tableInfoPath)));
        TableDescriptor tableDescriptor = manifest.getTableDescriptor();
        if (!tableDescriptor.getTableName().equals((Object)tableName)) {
            LOG.error("couldn't find Table Desc for table: " + tableName + " under tableInfoPath: " + tableInfoPath.toString());
            LOG.error("tableDescriptor.getNameAsString() = " + tableDescriptor.getTableName().getNameAsString());
            throw new FileNotFoundException("couldn't find Table Desc for table: " + tableName + " under tableInfoPath: " + tableInfoPath.toString());
        }
        return tableDescriptor;
    }

    private TableDescriptor getTableDescriptor(FileSystem fileSys, TableName tableName, String lastIncrBackupId) throws IOException {
        if (lastIncrBackupId != null) {
            String target = BackupUtils.getTableBackupDir(this.backupRootPath.toString(), lastIncrBackupId, tableName);
            return FSTableDescriptors.getTableDescriptorFromFs((FileSystem)fileSys, (Path)new Path(target));
        }
        return null;
    }

    private void createAndRestoreTable(Connection conn, TableName tableName, TableName newTableName, Path tableBackupPath, boolean truncateIfExists, boolean isKeepOriginalSplits, String lastIncrBackupId) throws IOException {
        Path tableArchivePath;
        FileSystem fileSys;
        TableDescriptor tableDescriptor;
        if (newTableName == null) {
            newTableName = tableName;
        }
        if ((tableDescriptor = this.getTableDescriptor(fileSys = tableBackupPath.getFileSystem(this.conf), tableName, lastIncrBackupId)) != null) {
            LOG.debug("Retrieved descriptor: " + tableDescriptor + " thru " + lastIncrBackupId);
        }
        if (tableDescriptor == null) {
            Path tableSnapshotPath = this.getTableSnapshotPath(this.backupRootPath, tableName, this.backupId);
            if (fileSys.exists(tableSnapshotPath)) {
                if (this.snapshotMap.get(tableName) != null) {
                    SnapshotProtos.SnapshotDescription desc = SnapshotDescriptionUtils.readSnapshotInfo((FileSystem)fileSys, (Path)tableSnapshotPath);
                    SnapshotManifest manifest = SnapshotManifest.open((Configuration)this.conf, (FileSystem)fileSys, (Path)tableSnapshotPath, (SnapshotProtos.SnapshotDescription)desc);
                    tableDescriptor = manifest.getTableDescriptor();
                } else {
                    tableDescriptor = this.getTableDesc(tableName);
                    this.snapshotMap.put(tableName, this.getTableInfoPath(tableName));
                }
                if (tableDescriptor == null) {
                    LOG.debug("Found no table descriptor in the snapshot dir, previous schema would be lost");
                }
            } else {
                throw new IOException("Table snapshot directory: " + tableSnapshotPath + " does not exist.");
            }
        }
        if ((tableArchivePath = this.getTableArchivePath(tableName)) == null) {
            if (tableDescriptor != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("find table descriptor but no archive dir for table " + tableName + ", will only create table");
                }
                tableDescriptor = TableDescriptorBuilder.copy((TableName)newTableName, (TableDescriptor)tableDescriptor);
                this.checkAndCreateTable(conn, newTableName, null, tableDescriptor, truncateIfExists);
                return;
            }
            throw new IllegalStateException("Cannot restore hbase table because directory ' tableArchivePath is null.");
        }
        tableDescriptor = tableDescriptor == null ? TableDescriptorBuilder.newBuilder((TableName)newTableName).build() : TableDescriptorBuilder.copy((TableName)newTableName, (TableDescriptor)tableDescriptor);
        try {
            ArrayList<Path> regionPathList = this.getRegionList(tableName);
            this.checkAndCreateTable(conn, newTableName, regionPathList, tableDescriptor, truncateIfExists);
            this.configureForRestoreJob(isKeepOriginalSplits);
            RestoreJob restoreService = BackupRestoreFactory.getRestoreJob(this.conf);
            Path[] paths = new Path[regionPathList.size()];
            regionPathList.toArray(paths);
            restoreService.run(paths, new TableName[]{tableName}, this.restoreRootDir, new TableName[]{newTableName}, true);
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
            throw new IllegalStateException("Cannot restore hbase table", e);
        }
    }

    ArrayList<Path> getRegionList(Path tableArchivePath) throws IOException {
        FileStatus[] children;
        ArrayList<Path> regionDirList = new ArrayList<Path>();
        for (FileStatus childStatus : children = this.fs.listStatus(tableArchivePath)) {
            Path child = childStatus.getPath();
            regionDirList.add(child);
        }
        return regionDirList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[][] generateBoundaryKeys(ArrayList<Path> regionDirList) throws IOException {
        TreeMap<byte[], Integer> map = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (Path regionDir : regionDirList) {
            FileStatus[] familyDirStatuses;
            LOG.debug("Parsing region dir: " + regionDir);
            Path hfofDir = regionDir;
            if (!this.fs.exists(hfofDir)) {
                LOG.warn("HFileOutputFormat dir " + hfofDir + " not found");
            }
            if ((familyDirStatuses = this.fs.listStatus(hfofDir)) == null) {
                throw new IOException("No families found in " + hfofDir);
            }
            for (FileStatus stat : familyDirStatuses) {
                Path[] hfiles;
                if (!stat.isDirectory()) {
                    LOG.warn("Skipping non-directory " + stat.getPath());
                    continue;
                }
                boolean isIgnore = false;
                String pathName = stat.getPath().getName();
                for (String ignore : this.ignoreDirs) {
                    if (!pathName.contains(ignore)) continue;
                    LOG.warn("Skipping non-family directory" + pathName);
                    isIgnore = true;
                    break;
                }
                if (isIgnore) continue;
                Path familyDir = stat.getPath();
                LOG.debug("Parsing family dir [" + familyDir.toString() + " in region [" + regionDir + "]");
                if (familyDir.getName().startsWith("_") || familyDir.getName().startsWith(".")) continue;
                for (Path hfile : hfiles = FileUtil.stat2Paths((FileStatus[])this.fs.listStatus(familyDir))) {
                    if (hfile.getName().startsWith("_") || hfile.getName().startsWith(".") || StoreFileInfo.isReference((String)hfile.getName()) || HFileLink.isHFileLink((String)hfile.getName())) continue;
                    try (HFile.Reader reader = HFile.createReader((FileSystem)this.fs, (Path)hfile, (Configuration)this.conf);){
                        if (reader.getEntries() == 0L) {
                            LOG.debug("Skipping hfile with 0 entries: " + hfile);
                            continue;
                        }
                        byte[] first = (byte[])reader.getFirstRowKey().get();
                        byte[] last = (byte[])reader.getLastRowKey().get();
                        LOG.debug("Trying to figure out region boundaries hfile=" + hfile + " first=" + Bytes.toStringBinary((byte[])first) + " last=" + Bytes.toStringBinary((byte[])last));
                        Integer value = map.containsKey(first) ? (Integer)map.get(first) : 0;
                        map.put(first, value + 1);
                        value = map.containsKey(last) ? (Integer)map.get(last) : 0;
                        map.put(last, value - 1);
                    }
                }
            }
        }
        return BulkLoadHFilesTool.inferBoundaries(map);
    }

    private void checkAndCreateTable(Connection conn, TableName targetTableName, ArrayList<Path> regionDirList, TableDescriptor htd, boolean truncateIfExists) throws IOException {
        try (Admin admin = conn.getAdmin();){
            boolean createNew = false;
            if (admin.tableExists(targetTableName)) {
                if (truncateIfExists) {
                    LOG.info("Truncating exising target table '" + targetTableName + "', preserving region splits");
                    admin.disableTable(targetTableName);
                    admin.truncateTable(targetTableName, true);
                } else {
                    LOG.info("Using exising target table '" + targetTableName + "'");
                }
            } else {
                createNew = true;
            }
            if (createNew) {
                LOG.info("Creating target table '" + targetTableName + "'");
                byte[][] keys = null;
                try {
                    if (regionDirList == null || regionDirList.size() == 0) {
                        admin.createTable(htd);
                    } else {
                        keys = this.generateBoundaryKeys(regionDirList);
                        if (keys.length > 0) {
                            admin.createTable(htd, keys);
                        } else {
                            admin.createTable(htd);
                        }
                    }
                }
                catch (NamespaceNotFoundException e) {
                    LOG.warn("There was no namespace and the same will be created");
                    String namespaceAsString = targetTableName.getNamespaceAsString();
                    LOG.info("Creating target namespace '" + namespaceAsString + "'");
                    admin.createNamespace(NamespaceDescriptor.create((String)namespaceAsString).build());
                    if (null == keys) {
                        admin.createTable(htd);
                    }
                    admin.createTable(htd, keys);
                }
            }
            long startTime = EnvironmentEdgeManager.currentTime();
            while (!admin.isTableAvailable(targetTableName)) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                if (EnvironmentEdgeManager.currentTime() - startTime <= 180000L) continue;
                throw new IOException("Time out 180000ms expired, table " + targetTableName + " is still not available");
            }
        }
    }

    private void configureForRestoreJob(boolean keepOriginalSplits) {
        this.conf.setBoolean("hbase.backup.restorejob.keep.original.splits", keepOriginalSplits);
        this.conf.set("hbase.backup.root.path", this.backupRootPath.toString());
    }
}

