/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.data;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hive.hcatalog.data.HCatRecordObjectInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HCatRecordObjectInspectorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HCatRecordObjectInspectorFactory.class);
    private static final int INITIAL_CACHE_CAPACITY = 1024;
    private static final int MAX_CACHE_CAPACITY = 10240;
    private static final CacheBuilder<Object, Object> boundedCache = CacheBuilder.newBuilder().initialCapacity(1024).maximumSize(10240L).concurrencyLevel(Runtime.getRuntime().availableProcessors()).expireAfterAccess(5L, TimeUnit.MINUTES);
    private static final Cache<TypeInfo, HCatRecordObjectInspector> cachedHCatRecordObjectInspectors = boundedCache.build();
    private static final Cache<TypeInfo, ObjectInspector> cachedObjectInspectors = boundedCache.build();

    public static HCatRecordObjectInspector getHCatRecordObjectInspector(StructTypeInfo typeInfo) throws SerDeException {
        HCatRecordObjectInspector oi = (HCatRecordObjectInspector)((Object)cachedHCatRecordObjectInspectors.getIfPresent((Object)typeInfo));
        if (oi == null) {
            LOG.debug("Got asked for OI for {} [{} ]", (Object)typeInfo.getCategory(), (Object)typeInfo.getTypeName());
            switch (typeInfo.getCategory()) {
                case STRUCT: {
                    StructTypeInfo structTypeInfo = typeInfo;
                    List fieldNames = structTypeInfo.getAllStructFieldNames();
                    List fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                    ArrayList<ObjectInspector> fieldObjectInspectors = new ArrayList<ObjectInspector>(fieldTypeInfos.size());
                    for (int i = 0; i < fieldTypeInfos.size(); ++i) {
                        fieldObjectInspectors.add(HCatRecordObjectInspectorFactory.getStandardObjectInspectorFromTypeInfo((TypeInfo)fieldTypeInfos.get(i)));
                    }
                    oi = new HCatRecordObjectInspector(fieldNames, fieldObjectInspectors);
                    break;
                }
                default: {
                    throw new SerDeException("TypeInfo [" + typeInfo.getTypeName() + "] was not of struct type - HCatRecord expected struct type, got [" + typeInfo.getCategory().toString() + "]");
                }
            }
            cachedHCatRecordObjectInspectors.put((Object)typeInfo, (Object)oi);
        }
        return oi;
    }

    public static ObjectInspector getStandardObjectInspectorFromTypeInfo(TypeInfo typeInfo) {
        ObjectInspector oi = (ObjectInspector)cachedObjectInspectors.getIfPresent((Object)typeInfo);
        if (oi == null) {
            LOG.debug("Got asked for OI for {}, [{}]", (Object)typeInfo.getCategory(), (Object)typeInfo.getTypeName());
            switch (typeInfo.getCategory()) {
                case PRIMITIVE: {
                    oi = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)((PrimitiveTypeInfo)typeInfo));
                    break;
                }
                case STRUCT: {
                    StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                    List fieldNames = structTypeInfo.getAllStructFieldNames();
                    List fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                    ArrayList<ObjectInspector> fieldObjectInspectors = new ArrayList<ObjectInspector>(fieldTypeInfos.size());
                    for (int i = 0; i < fieldTypeInfos.size(); ++i) {
                        fieldObjectInspectors.add(HCatRecordObjectInspectorFactory.getStandardObjectInspectorFromTypeInfo((TypeInfo)fieldTypeInfos.get(i)));
                    }
                    oi = ObjectInspectorFactory.getStandardStructObjectInspector((List)fieldNames, fieldObjectInspectors);
                    break;
                }
                case LIST: {
                    ObjectInspector elementObjectInspector = HCatRecordObjectInspectorFactory.getStandardObjectInspectorFromTypeInfo(((ListTypeInfo)typeInfo).getListElementTypeInfo());
                    oi = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)elementObjectInspector);
                    break;
                }
                case MAP: {
                    ObjectInspector keyObjectInspector = HCatRecordObjectInspectorFactory.getStandardObjectInspectorFromTypeInfo(((MapTypeInfo)typeInfo).getMapKeyTypeInfo());
                    ObjectInspector valueObjectInspector = HCatRecordObjectInspectorFactory.getStandardObjectInspectorFromTypeInfo(((MapTypeInfo)typeInfo).getMapValueTypeInfo());
                    oi = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)keyObjectInspector, (ObjectInspector)valueObjectInspector);
                    break;
                }
                default: {
                    oi = null;
                }
            }
            cachedObjectInspectors.asMap().put(typeInfo, oi);
        }
        return oi;
    }
}

