/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hive.iceberg.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.apache.iceberg.io.StorageCredential;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StorageCredential", generator="Immutables")
@Immutable
public final class ImmutableStorageCredential
implements StorageCredential {
    private final String prefix;
    private final Map<String, String> config;

    private ImmutableStorageCredential(String prefix, Map<String, String> config) {
        this.prefix = prefix;
        this.config = config;
    }

    @Override
    public String prefix() {
        return this.prefix;
    }

    @Override
    public Map<String, String> config() {
        return this.config;
    }

    public final ImmutableStorageCredential withPrefix(String value) {
        String newValue = Objects.requireNonNull(value, "prefix");
        if (this.prefix.equals(newValue)) {
            return this;
        }
        return ImmutableStorageCredential.validate(new ImmutableStorageCredential(newValue, this.config));
    }

    public final ImmutableStorageCredential withConfig(Map<String, ? extends String> entries) {
        if (this.config == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableStorageCredential.createUnmodifiableMap(true, false, entries);
        return ImmutableStorageCredential.validate(new ImmutableStorageCredential(this.prefix, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStorageCredential && this.equalTo(0, (ImmutableStorageCredential)another);
    }

    private boolean equalTo(int synthetic, ImmutableStorageCredential another) {
        return this.prefix.equals(another.prefix) && this.config.equals(another.config);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.prefix.hashCode();
        h += (h << 5) + this.config.hashCode();
        return h;
    }

    public String toString() {
        return "StorageCredential{prefix=" + this.prefix + ", config=" + this.config + "}";
    }

    private static ImmutableStorageCredential validate(ImmutableStorageCredential instance) {
        instance.validate();
        return instance;
    }

    public static ImmutableStorageCredential copyOf(StorageCredential instance) {
        if (instance instanceof ImmutableStorageCredential) {
            return (ImmutableStorageCredential)instance;
        }
        return ImmutableStorageCredential.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return ImmutableStorageCredential.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="StorageCredential", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PREFIX = 1L;
        private long initBits = 1L;
        @Nullable
        private String prefix;
        private Map<String, String> config = new LinkedHashMap<String, String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StorageCredential instance) {
            Objects.requireNonNull(instance, "instance");
            this.prefix(instance.prefix());
            this.putAllConfig(instance.config());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder prefix(String prefix) {
            this.prefix = Objects.requireNonNull(prefix, "prefix");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putConfig(String key, String value) {
            this.config.put(Objects.requireNonNull(key, "config key"), Objects.requireNonNull(value, value == null ? "config value for key: " + key : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putConfig(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.config.put(Objects.requireNonNull(k, "config key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "config value for key: " + k : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder config(Map<String, ? extends String> entries) {
            this.config.clear();
            return this.putAllConfig(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllConfig(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.config.put(Objects.requireNonNull(k, "config key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "config value for key: " + k : null));
            }
            return this;
        }

        public ImmutableStorageCredential build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableStorageCredential.validate(new ImmutableStorageCredential(this.prefix, ImmutableStorageCredential.createUnmodifiableMap(false, false, this.config)));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("prefix");
            }
            return "Cannot build StorageCredential, some of required attributes are not set " + attributes;
        }
    }
}

