/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.frequencies;

import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.hive.frequencies.DataToItemsSketchUDAF;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@Description(name="DataToSketch", value="_FUNC_(value, maxMapSize) - Returns an ItemsSketch<String> in a serialized form as a binary blob. Values must be of string type. Parameter maxMapSize controls the accuracy and the size of the sketch.")
public class DataToStringsSketchUDAF
extends DataToItemsSketchUDAF<String> {
    @Override
    public GenericUDAFEvaluator createEvaluator() {
        return new DataToStringsSketchEvaluator();
    }

    static class DataToStringsSketchEvaluator
    extends DataToItemsSketchUDAF.DataToItemsSketchEvaluator<String> {
        DataToStringsSketchEvaluator() {
            super(new ArrayOfStringsSerDe());
        }

        @Override
        public String extractValue(Object data, ObjectInspector objectInspector) throws HiveException {
            Object value = this.inputObjectInspector.getPrimitiveJavaObject(data);
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof HiveChar) {
                return ((HiveChar)value).getValue();
            }
            if (value instanceof HiveVarchar) {
                return ((HiveVarchar)value).getValue();
            }
            throw new UDFArgumentTypeException(0, "unsupported type " + value.getClass().getName());
        }
    }
}

