/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import java.util.Objects;

public class SchemaAwareCacheKey {
    public static final int NO_SCHEMA_HASH = -1;
    private final Object fileId;
    private final int schemaHash;

    private SchemaAwareCacheKey(Object fileId, int schemaHash) {
        this.fileId = fileId;
        this.schemaHash = schemaHash;
    }

    public static Object buildCacheKey(Object fileId, int schemaHash) {
        if (schemaHash == -1) {
            return fileId;
        }
        return new SchemaAwareCacheKey(fileId, schemaHash);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaAwareCacheKey that = (SchemaAwareCacheKey)o;
        return this.schemaHash == that.schemaHash && Objects.equals(this.fileId, that.fileId);
    }

    public int hashCode() {
        return Objects.hash(this.fileId, this.schemaHash);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{fileId=").append(this.fileId).append(", schemaHash=").append(this.schemaHash).append('}');
        return sb.toString();
    }
}

