/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.alter;

import java.util.Map;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.database.alter.AbstractAlterDatabaseDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public abstract class AbstractAlterDatabaseOperation<T extends AbstractAlterDatabaseDesc>
extends DDLOperation<T> {
    public AbstractAlterDatabaseOperation(DDLOperationContext context, T desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        String dbName = ((AbstractAlterDatabaseDesc)this.desc).getDatabaseName();
        Database database = this.context.getDb().getDatabase(dbName);
        if (database == null) {
            throw new HiveException(ErrorMsg.DATABASE_NOT_EXISTS, new String[]{dbName});
        }
        Map params = database.getParameters();
        if (null != ((AbstractAlterDatabaseDesc)this.desc).getReplicationSpec() && !((AbstractAlterDatabaseDesc)this.desc).getReplicationSpec().allowEventReplacementInto(params)) {
            LOG.debug("DDLTask: Alter Database {} is skipped as database is newer than update", (Object)dbName);
            return 0;
        }
        this.doAlteration(database, params);
        this.context.getDb().alterDatabase(database.getName(), database);
        return 0;
    }

    protected abstract void doAlteration(Database var1, Map<String, String> var2) throws HiveException;
}

