/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.text.SimpleDateFormat;
import org.apache.hadoop.hive.common.format.datetime.HiveSqlDateTimeFormatter;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.LongToStringUnaryUDF;
import org.apache.hadoop.hive.ql.util.DateTimeMath;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;

public class CastDateToString
extends LongToStringUnaryUDF {
    private static final long serialVersionUID = 1L;
    protected transient java.sql.Date dt = new java.sql.Date(0L);
    private transient SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");

    public CastDateToString() {
        this.formatter.setCalendar(DateTimeMath.getProlepticGregorianCalendarUTC());
    }

    public CastDateToString(int inputColumn, int outputColumnNum) {
        super(inputColumn, outputColumnNum);
        this.formatter.setCalendar(DateTimeMath.getProlepticGregorianCalendarUTC());
    }

    protected void assign(BytesColumnVector outV, int i, byte[] bytes, int length) {
        outV.setVal(i, bytes, 0, length);
    }

    @Override
    protected void func(BytesColumnVector outV, long[] vector, int i) {
        this.dt.setTime(DateWritableV2.daysToMillis((int)((int)vector[i])));
        byte[] temp = this.formatter.format(this.dt).getBytes();
        this.assign(outV, i, temp, temp.length);
    }

    void sqlFormat(BytesColumnVector outV, long[] vector, int i, HiveSqlDateTimeFormatter sqlFormatter) {
        String formattedDate = sqlFormatter.format(Date.ofEpochDay((int)((int)vector[i])));
        if (formattedDate == null) {
            outV.isNull[i] = true;
            outV.noNulls = false;
            return;
        }
        byte[] temp = formattedDate.getBytes();
        this.assign(outV, i, temp, temp.length);
    }
}

