/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.cache;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.DatabaseName;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.HiveAlterHandler;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.PartFilterExprUtil;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AddPackageRequest;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AllTableConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.CheckConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DatabaseType;
import org.apache.hadoop.hive.metastore.api.DefaultConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.DropPackageRequest;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetPackageRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsFilterSpec;
import org.apache.hadoop.hive.metastore.api.GetProjectionsSpec;
import org.apache.hadoop.hive.metastore.api.GetReplicationMetricsRequest;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.ISchema;
import org.apache.hadoop.hive.metastore.api.ISchemaName;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.ListPackageRequest;
import org.apache.hadoop.hive.metastore.api.ListStoredProcedureRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountResponse;
import org.apache.hadoop.hive.metastore.api.Package;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.ReplicationMetricList;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.metastore.api.RuntimeStat;
import org.apache.hadoop.hive.metastore.api.SQLAllTableConstraints;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.ScheduledQuery;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryKey;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryMaintenanceRequest;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryPollRequest;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryPollResponse;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryProgressInfo;
import org.apache.hadoop.hive.metastore.api.SchemaVersion;
import org.apache.hadoop.hive.metastore.api.SchemaVersionDescriptor;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StoredProcedure;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMMapping;
import org.apache.hadoop.hive.metastore.api.WMNullablePool;
import org.apache.hadoop.hive.metastore.api.WMNullableResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMPool;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanResponse;
import org.apache.hadoop.hive.metastore.api.WriteEventInfo;
import org.apache.hadoop.hive.metastore.cache.SharedCache;
import org.apache.hadoop.hive.metastore.cache.TableCacheObjects;
import org.apache.hadoop.hive.metastore.client.builder.GetPartitionsArgs;
import org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregatorFactory;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.messaging.AddCheckConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AddDefaultConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AddForeignKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.AddNotNullConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AddPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AddPrimaryKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.AddUniqueConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionsMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateTableMessage;
import org.apache.hadoop.hive.metastore.messaging.DeletePartitionColumnStatMessage;
import org.apache.hadoop.hive.metastore.messaging.DeleteTableColumnStatMessage;
import org.apache.hadoop.hive.metastore.messaging.DropConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.DropPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.DropTableMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.apache.hadoop.hive.metastore.messaging.UpdatePartitionColumnStatMessage;
import org.apache.hadoop.hive.metastore.messaging.UpdateTableColumnStatMessage;
import org.apache.hadoop.hive.metastore.model.MTable;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedStore
implements RawStore,
Configurable {
    private static ScheduledExecutorService cacheUpdateMaster = null;
    private static List<Pattern> whitelistPatterns = null;
    private static List<Pattern> blacklistPatterns = null;
    private static long DEFAULT_CACHE_REFRESH_PERIOD;
    private static long cacheRefreshPeriodMS;
    private static int MAX_RETRIES;
    private static AtomicBoolean isCachePrewarmed;
    private static AtomicBoolean isCachedAllMetadata;
    private static TablesPendingPrewarm tblsPendingPrewarm;
    private RawStore rawStore = null;
    private Configuration conf;
    private static boolean areTxnStatsSupported;
    private PartitionExpressionProxy expressionProxy = null;
    private static String lock;
    private static boolean sharedCacheInited;
    private static SharedCache sharedCache;
    private static boolean canUseEvents;
    private static long lastEventId;
    private static final Logger LOG;

    public void setConf(Configuration conf) {
        this.setConfInternal(conf);
        CachedStore.initBlackListWhiteList(conf);
        this.initSharedCache(conf);
        CachedStore.startCacheUpdateService(conf, false, true);
    }

    void setConfForTest(Configuration conf) {
        this.setConfForTestExceptSharedCache(conf);
        this.initSharedCache(conf);
    }

    void setConfForTestExceptSharedCache(Configuration conf) {
        this.setConfInternal(conf);
        CachedStore.initBlackListWhiteList(conf);
    }

    private static synchronized void triggerUpdateUsingEvent(RawStore rawStore) {
        if (!isCachePrewarmed.get()) {
            LOG.error("cache update should be done only after prewarm");
            throw new RuntimeException("cache update should be done only after prewarm");
        }
        long startTime = System.nanoTime();
        long preEventId = lastEventId;
        try {
            lastEventId = CachedStore.updateUsingNotificationEvents(rawStore, lastEventId);
        }
        catch (Exception e) {
            LOG.error(" cache update failed for start event id " + lastEventId + " with error ", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        finally {
            long endTime = System.nanoTime();
            LOG.info("Time taken in updateUsingNotificationEvents for num events : " + (lastEventId - preEventId) + " = " + (endTime - startTime) / 1000000L + "ms");
        }
    }

    private static synchronized void triggerPreWarm(RawStore rawStore) {
        lastEventId = rawStore.getCurrentNotificationEventId().getEventId();
        CachedStore.prewarm(rawStore);
    }

    private void setConfInternal(Configuration conf) {
        canUseEvents = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CACHE_CAN_USE_EVENT);
        LOG.info("canUseEvents is set to " + canUseEvents + " in cached Store");
        String rawStoreClassName = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_IMPL, (String)ObjectStore.class.getName());
        if (this.rawStore == null) {
            try {
                this.rawStore = (RawStore)JavaUtils.getClass((String)rawStoreClassName, RawStore.class).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot instantiate " + rawStoreClassName, e);
            }
        }
        this.rawStore.setConf(conf);
        Configuration oldConf = this.conf;
        this.conf = conf;
        areTxnStatsSupported = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_TXN_STATS_ENABLED);
        if (this.expressionProxy != null && conf != oldConf) {
            LOG.warn("Unexpected setConf when we were already configured");
        } else {
            this.expressionProxy = PartFilterExprUtil.createExpressionProxy(conf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSharedCache(Configuration conf) {
        String string = lock;
        synchronized (string) {
            if (!sharedCacheInited) {
                sharedCacheInited = true;
                sharedCache.initialize(conf);
            }
        }
    }

    @VisibleForTesting
    public static SharedCache getSharedCache() {
        return sharedCache;
    }

    private static void updateStatsForAlterPart(RawStore rawStore, Table before, String catalogName, String dbName, String tableName, Partition part) throws Exception {
        boolean rename;
        List<Object> deletedCols = new ArrayList();
        boolean bl = rename = !Objects.equals(before.getDbName(), dbName) || !Objects.equals(before.getTableName(), tableName);
        if (rename) {
            deletedCols = part.getSd().getCols().stream().map(FieldSchema::getName).toList();
        } else {
            HiveAlterHandler.updateOrGetPartitionColumnStats(rawStore, catalogName, dbName, tableName, part.getValues(), part.getSd().getCols(), before, part, deletedCols);
        }
        for (String string : deletedCols) {
            sharedCache.removePartitionColStatsFromCache(catalogName, dbName, tableName, part.getValues(), string);
        }
    }

    private static void updateStatsForAlterTable(RawStore rawStore, Table tblBefore, Table tblAfter, String catalogName, String dbName, String tableName) throws Exception {
        if (tblBefore.isSetPartitionKeys()) {
            List<Partition> parts = sharedCache.listCachedPartitions(catalogName, dbName, tableName, -1);
            for (Partition part : parts) {
                CachedStore.updateStatsForAlterPart(rawStore, tblBefore, catalogName, dbName, tableName, part);
            }
        }
        rawStore.alterTable(catalogName, dbName, tblBefore.getTableName(), tblAfter, null);
        boolean rename = !Objects.equals(tblBefore.getDbName(), tblAfter.getDbName()) || !Objects.equals(tblBefore.getTableName(), tblAfter.getTableName());
        List<String> deletedCols = rename ? tblBefore.getSd().getCols().stream().map(FieldSchema::getName).toList() : MetaStoreServerUtils.findStaleColumns(tblBefore.getSd().getCols(), tblAfter.getSd().getCols());
        for (String column : deletedCols) {
            sharedCache.removeTableColStatsFromCache(catalogName, dbName, tableName, column);
        }
    }

    @VisibleForTesting
    public static long updateUsingNotificationEvents(RawStore rawStore, long lastEventId) throws Exception {
        LOG.debug("updating cache using notification events starting from event id " + lastEventId);
        NotificationEventRequest rqst = new NotificationEventRequest(lastEventId);
        rqst.addToEventTypeSkipList("INSERT");
        rqst.addToEventTypeSkipList("OPEN_TXN");
        rqst.addToEventTypeSkipList("COMMIT_TXN");
        rqst.addToEventTypeSkipList("ABORT_TXN");
        rqst.addToEventTypeSkipList("ALLOC_WRITE_ID_EVENT");
        rqst.addToEventTypeSkipList("ACID_WRITE_EVENT");
        rqst.addToEventTypeSkipList("CREATE_FUNCTION");
        rqst.addToEventTypeSkipList("DROP_FUNCTION");
        rqst.addToEventTypeSkipList("CREATE_ISCHEMA");
        rqst.addToEventTypeSkipList("ALTER_ISCHEMA");
        rqst.addToEventTypeSkipList("DROP_ISCHEMA");
        rqst.addToEventTypeSkipList("ADD_SCHEMA_VERSION");
        rqst.addToEventTypeSkipList("ALTER_SCHEMA_VERSION");
        rqst.addToEventTypeSkipList("DROP_SCHEMA_VERSION");
        Deadline.startTimer("getNextNotification");
        NotificationEventResponse resp = rawStore.getNextNotification(rqst);
        Deadline.stopTimer();
        if (resp == null || resp.getEvents() == null) {
            LOG.debug("no events to process");
            return lastEventId;
        }
        List eventList = resp.getEvents();
        LOG.debug("num events to process" + eventList.size());
        block50: for (NotificationEvent event : eventList) {
            String tableName;
            long eventId = event.getEventId();
            if (eventId <= lastEventId) {
                LOG.error("Event id is not valid " + lastEventId + " : " + eventId);
                throw new RuntimeException(" event id is not valid " + lastEventId + " : " + eventId);
            }
            lastEventId = eventId;
            String message = event.getMessage();
            LOG.debug("Event to process " + String.valueOf(event));
            MessageDeserializer deserializer = MessageFactory.getInstance(event.getMessageFormat()).getDeserializer();
            String catalogName = event.getCatName() == null ? "" : event.getCatName().toLowerCase();
            String dbName = event.getDbName() == null ? "" : event.getDbName().toLowerCase();
            String string = tableName = event.getTableName() == null ? "" : event.getTableName().toLowerCase();
            if (!CachedStore.shouldCacheTable(catalogName, dbName, tableName)) continue;
            switch (event.getEventType()) {
                case "ADD_PARTITION": {
                    AddPartitionMessage addPartMessage = deserializer.getAddPartitionMessage(message);
                    sharedCache.addPartitionsToCache(catalogName, dbName, tableName, addPartMessage.getPartitionObjs());
                    break;
                }
                case "ALTER_PARTITION": {
                    AlterPartitionMessage alterPartitionMessage = deserializer.getAlterPartitionMessage(message);
                    sharedCache.alterPartitionInCache(catalogName, dbName, tableName, alterPartitionMessage.getPtnObjBefore().getValues(), alterPartitionMessage.getPtnObjAfter());
                    CachedStore.updateStatsForAlterPart(rawStore, alterPartitionMessage.getTableObj(), catalogName, dbName, tableName, alterPartitionMessage.getPtnObjAfter());
                    break;
                }
                case "ALTER_PARTITIONS": {
                    AlterPartitionsMessage alterPtnsMessage = deserializer.getAlterPartitionsMessage(message);
                    ArrayList<List<String>> part_vals = new ArrayList<List<String>>();
                    alterPtnsMessage.getPartitionObjs().forEach(part -> part_vals.add(part.getValues()));
                    sharedCache.removePartitionsFromCache(catalogName, dbName, tableName, part_vals);
                    break;
                }
                case "DROP_PARTITION": {
                    DropPartitionMessage dropPartitionMessage = deserializer.getDropPartitionMessage(message);
                    for (Map<String, String> partMap : dropPartitionMessage.getPartitions()) {
                        sharedCache.removePartitionFromCache(catalogName, dbName, tableName, new ArrayList<String>(partMap.values()));
                    }
                    continue block50;
                }
                case "CREATE_TABLE": {
                    CreateTableMessage createTableMessage = deserializer.getCreateTableMessage(message);
                    sharedCache.addTableToCache(catalogName, dbName, tableName, createTableMessage.getTableObj());
                    break;
                }
                case "ALTER_TABLE": {
                    AlterTableMessage alterTableMessage = deserializer.getAlterTableMessage(message);
                    sharedCache.alterTableInCache(catalogName, dbName, tableName, alterTableMessage.getTableObjAfter());
                    CachedStore.updateStatsForAlterTable(rawStore, alterTableMessage.getTableObjBefore(), alterTableMessage.getTableObjAfter(), catalogName, dbName, tableName);
                    break;
                }
                case "DROP_TABLE": {
                    Map<String, String> partitionLocations;
                    DropTableMessage dropTableMessage = deserializer.getDropTableMessage(message);
                    int batchSize = MetastoreConf.getIntVar((Configuration)rawStore.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_OBJECTS_MAX);
                    String tableDnsPath = null;
                    Path tablePath = new Path(dropTableMessage.getTableObj().getSd().getLocation());
                    if (tablePath != null) {
                        tableDnsPath = new Warehouse(rawStore.getConf()).getDnsPath(tablePath).toString();
                    }
                    while ((partitionLocations = rawStore.getPartitionLocations(catalogName, dbName, tableName, tableDnsPath, batchSize)) != null && !partitionLocations.isEmpty()) {
                        sharedCache.removePartitionFromCache(catalogName, dbName, tableName, new ArrayList<String>(partitionLocations.values()));
                    }
                    sharedCache.removeTableFromCache(catalogName, dbName, tableName);
                    break;
                }
                case "CREATE_DATABASE": {
                    CreateDatabaseMessage createDatabaseMessage = deserializer.getCreateDatabaseMessage(message);
                    sharedCache.addDatabaseToCache(createDatabaseMessage.getDatabaseObject());
                    break;
                }
                case "ALTER_DATABASE": {
                    AlterDatabaseMessage alterDatabaseMessage = deserializer.getAlterDatabaseMessage(message);
                    sharedCache.alterDatabaseInCache(catalogName, dbName, alterDatabaseMessage.getDbObjAfter());
                    break;
                }
                case "DROP_DATABASE": {
                    sharedCache.removeDatabaseFromCache(catalogName, dbName);
                    break;
                }
                case "CREATE_CATALOG": 
                case "DROP_CATALOG": 
                case "ALTER_CATALOG": {
                    LOG.error("catalog Events are not supported for cache invalidation : " + event.getEventType());
                    break;
                }
                case "UPDATE_TBL_COL_STAT_EVENT": {
                    UpdateTableColumnStatMessage msg = deserializer.getUpdateTableColumnStatMessage(message);
                    sharedCache.alterTableAndStatsInCache(catalogName, dbName, tableName, msg.getWriteId(), msg.getColumnStatistics().getStatsObj(), msg.getParameters());
                    break;
                }
                case "DELETE_TBL_COL_STAT_EVENT": {
                    DeleteTableColumnStatMessage msgDel = deserializer.getDeleteTableColumnStatMessage(message);
                    sharedCache.removeTableColStatsFromCache(catalogName, dbName, tableName, msgDel.getColName());
                    break;
                }
                case "UPDATE_PART_COL_STAT_EVENT": {
                    UpdatePartitionColumnStatMessage msgPartUpdate = deserializer.getUpdatePartitionColumnStatMessage(message);
                    sharedCache.alterPartitionAndStatsInCache(catalogName, dbName, tableName, msgPartUpdate.getWriteId(), msgPartUpdate.getPartVals(), msgPartUpdate.getParameters(), msgPartUpdate.getColumnStatistics().getStatsObj());
                    break;
                }
                case "DELETE_PART_COL_STAT_EVENT": {
                    DeletePartitionColumnStatMessage msgPart = deserializer.getDeletePartitionColumnStatMessage(message);
                    sharedCache.removePartitionColStatsFromCache(catalogName, dbName, tableName, msgPart.getPartValues(), msgPart.getColName());
                    break;
                }
                case "ADD_PRIMARYKEY": {
                    AddPrimaryKeyMessage addPrimaryKeyMessage = deserializer.getAddPrimaryKeyMessage(message);
                    sharedCache.addPrimaryKeysToCache(catalogName, dbName, tableName, addPrimaryKeyMessage.getPrimaryKeys());
                    break;
                }
                case "ADD_FOREIGNKEY": {
                    AddForeignKeyMessage addForeignKeyMessage = deserializer.getAddForeignKeyMessage(message);
                    for (SQLForeignKey fk : addForeignKeyMessage.getForeignKeys()) {
                        sharedCache.addForeignKeysToCache(catalogName, fk.getFktable_db(), fk.getFktable_name(), Arrays.asList(fk));
                    }
                    continue block50;
                }
                case "ADD_NOTNULLCONSTRAINT": {
                    AddNotNullConstraintMessage notNullConstraintMessage = deserializer.getAddNotNullConstraintMessage(message);
                    sharedCache.addNotNullConstraintsToCache(catalogName, dbName, tableName, notNullConstraintMessage.getNotNullConstraints());
                    break;
                }
                case "ADD_UNIQUECONSTRAINT": {
                    AddUniqueConstraintMessage uniqueConstraintMessage = deserializer.getAddUniqueConstraintMessage(message);
                    sharedCache.addUniqueConstraintsToCache(catalogName, dbName, tableName, uniqueConstraintMessage.getUniqueConstraints());
                    break;
                }
                case "ADD_DEFAULTCONSTRAINT": {
                    AddDefaultConstraintMessage defaultConstraintMessage = deserializer.getAddDefaultConstraintMessage(message);
                    sharedCache.addDefaultConstraintsToCache(catalogName, dbName, tableName, defaultConstraintMessage.getDefaultConstraints());
                    break;
                }
                case "ADD_CHECKCONSTRAINT": {
                    AddCheckConstraintMessage checkConstraintMessage = deserializer.getAddCheckConstraintMessage(message);
                    sharedCache.addCheckConstraintsToCache(catalogName, dbName, tableName, checkConstraintMessage.getCheckConstraints());
                    break;
                }
                case "DROP_CONSTRAINT": {
                    DropConstraintMessage dropConstraintMessage = deserializer.getDropConstraintMessage(message);
                    sharedCache.removeConstraintFromCache(catalogName, dbName, tableName, dropConstraintMessage.getConstraint());
                    break;
                }
                default: {
                    LOG.error("Event is not supported for cache invalidation : " + event.getEventType());
                }
            }
        }
        return lastEventId;
    }

    @VisibleForTesting
    static void prewarm(RawStore rawStore) {
        if (isCachePrewarmed.get()) {
            return;
        }
        long startTime = System.nanoTime();
        LOG.info("Prewarming CachedStore");
        long sleepTime = 100L;
        while (!isCachePrewarmed.get()) {
            Collection<String> catalogsToCache;
            Deadline.registerIfNot(1000000L);
            try {
                catalogsToCache = CachedStore.catalogsToCache(rawStore);
                LOG.info("Going to cache catalogs: " + org.apache.commons.lang3.StringUtils.join(catalogsToCache, (String)", "));
                ArrayList<Catalog> catalogs = new ArrayList<Catalog>(catalogsToCache.size());
                for (String catName : catalogsToCache) {
                    catalogs.add(rawStore.getCatalog(catName));
                }
                sharedCache.populateCatalogsInCache(catalogs);
            }
            catch (MetaException | NoSuchObjectException e) {
                LOG.warn("Failed to populate catalogs in cache, going to try again", e);
                try {
                    Thread.sleep(sleepTime);
                    sleepTime *= 2L;
                }
                catch (InterruptedException timerEx) {
                    LOG.info("sleep interrupted", (Object)timerEx.getMessage());
                }
                continue;
            }
            LOG.info("Finished prewarming catalogs, starting on databases");
            ArrayList<Database> databases = new ArrayList<Database>();
            for (String catName : catalogsToCache) {
                try {
                    List<String> dbNames = rawStore.getAllDatabases(catName);
                    LOG.info("Number of databases to prewarm in catalog {}: {}", (Object)catName, (Object)dbNames.size());
                    for (String dbName : dbNames) {
                        try {
                            databases.add(rawStore.getDatabase(catName, dbName));
                        }
                        catch (NoSuchObjectException e) {
                            LOG.warn("Failed to cache database " + DatabaseName.getQualified((String)catName, (String)dbName) + ", moving on", (Throwable)e);
                        }
                    }
                }
                catch (MetaException e) {
                    LOG.warn("Failed to cache databases in catalog " + catName + ", moving on", (Throwable)e);
                }
            }
            sharedCache.populateDatabasesInCache(databases);
            LOG.info("Databases cache is now prewarmed. Now adding tables, partitions and statistics to the cache");
            int numberOfDatabasesCachedSoFar = 0;
            for (Database db : databases) {
                List<String> tblNames;
                String dbName;
                String catName = StringUtils.normalizeIdentifier((String)db.getCatalogName());
                dbName = StringUtils.normalizeIdentifier((String)db.getName());
                try {
                    tblNames = rawStore.getAllTables(catName, dbName);
                }
                catch (MetaException e) {
                    LOG.warn("Failed to cache tables for database " + DatabaseName.getQualified((String)catName, (String)dbName) + ", moving on");
                    continue;
                }
                tblsPendingPrewarm.addTableNamesForPrewarming(tblNames);
                int totalTablesToCache = tblNames.size();
                int numberOfTablesCachedSoFar = 0;
                while (tblsPendingPrewarm.hasMoreTablesToPrewarm()) {
                    try {
                        Table table;
                        String tblName = StringUtils.normalizeIdentifier((String)tblsPendingPrewarm.getNextTableNameToPrewarm());
                        if (!CachedStore.shouldCacheTable(catName, dbName, tblName)) continue;
                        try {
                            table = rawStore.getTable(catName, dbName, tblName);
                        }
                        catch (MetaException e) {
                            LOG.debug(ExceptionUtils.getStackTrace((Throwable)e));
                            continue;
                        }
                        List colNames = MetaStoreUtils.getColumnNamesForTable((Table)table);
                        try {
                            ColumnStatistics tableColStats = null;
                            List<Partition> partitions = null;
                            List<ColumnStatistics> partitionColStats = null;
                            AggrStats aggrStatsAllPartitions = null;
                            AggrStats aggrStatsAllButDefaultPartition = null;
                            TableCacheObjects cacheObjects = new TableCacheObjects();
                            if (!table.getPartitionKeys().isEmpty()) {
                                Deadline.startTimer("getPartitions");
                                partitions = rawStore.getPartitions(catName, dbName, tblName, GetPartitionsArgs.getAllPartitions());
                                Deadline.stopTimer();
                                cacheObjects.setPartitions(partitions);
                                ArrayList<String> partNames = new ArrayList<String>(partitions.size());
                                for (Partition p : partitions) {
                                    partNames.add(Warehouse.makePartName((List)table.getPartitionKeys(), (List)p.getValues()));
                                }
                                if (!partNames.isEmpty()) {
                                    Deadline.startTimer("getPartitionColumnStatistics");
                                    partitionColStats = rawStore.getPartitionColumnStatistics(catName, dbName, tblName, partNames, colNames, "hive");
                                    Deadline.stopTimer();
                                    cacheObjects.setPartitionColStats(partitionColStats);
                                    Deadline.startTimer("getAggrPartitionColumnStatistics");
                                    aggrStatsAllPartitions = rawStore.get_aggr_stats_for(catName, dbName, tblName, partNames, colNames, "hive");
                                    Deadline.stopTimer();
                                    cacheObjects.setAggrStatsAllPartitions(aggrStatsAllPartitions);
                                    List partKeys = table.getPartitionKeys();
                                    String defaultPartitionValue = MetastoreConf.getVar((Configuration)rawStore.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DEFAULTPARTITIONNAME);
                                    ArrayList<String> partCols = new ArrayList<String>();
                                    ArrayList<String> partVals = new ArrayList<String>();
                                    for (FieldSchema fs : partKeys) {
                                        partCols.add(fs.getName());
                                        partVals.add(defaultPartitionValue);
                                    }
                                    String defaultPartitionName = FileUtils.makePartName(partCols, partVals);
                                    partNames.remove(defaultPartitionName);
                                    Deadline.startTimer("getAggrPartitionColumnStatistics");
                                    aggrStatsAllButDefaultPartition = rawStore.get_aggr_stats_for(catName, dbName, tblName, partNames, colNames, "hive");
                                    Deadline.stopTimer();
                                    cacheObjects.setAggrStatsAllButDefaultPartition(aggrStatsAllButDefaultPartition);
                                }
                            } else {
                                Deadline.startTimer("getTableColumnStatistics");
                                tableColStats = rawStore.getTableColumnStatistics(catName, dbName, tblName, colNames, "hive");
                                Deadline.stopTimer();
                                cacheObjects.setTableColStats(tableColStats);
                            }
                            Deadline.startTimer("getAllTableConstraints");
                            SQLAllTableConstraints tableConstraints = rawStore.getAllTableConstraints(new AllTableConstraintsRequest(catName, dbName, tblName));
                            Deadline.stopTimer();
                            cacheObjects.setTableConstraints(tableConstraints);
                            boolean isSuccess = sharedCache.populateTableInCache(table, cacheObjects);
                            if (!isSuccess) {
                                LOG.info("Unable to cache Database: {}'s Table: {}, since the cache memory is full. Will stop attempting to cache any more tables.", (Object)dbName, (Object)tblName);
                                CachedStore.completePrewarm(startTime, false);
                                return;
                            }
                            LOG.trace("Cached Database: {}'s Table: {}.", (Object)dbName, (Object)tblName);
                        }
                        catch (MetaException | NoSuchObjectException e) {
                            LOG.debug(ExceptionUtils.getStackTrace((Throwable)e));
                            continue;
                        }
                        LOG.debug("Processed database: {}'s table: {}. Cached {} / {}  tables so far.", new Object[]{dbName, tblName, ++numberOfTablesCachedSoFar, totalTablesToCache});
                    }
                    catch (EmptyStackException e) {}
                }
                LOG.debug("Processed database: {}. Cached {} / {} databases so far.", new Object[]{dbName, ++numberOfDatabasesCachedSoFar, databases.size()});
            }
            sharedCache.clearDirtyFlags();
            CachedStore.completePrewarm(startTime, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void clearSharedCache() {
        String string = lock;
        synchronized (string) {
            sharedCacheInited = false;
        }
        sharedCache = new SharedCache();
    }

    static void completePrewarm(long startTime, boolean cachedAllMetadata) {
        isCachePrewarmed.set(true);
        isCachedAllMetadata.set(cachedAllMetadata);
        LOG.info("CachedStore initialized");
        long endTime = System.nanoTime();
        LOG.info("Time taken in prewarming = " + (endTime - startTime) / 1000000L + "ms");
        sharedCache.completeTableCachePrewarm();
    }

    @VisibleForTesting
    static void setCachePrewarmedState(boolean state) {
        isCachePrewarmed.set(state);
    }

    private static void initBlackListWhiteList(Configuration conf) {
        whitelistPatterns = CachedStore.createPatterns(MetastoreConf.getAsString((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_CACHED_OBJECTS_WHITELIST));
        blacklistPatterns = CachedStore.createPatterns(MetastoreConf.getAsString((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_CACHED_OBJECTS_BLACKLIST));
    }

    private static Collection<String> catalogsToCache(RawStore rs) throws MetaException {
        Collection confValue = MetastoreConf.getStringCollection((Configuration)rs.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CATALOGS_TO_CACHE);
        if (confValue == null || confValue.isEmpty() || confValue.size() == 1 && confValue.contains("")) {
            return rs.getCatalogs();
        }
        return confValue;
    }

    @VisibleForTesting
    static synchronized void startCacheUpdateService(Configuration conf, boolean runOnlyOnce, boolean shouldRunPrewarm) {
        if (cacheUpdateMaster == null) {
            CachedStore.initBlackListWhiteList(conf);
            if (!MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST)) {
                cacheRefreshPeriodMS = MetastoreConf.getTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_CACHE_UPDATE_FREQUENCY, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            LOG.info("CachedStore: starting cache update service (run every {} ms)", (Object)cacheRefreshPeriodMS);
            cacheUpdateMaster = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setName("CachedStore-CacheUpdateService: Thread-" + t.getId());
                    t.setDaemon(true);
                    return t;
                }
            });
            if (!runOnlyOnce) {
                cacheUpdateMaster.scheduleAtFixedRate(new CacheUpdateMasterWork(conf, shouldRunPrewarm), 0L, cacheRefreshPeriodMS, TimeUnit.MILLISECONDS);
            }
        }
        if (runOnlyOnce) {
            cacheUpdateMaster.schedule(new CacheUpdateMasterWork(conf, shouldRunPrewarm), 0L, TimeUnit.MILLISECONDS);
        }
    }

    @VisibleForTesting
    static synchronized boolean stopCacheUpdateService(long timeout) {
        boolean tasksStoppedBeforeShutdown = false;
        if (cacheUpdateMaster != null) {
            LOG.info("CachedStore: shutting down cache update service");
            try {
                tasksStoppedBeforeShutdown = cacheUpdateMaster.awaitTermination(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOG.info("CachedStore: cache update service was interrupted while waiting for tasks to complete before shutting down. Will make a hard stop now.");
            }
            cacheUpdateMaster.shutdownNow();
            cacheUpdateMaster = null;
        }
        return tasksStoppedBeforeShutdown;
    }

    @VisibleForTesting
    static void setCacheRefreshPeriod(long time) {
        cacheRefreshPeriodMS = time;
    }

    public Configuration getConf() {
        return this.rawStore.getConf();
    }

    @Override
    public void shutdown() {
        this.rawStore.shutdown();
    }

    @Override
    public boolean openTransaction() {
        return this.rawStore.openTransaction();
    }

    @Override
    public boolean commitTransaction() {
        if (!this.rawStore.commitTransaction()) {
            return false;
        }
        this.updateCacheUsingEvents();
        return true;
    }

    private void updateCacheUsingEvents() {
        if (canUseEvents) {
            try {
                CachedStore.triggerUpdateUsingEvent(this.rawStore);
            }
            catch (Exception e) {
                LOG.error("Failed to update cache", (Throwable)e);
            }
        }
    }

    @Override
    public boolean isActiveTransaction() {
        return this.rawStore.isActiveTransaction();
    }

    @Override
    public void rollbackTransaction() {
        this.rawStore.rollbackTransaction();
    }

    @Override
    public void createCatalog(Catalog cat) throws MetaException {
        this.rawStore.createCatalog(cat);
        if (!canUseEvents) {
            sharedCache.addCatalogToCache(cat);
        }
    }

    @Override
    public void alterCatalog(String catName, Catalog cat) throws MetaException, InvalidOperationException {
        this.rawStore.alterCatalog(catName, cat);
        if (!canUseEvents) {
            sharedCache.alterCatalogInCache(StringUtils.normalizeIdentifier((String)catName), cat);
        }
    }

    @Override
    public Catalog getCatalog(String catalogName) throws NoSuchObjectException, MetaException {
        if (!sharedCache.isCatalogCachePrewarmed() || canUseEvents) {
            return this.rawStore.getCatalog(catalogName);
        }
        Catalog cat = sharedCache.getCatalogFromCache(StringUtils.normalizeIdentifier((String)catalogName));
        if (cat == null) {
            throw new NoSuchObjectException();
        }
        return cat;
    }

    @Override
    public List<String> getCatalogs() {
        if (!sharedCache.isCatalogCachePrewarmed() || canUseEvents) {
            return this.rawStore.getCatalogs();
        }
        return sharedCache.listCachedCatalogs();
    }

    @Override
    public void dropCatalog(String catalogName) throws NoSuchObjectException, MetaException {
        this.rawStore.dropCatalog(catalogName);
        if (!canUseEvents) {
            catalogName = catalogName.toLowerCase();
            sharedCache.removeCatalogFromCache(catalogName);
        }
    }

    @Override
    public void createDatabase(Database db) throws InvalidObjectException, MetaException {
        if (db.getType() == null) {
            db.setType(DatabaseType.NATIVE);
        }
        this.rawStore.createDatabase(db);
        if (!canUseEvents) {
            sharedCache.addDatabaseToCache(db);
        }
    }

    @Override
    public Database getDatabase(String catName, String dbName) throws NoSuchObjectException {
        if (!sharedCache.isDatabaseCachePrewarmed() || canUseEvents && this.rawStore.isActiveTransaction()) {
            return this.rawStore.getDatabase(catName, dbName);
        }
        dbName = dbName.toLowerCase();
        Database db = sharedCache.getDatabaseFromCache(StringUtils.normalizeIdentifier((String)catName), StringUtils.normalizeIdentifier((String)dbName));
        if (db == null) {
            throw new NoSuchObjectException();
        }
        return db;
    }

    @Override
    public boolean dropDatabase(String catName, String dbName) throws NoSuchObjectException, MetaException {
        boolean succ = this.rawStore.dropDatabase(catName, dbName);
        if (succ && !canUseEvents) {
            sharedCache.removeDatabaseFromCache(StringUtils.normalizeIdentifier((String)catName), StringUtils.normalizeIdentifier((String)dbName));
        }
        return succ;
    }

    @Override
    public boolean alterDatabase(String catName, String dbName, Database db) throws NoSuchObjectException, MetaException {
        boolean succ = this.rawStore.alterDatabase(catName, dbName, db);
        if (succ && !canUseEvents) {
            sharedCache.alterDatabaseInCache(StringUtils.normalizeIdentifier((String)catName), StringUtils.normalizeIdentifier((String)dbName), db);
        }
        return succ;
    }

    @Override
    public List<String> getDatabases(String catName, String pattern) throws MetaException {
        if (!sharedCache.isDatabaseCachePrewarmed() || canUseEvents && this.rawStore.isActiveTransaction()) {
            return this.rawStore.getDatabases(catName, pattern);
        }
        return sharedCache.listCachedDatabases(catName, pattern);
    }

    @Override
    public List<String> getAllDatabases(String catName) throws MetaException {
        if (!sharedCache.isDatabaseCachePrewarmed() || canUseEvents && this.rawStore.isActiveTransaction()) {
            return this.rawStore.getAllDatabases(catName);
        }
        return sharedCache.listCachedDatabases(catName);
    }

    @Override
    public List<Database> getDatabaseObjects(String catName, String pattern) throws MetaException {
        if (!sharedCache.isDatabaseCachePrewarmed() || canUseEvents && this.rawStore.isActiveTransaction()) {
            return this.rawStore.getDatabaseObjects(catName, pattern);
        }
        List<String> dbNames = pattern == null || pattern.equals("*") ? sharedCache.listCachedDatabases(catName) : sharedCache.listCachedDatabases(catName, pattern);
        ArrayList<Database> databases = new ArrayList<Database>(dbNames.size());
        for (String dbName : dbNames) {
            Database db = sharedCache.getDatabaseFromCache(catName, dbName);
            if (db == null) continue;
            databases.add(db);
        }
        return databases;
    }

    @Override
    public void createDataConnector(DataConnector connector) throws InvalidObjectException, MetaException {
        this.rawStore.createDataConnector(connector);
    }

    @Override
    public DataConnector getDataConnector(String dcName) throws NoSuchObjectException {
        return this.rawStore.getDataConnector(dcName);
    }

    @Override
    public boolean dropDataConnector(String dcName) throws NoSuchObjectException, MetaException {
        return this.rawStore.dropDataConnector(dcName);
    }

    @Override
    public boolean alterDataConnector(String dcName, DataConnector connector) throws NoSuchObjectException, MetaException {
        return this.rawStore.alterDataConnector(dcName, connector);
    }

    @Override
    public List<String> getAllDataConnectorNames() throws MetaException {
        return this.rawStore.getAllDataConnectorNames();
    }

    @Override
    public boolean createType(Type type) {
        return this.rawStore.createType(type);
    }

    @Override
    public Type getType(String typeName) {
        return this.rawStore.getType(typeName);
    }

    @Override
    public boolean dropType(String typeName) {
        return this.rawStore.dropType(typeName);
    }

    private void validateTableType(Table tbl) {
        String tableType = tbl.getTableType();
        boolean isExternal = Boolean.parseBoolean((String)tbl.getParameters().get("EXTERNAL"));
        if (TableType.MANAGED_TABLE.toString().equals(tableType) && isExternal) {
            tableType = TableType.EXTERNAL_TABLE.toString();
        }
        if (TableType.EXTERNAL_TABLE.toString().equals(tableType) && !isExternal) {
            tableType = TableType.MANAGED_TABLE.toString();
        }
        tbl.setTableType(tableType);
    }

    @Override
    public void createTable(Table tbl) throws InvalidObjectException, MetaException {
        String tblName;
        String dbName;
        this.rawStore.createTable(tbl);
        if (canUseEvents) {
            return;
        }
        String catName = StringUtils.normalizeIdentifier((String)tbl.getCatName());
        if (!CachedStore.shouldCacheTable(catName, dbName = StringUtils.normalizeIdentifier((String)tbl.getDbName()), tblName = StringUtils.normalizeIdentifier((String)tbl.getTableName()))) {
            return;
        }
        this.validateTableType(tbl);
        sharedCache.addTableToCache(catName, dbName, tblName, tbl);
        sharedCache.addTableConstraintsToCache(catName, dbName, tblName, new SQLAllTableConstraints());
    }

    @Override
    public boolean dropTable(String catName, String dbName, String tblName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
        boolean succ = this.rawStore.dropTable(catName, dbName, tblName);
        if (succ && !canUseEvents) {
            if (!CachedStore.shouldCacheTable(catName = StringUtils.normalizeIdentifier((String)catName), dbName = StringUtils.normalizeIdentifier((String)dbName), tblName = StringUtils.normalizeIdentifier((String)tblName))) {
                return succ;
            }
            sharedCache.removeTableFromCache(catName, dbName, tblName);
        }
        return succ;
    }

    @Override
    public Table getTable(String catName, String dbName, String tblName) throws MetaException {
        return this.getTable(catName, dbName, tblName, null);
    }

    @Override
    public Table getTable(String catName, String dbName, String tblName, String validWriteIds) throws MetaException {
        return this.getTable(catName, dbName, tblName, null, -1L);
    }

    @Override
    public Table getTable(String catName, String dbName, String tblName, String validWriteIds, long tableId) throws MetaException {
        String tableType;
        if (!CachedStore.shouldCacheTable(catName = StringUtils.normalizeIdentifier((String)Optional.ofNullable(catName).orElse(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf))), dbName = StringUtils.normalizeIdentifier((String)dbName), tblName = StringUtils.normalizeIdentifier((String)tblName)) || canUseEvents && this.rawStore.isActiveTransaction()) {
            return this.rawStore.getTable(catName, dbName, tblName, validWriteIds);
        }
        Table tbl = sharedCache.getTableFromCache(catName, dbName, tblName);
        if (tbl == null) {
            tblsPendingPrewarm.prioritizeTableForPrewarm(tblName);
            Table t = this.rawStore.getTable(catName, dbName, tblName, validWriteIds);
            if (t != null) {
                sharedCache.addTableToCache(catName, dbName, tblName, t);
            }
            return t;
        }
        if (validWriteIds != null) {
            tbl.setParameters(this.adjustStatsParamsForGet(tbl.getParameters(), tbl.getParameters(), tbl.getWriteId(), validWriteIds));
        }
        tbl.unsetPrivileges();
        tbl.setRewriteEnabled(tbl.isRewriteEnabled());
        if (tbl.getPartitionKeys() == null) {
            tbl.setPartitionKeys(new ArrayList());
        }
        if ((tableType = tbl.getTableType()) == null) {
            tableType = tbl.getViewOriginalText() != null ? TableType.VIRTUAL_VIEW.toString() : ("TRUE".equals(tbl.getParameters().get("EXTERNAL")) ? TableType.EXTERNAL_TABLE.toString() : TableType.MANAGED_TABLE.toString());
        }
        tbl.setTableType(tableType);
        return tbl;
    }

    @Override
    public boolean addPartition(Partition part) throws InvalidObjectException, MetaException {
        boolean succ = this.rawStore.addPartition(part);
        if (succ && !canUseEvents) {
            String catName;
            String dbName = StringUtils.normalizeIdentifier((String)part.getDbName());
            String tblName = StringUtils.normalizeIdentifier((String)part.getTableName());
            String string = catName = part.isSetCatName() ? StringUtils.normalizeIdentifier((String)part.getCatName()) : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
            if (!CachedStore.shouldCacheTable(catName, dbName, tblName)) {
                return succ;
            }
            sharedCache.addPartitionToCache(catName, dbName, tblName, part);
        }
        return succ;
    }

    @Override
    public boolean addPartitions(String catName, String dbName, String tblName, List<Partition> parts) throws InvalidObjectException, MetaException {
        boolean succ = this.rawStore.addPartitions(catName, dbName, tblName, parts);
        if (succ && !canUseEvents) {
            if (!CachedStore.shouldCacheTable(catName = StringUtils.normalizeIdentifier((String)catName), dbName = StringUtils.normalizeIdentifier((String)dbName), tblName = StringUtils.normalizeIdentifier((String)tblName))) {
                return succ;
            }
            sharedCache.addPartitionsToCache(catName, dbName, tblName, parts);
        }
        return succ;
    }

    @Override
    public Partition getPartition(String catName, String dbName, String tblName, List<String> partVals) throws MetaException, NoSuchObjectException {
        return this.getPartition(catName, dbName, tblName, partVals, null);
    }

    @Override
    public Partition getPartition(String catName, String dbName, String tblName, List<String> partVals, String validWriteIds) throws MetaException, NoSuchObjectException {
        if (!CachedStore.shouldCacheTable(catName = StringUtils.normalizeIdentifier((String)catName), dbName = StringUtils.normalizeIdentifier((String)dbName), tblName = StringUtils.normalizeIdentifier((String)tblName)) || canUseEvents && this.rawStore.isActiveTransaction()) {
            return this.rawStore.getPartition(catName, dbName, tblName, partVals, validWriteIds);
        }
        Partition part = sharedCache.getPartitionFromCache(catName, dbName, tblName, partVals);
        if (part == null) {
            return this.rawStore.getPartition(catName, dbName, tblName, partVals, validWriteIds);
        }
        if (validWriteIds != null) {
            Table table = sharedCache.getTableFromCache(catName, dbName, tblName);
            if (table == null) {
                return this.rawStore.getPartition(catName, dbName, tblName, partVals, validWriteIds);
            }
            part.setParameters(this.adjustStatsParamsForGet(table.getParameters(), part.getParameters(), part.getWriteId(), validWriteIds));
        }
        return part;
    }

    @Override
    public boolean doesPartitionExist(String catName, String dbName, String tblName, List<FieldSchema> partKeys, List<String> partVals) throws MetaException, NoSuchObjectException {
        if (!CachedStore.shouldCacheTable(catName = StringUtils.normalizeIdentifier((String)catName), dbName = StringUtils.normalizeIdentifier((String)dbName), tblName = StringUtils.normalizeIdentifier((String)tblName)) || canUseEvents && this.rawStore.isActiveTransaction()) {
            return this.rawStore.doesPartitionExist(catName, dbName, tblName, partKeys, partVals);
        }
        Table tbl = sharedCache.getTableFromCache(catName, dbName, tblName);
        if (tbl == null) {
            return this.rawStore.doesPartitionExist(catName, dbName, tblName, partKeys, partVals);
        }
        return sharedCache.existPartitionFromCache(catName, dbName, tblName, partVals);
    }

    @Override
    public boolean dropPartition(String catName, String dbName, String tblName, String partName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
        boolean succ = this.rawStore.dropPartition(catName, dbName, tblName, partName);
        if (succ && !canUseEvents && CachedStore.shouldCacheTable(catName = StringUtils.normalizeIdentifier((String)catName), dbName = StringUtils.normalizeIdentifier((String)dbName), tblName = StringUtils.normalizeIdentifier((String)tblName))) {
            sharedCache.removePartitionFromCache(catName, dbName, tblName, CachedStore.partNameToVals(partName));
        }
        return succ;
    }

    @Override
    public void dropPartitions(String catName, String dbName, String tblName, List<String> partNames) throws MetaException, NoSuchObjectException {
        this.rawStore.dropPartitions(catName, dbName, tblName, partNames);
        if (canUseEvents) {
            return;
        }
        if (!CachedStore.shouldCacheTable(catName = StringUtils.normalizeIdentifier((String)catName), dbName = StringUtils.normalizeIdentifier((String)dbName), tblName = StringUtils.normalizeIdentifier((String)tblName))) {
            return;
        }
        ArrayList<List<String>> partVals = new ArrayList<List<String>>();
        for (String partName : partNames) {
            partVals.add(CachedStore.partNameToVals(partName));
        }
        sharedCache.removePartitionsFromCache(catName, dbName, tblName, partVals);
    }

    @Override
    public List<Partition> getPartitions(String catName, String dbName, String tblName, GetPartitionsArgs args) throws MetaException, NoSuchObjectException {
        if (!CachedStore.shouldCacheTable(catName = StringUtils.normalizeIdentifier((String)catName), dbName = StringUtils.normalizeIdentifier((String)dbName), tblName = StringUtils.normalizeIdentifier((String)tblName)) || canUseEvents && this.rawStore.isActiveTransaction()) {
            return this.rawStore.getPartitions(catName, dbName, tblName, args);
        }
        Table tbl = sharedCache.getTableFromCache(catName, dbName, tblName);
        if (tbl == null) {
            return this.rawStore.getPartitions(catName, dbName, tblName, args);
        }
        List<Partition> parts = sharedCache.listCachedPartitions(catName, dbName, tblName, args.getMax());
        return parts;
    }

    @Override
    public Map<String, String> getPartitionLocations(String catName, String dbName, String tblName, String baseLocationToNotShow, int max) {
        return this.rawStore.getPartitionLocations(catName, dbName, tblName, baseLocationToNotShow, max);
    }

    @Override
    public Table alterTable(String catName, String dbName, String tblName, Table newTable, String validWriteIds) throws InvalidObjectException, MetaException {
        newTable = this.rawStore.alterTable(catName, dbName, tblName, newTable, validWriteIds);
        if (canUseEvents) {
            return newTable;
        }
        catName = StringUtils.normalizeIdentifier((String)catName);
        dbName = StringUtils.normalizeIdentifier((String)dbName);
        tblName = StringUtils.normalizeIdentifier((String)tblName);
        String newTblName = StringUtils.normalizeIdentifier((String)newTable.getTableName());
        if (!CachedStore.shouldCacheTable(catName, dbName, tblName) && !CachedStore.shouldCacheTable(catName, dbName, newTblName)) {
            return newTable;
        }
        Table tbl = sharedCache.getTableFromCache(catName, dbName, tblName);
        if (tbl == null) {
            return newTable;
        }
        if (CachedStore.shouldCacheTable(catName, dbName, tblName) && CachedStore.shouldCacheTable(catName, dbName, newTblName)) {
            sharedCache.alterTableInCache(catName, dbName, tblName, newTable);
        } else if (!CachedStore.shouldCacheTable(catName, dbName, tblName) && CachedStore.shouldCacheTable(catName, dbName, newTblName)) {
            sharedCache.addTableToCache(catName, dbName, newTblName, newTable);
        } else if (CachedStore.shouldCacheTable(catName, dbName, tblName) && !CachedStore.shouldCacheTable(catName, dbName, newTblName)) {
            sharedCache.removeTableFromCache(catName, dbName, tblName);
        }
        return newTable;
    }

    @Override
    public void updateCreationMetadata(String catName, String dbname, String tablename, CreationMetadata cm) throws MetaException {
        this.rawStore.updateCreationMetadata(catName, dbname, tablename, cm);
    }

    @Override
    public List<String> getTables(String catName, String dbName, String pattern) throws MetaException {
        return this.rawStore.getTables(catName, dbName, pattern);
    }

    @Override
    public List<String> getTables(String catName, String dbName, String pattern, TableType tableType, int limit) throws MetaException {
        return this.rawStore.getTables(catName, dbName, pattern, tableType, limit);
    }

    @Override
    public List<Table> getAllMaterializedViewObjectsForRewriting(String catName) throws MetaException {
        return this.rawStore.getAllMaterializedViewObjectsForRewriting(catName);
    }

    @Override
    public List<String> getMaterializedViewsForRewriting(String catName, String dbName) throws MetaException, NoSuchObjectException {
        return this.rawStore.getMaterializedViewsForRewriting(catName, dbName);
    }

    @Override
    public List<TableMeta> getTableMeta(String catName, String dbNames, String tableNames, List<String> tableTypes) throws MetaException {
        return this.rawStore.getTableMeta(catName, dbNames, tableNames, tableTypes);
    }

    @Override
    public List<Table> getTableObjectsByName(String catName, String dbName, List<String> tblNames) throws MetaException, UnknownDBException {
        if (canUseEvents && this.rawStore.isActiveTransaction()) {
            return this.rawStore.getTableObjectsByName(catName, dbName, tblNames);
        }
        dbName = StringUtils.normalizeIdentifier((String)dbName);
        catName = StringUtils.normalizeIdentifier((String)catName);
        boolean missSomeInCache = false;
        for (String tblName : tblNames) {
            if (CachedStore.shouldCacheTable(catName, dbName, tblName = StringUtils.normalizeIdentifier((String)tblName))) continue;
            missSomeInCache = true;
            break;
        }
        if (!isCachePrewarmed.get() || missSomeInCache) {
            return this.rawStore.getTableObjectsByName(catName, dbName, tblNames);
        }
        Database db = sharedCache.getDatabaseFromCache(catName, dbName);
        if (db == null) {
            throw new UnknownDBException("Could not find database " + dbName);
        }
        ArrayList<Table> tables = new ArrayList<Table>();
        for (String tblName : tblNames) {
            Table tbl = sharedCache.getTableFromCache(catName, dbName, tblName = StringUtils.normalizeIdentifier((String)tblName));
            if (tbl == null) {
                tbl = this.rawStore.getTable(catName, dbName, tblName);
                sharedCache.addTableToCache(catName, dbName, tblName, tbl);
            }
            if (tbl != null) {
                tables.add(tbl);
            }
            tables.add(tbl);
        }
        return tables;
    }

    @Override
    public List<Table> getTableObjectsByName(String catName, String db, List<String> tbl_names, GetProjectionsSpec projectionsSpec, String tablePattern) throws MetaException, UnknownDBException {
        return this.rawStore.getTableObjectsByName(catName, db, tbl_names, projectionsSpec, tablePattern);
    }

    @Override
    public List<String> getAllTables(String catName, String dbName) throws MetaException {
        return this.rawStore.getAllTables(catName, dbName);
    }

    @Override
    public List<String> listTableNamesByFilter(String catName, String dbName, String filter, short maxTables) throws MetaException, UnknownDBException {
        return this.rawStore.listTableNamesByFilter(catName, dbName, filter, maxTables);
    }

    @Override
    public List<String> listPartitionNames(String catName, String dbName, String tblName, short maxParts) throws MetaException {
        if (!CachedStore.shouldCacheTable(catName = StringUtils.normalizeIdentifier((String)catName), dbName = StringUtils.normalizeIdentifier((String)dbName), tblName = StringUtils.normalizeIdentifier((String)tblName)) || canUseEvents && this.rawStore.isActiveTransaction()) {
            return this.rawStore.listPartitionNames(catName, dbName, tblName, maxParts);
        }
        Table tbl = sharedCache.getTableFromCache(catName, dbName, tblName);
        if (tbl == null) {
            return this.rawStore.listPartitionNames(catName, dbName, tblName, maxParts);
        }
        ArrayList<String> partitionNames = new ArrayList<String>();
        short count = 0;
        for (Partition part : sharedCache.listCachedPartitions(catName, dbName, tblName, maxParts)) {
            if (maxParts != -1 && count >= maxParts) continue;
            partitionNames.add(Warehouse.makePartName((List)tbl.getPartitionKeys(), (List)part.getValues()));
        }
        return partitionNames;
    }

    @Override
    public List<String> listPartitionNames(String catName, String dbName, String tblName, String defaultPartName, byte[] exprBytes, String order, int maxParts) throws MetaException, NoSuchObjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> listPartitionNamesByFilter(String catName, String dbName, String tblName, GetPartitionsArgs args) throws MetaException, NoSuchObjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PartitionValuesResponse listPartitionValues(String catName, String dbName, String tblName, List<FieldSchema> cols, boolean applyDistinct, String filter, boolean ascending, List<FieldSchema> order, long maxParts) throws MetaException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Partition alterPartition(String catName, String dbName, String tblName, List<String> partVals, Partition newPart, String validWriteIds) throws InvalidObjectException, MetaException {
        newPart = this.rawStore.alterPartition(catName, dbName, tblName, partVals, newPart, validWriteIds);
        if (canUseEvents) {
            return newPart;
        }
        if (!CachedStore.shouldCacheTable(catName = StringUtils.normalizeIdentifier((String)catName), dbName = StringUtils.normalizeIdentifier((String)dbName), tblName = StringUtils.normalizeIdentifier((String)tblName))) {
            return newPart;
        }
        sharedCache.alterPartitionInCache(catName, dbName, tblName, partVals, newPart);
        return newPart;
    }

    @Override
    public List<Partition> alterPartitions(String catName, String dbName, String tblName, List<List<String>> partValsList, List<Partition> newParts, long writeId, String validWriteIds) throws InvalidObjectException, MetaException {
        newParts = this.rawStore.alterPartitions(catName, dbName, tblName, partValsList, newParts, writeId, validWriteIds);
        if (canUseEvents) {
            return newParts;
        }
        if (!CachedStore.shouldCacheTable(catName = StringUtils.normalizeIdentifier((String)catName), dbName = StringUtils.normalizeIdentifier((String)dbName), tblName = StringUtils.normalizeIdentifier((String)tblName))) {
            return newParts;
        }
        sharedCache.alterPartitionsInCache(catName, dbName, tblName, partValsList, newParts);
        return newParts;
    }

    private boolean getPartitionNamesPrunedByExprNoTxn(Table table, byte[] expr, String defaultPartName, short maxParts, List<String> result, SharedCache sharedCache) throws MetaException, NoSuchObjectException {
        List<Partition> parts = sharedCache.listCachedPartitions(StringUtils.normalizeIdentifier((String)table.getCatName()), StringUtils.normalizeIdentifier((String)table.getDbName()), StringUtils.normalizeIdentifier((String)table.getTableName()), maxParts);
        for (Partition part : parts) {
            result.add(Warehouse.makePartName((List)table.getPartitionKeys(), (List)part.getValues()));
        }
        if (defaultPartName == null || defaultPartName.isEmpty()) {
            defaultPartName = MetastoreConf.getVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DEFAULTPARTITIONNAME);
        }
        return this.expressionProxy.filterPartitionsByExpr(table.getPartitionKeys(), expr, defaultPartName, result);
    }

    @Override
    public List<Partition> getPartitionsByFilter(String catName, String dbName, String tblName, GetPartitionsArgs args) throws MetaException, NoSuchObjectException {
        return this.rawStore.getPartitionsByFilter(catName, dbName, tblName, args);
    }

    @Override
    public List<Partition> getPartitionSpecsByFilterAndProjection(Table table, GetProjectionsSpec projectionSpec, GetPartitionsFilterSpec filterSpec) throws MetaException, NoSuchObjectException {
        return this.rawStore.getPartitionSpecsByFilterAndProjection(table, projectionSpec, filterSpec);
    }

    @Override
    public boolean getPartitionsByExpr(String catName, String dbName, String tblName, List<Partition> result, GetPartitionsArgs args) throws TException {
        if (!CachedStore.shouldCacheTable(catName = StringUtils.normalizeIdentifier((String)catName), dbName = StringUtils.normalizeIdentifier((String)dbName), tblName = StringUtils.normalizeIdentifier((String)tblName)) || canUseEvents && this.rawStore.isActiveTransaction()) {
            return this.rawStore.getPartitionsByExpr(catName, dbName, tblName, result, args);
        }
        LinkedList<String> partNames = new LinkedList<String>();
        Table table = sharedCache.getTableFromCache(catName, dbName, tblName);
        if (table == null) {
            return this.rawStore.getPartitionsByExpr(catName, dbName, tblName, result, args);
        }
        boolean hasUnknownPartitions = this.getPartitionNamesPrunedByExprNoTxn(table, args.getExpr(), args.getDefaultPartName(), (short)args.getMax(), partNames, sharedCache);
        for (String partName : partNames) {
            Partition part = sharedCache.getPartitionFromCache(catName, dbName, tblName, CachedStore.partNameToVals(partName));
            part.unsetPrivileges();
            result.add(part);
        }
        return hasUnknownPartitions;
    }

    @Override
    public int getNumPartitionsByFilter(String catName, String dbName, String tblName, String filter) throws MetaException, NoSuchObjectException {
        return this.rawStore.getNumPartitionsByFilter(catName, dbName, tblName, filter);
    }

    @VisibleForTesting
    public static List<String> partNameToVals(String name) {
        String[] kvp;
        if (name == null) {
            return null;
        }
        ArrayList<String> vals = new ArrayList<String>();
        for (String kv : kvp = name.split("/")) {
            vals.add(FileUtils.unescapePathName((String)kv.substring(kv.indexOf(61) + 1)));
        }
        return vals;
    }

    @Override
    public List<Partition> getPartitionsByNames(String catName, String dbName, String tblName, GetPartitionsArgs args) throws MetaException, NoSuchObjectException {
        if (!CachedStore.shouldCacheTable(catName = StringUtils.normalizeIdentifier((String)catName), dbName = StringUtils.normalizeIdentifier((String)dbName), tblName = StringUtils.normalizeIdentifier((String)tblName)) || canUseEvents && this.rawStore.isActiveTransaction()) {
            return this.rawStore.getPartitionsByNames(catName, dbName, tblName, args);
        }
        Table table = sharedCache.getTableFromCache(catName, dbName, tblName);
        if (table == null) {
            return this.rawStore.getPartitionsByNames(catName, dbName, tblName, args);
        }
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (String partName : args.getPartNames()) {
            Partition part = sharedCache.getPartitionFromCache(catName, dbName, tblName, CachedStore.partNameToVals(partName));
            if (part == null) continue;
            partitions.add(part);
        }
        return partitions;
    }

    @Override
    public Table markPartitionForEvent(String catName, String dbName, String tblName, Map<String, String> partVals, PartitionEventType evtType) throws MetaException, UnknownTableException, InvalidPartitionException, UnknownPartitionException {
        return this.rawStore.markPartitionForEvent(catName, dbName, tblName, partVals, evtType);
    }

    @Override
    public boolean isPartitionMarkedForEvent(String catName, String dbName, String tblName, Map<String, String> partName, PartitionEventType evtType) throws MetaException, UnknownTableException, InvalidPartitionException, UnknownPartitionException {
        return this.rawStore.isPartitionMarkedForEvent(catName, dbName, tblName, partName, evtType);
    }

    @Override
    public boolean addRole(String rowName, String ownerName) throws InvalidObjectException, MetaException, NoSuchObjectException {
        return this.rawStore.addRole(rowName, ownerName);
    }

    @Override
    public boolean removeRole(String roleName) throws MetaException, NoSuchObjectException {
        return this.rawStore.removeRole(roleName);
    }

    @Override
    public boolean grantRole(Role role, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws MetaException, NoSuchObjectException, InvalidObjectException {
        return this.rawStore.grantRole(role, userName, principalType, grantor, grantorType, grantOption);
    }

    @Override
    public boolean revokeRole(Role role, String userName, PrincipalType principalType, boolean grantOption) throws MetaException, NoSuchObjectException {
        return this.rawStore.revokeRole(role, userName, principalType, grantOption);
    }

    @Override
    public PrincipalPrivilegeSet getUserPrivilegeSet(String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        return this.rawStore.getUserPrivilegeSet(userName, groupNames);
    }

    @Override
    public PrincipalPrivilegeSet getDBPrivilegeSet(String catName, String dbName, String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        return this.rawStore.getDBPrivilegeSet(catName, dbName, userName, groupNames);
    }

    @Override
    public PrincipalPrivilegeSet getConnectorPrivilegeSet(String catName, String connectorName, String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        return this.rawStore.getConnectorPrivilegeSet(catName, connectorName, userName, groupNames);
    }

    @Override
    public PrincipalPrivilegeSet getTablePrivilegeSet(String catName, String dbName, String tableName, String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        return this.rawStore.getTablePrivilegeSet(catName, dbName, tableName, userName, groupNames);
    }

    @Override
    public PrincipalPrivilegeSet getPartitionPrivilegeSet(String catName, String dbName, String tableName, String partition, String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        return this.rawStore.getPartitionPrivilegeSet(catName, dbName, tableName, partition, userName, groupNames);
    }

    @Override
    public PrincipalPrivilegeSet getColumnPrivilegeSet(String catName, String dbName, String tableName, String partitionName, String columnName, String userName, List<String> groupNames) throws InvalidObjectException, MetaException {
        return this.rawStore.getColumnPrivilegeSet(catName, dbName, tableName, partitionName, columnName, userName, groupNames);
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalGlobalGrants(String principalName, PrincipalType principalType) {
        return this.rawStore.listPrincipalGlobalGrants(principalName, principalType);
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalDBGrants(String principalName, PrincipalType principalType, String catName, String dbName) {
        return this.rawStore.listPrincipalDBGrants(principalName, principalType, catName, dbName);
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalDCGrants(String principalName, PrincipalType principalType, String dcName) {
        return this.rawStore.listPrincipalDCGrants(principalName, principalType, dcName);
    }

    @Override
    public List<HiveObjectPrivilege> listAllTableGrants(String principalName, PrincipalType principalType, String catName, String dbName, String tableName) {
        return this.rawStore.listAllTableGrants(principalName, principalType, catName, dbName, tableName);
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalPartitionGrants(String principalName, PrincipalType principalType, String catName, String dbName, String tableName, List<String> partValues, String partName) {
        return this.rawStore.listPrincipalPartitionGrants(principalName, principalType, catName, dbName, tableName, partValues, partName);
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalTableColumnGrants(String principalName, PrincipalType principalType, String catName, String dbName, String tableName, String columnName) {
        return this.rawStore.listPrincipalTableColumnGrants(principalName, principalType, catName, dbName, tableName, columnName);
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalPartitionColumnGrants(String principalName, PrincipalType principalType, String catName, String dbName, String tableName, List<String> partValues, String partName, String columnName) {
        return this.rawStore.listPrincipalPartitionColumnGrants(principalName, principalType, catName, dbName, tableName, partValues, partName, columnName);
    }

    @Override
    public boolean grantPrivileges(PrivilegeBag privileges) throws InvalidObjectException, MetaException, NoSuchObjectException {
        return this.rawStore.grantPrivileges(privileges);
    }

    @Override
    public boolean revokePrivileges(PrivilegeBag privileges, boolean grantOption) throws InvalidObjectException, MetaException, NoSuchObjectException {
        return this.rawStore.revokePrivileges(privileges, grantOption);
    }

    @Override
    public boolean refreshPrivileges(HiveObjectRef objToRefresh, String authorizer, PrivilegeBag grantPrivileges) throws InvalidObjectException, MetaException, NoSuchObjectException {
        return this.rawStore.refreshPrivileges(objToRefresh, authorizer, grantPrivileges);
    }

    @Override
    public Role getRole(String roleName) throws NoSuchObjectException {
        return this.rawStore.getRole(roleName);
    }

    @Override
    public List<String> listRoleNames() {
        return this.rawStore.listRoleNames();
    }

    @Override
    public List<Role> listRoles(String principalName, PrincipalType principalType) {
        return this.rawStore.listRoles(principalName, principalType);
    }

    @Override
    public List<RolePrincipalGrant> listRolesWithGrants(String principalName, PrincipalType principalType) {
        return this.rawStore.listRolesWithGrants(principalName, principalType);
    }

    @Override
    public List<RolePrincipalGrant> listRoleMembers(String roleName) {
        return this.rawStore.listRoleMembers(roleName);
    }

    @Override
    public Partition getPartitionWithAuth(String catName, String dbName, String tblName, List<String> partVals, String userName, List<String> groupNames) throws MetaException, NoSuchObjectException, InvalidObjectException {
        if (!CachedStore.shouldCacheTable(catName = StringUtils.normalizeIdentifier((String)catName), dbName = StringUtils.normalizeIdentifier((String)dbName), tblName = StringUtils.normalizeIdentifier((String)tblName)) || canUseEvents && this.rawStore.isActiveTransaction()) {
            return this.rawStore.getPartitionWithAuth(catName, dbName, tblName, partVals, userName, groupNames);
        }
        Table table = sharedCache.getTableFromCache(catName, dbName, tblName);
        if (table == null) {
            return this.rawStore.getPartitionWithAuth(catName, dbName, tblName, partVals, userName, groupNames);
        }
        Partition p = sharedCache.getPartitionFromCache(catName, dbName, tblName, partVals);
        if (p == null) {
            throw new NoSuchObjectException("partition values=" + partVals.toString());
        }
        String partName = Warehouse.makePartName((List)table.getPartitionKeys(), partVals);
        PrincipalPrivilegeSet privs = this.getPartitionPrivilegeSet(catName, dbName, tblName, partName, userName, groupNames);
        p.setPrivileges(privs);
        return p;
    }

    @Override
    public List<String> listPartitionNamesPs(String catName, String dbName, String tblName, List<String> partSpecs, short maxParts) throws MetaException, NoSuchObjectException {
        if (!CachedStore.shouldCacheTable(catName = StringUtils.normalizeIdentifier((String)catName), dbName = StringUtils.normalizeIdentifier((String)dbName), tblName = StringUtils.normalizeIdentifier((String)tblName)) || canUseEvents && this.rawStore.isActiveTransaction()) {
            return this.rawStore.listPartitionNamesPs(catName, dbName, tblName, partSpecs, (short)maxParts);
        }
        Table table = sharedCache.getTableFromCache(catName, dbName, tblName);
        if (table == null) {
            return this.rawStore.listPartitionNamesPs(catName, dbName, tblName, partSpecs, (short)maxParts);
        }
        String partNameMatcher = this.getPartNameMatcher(table, partSpecs);
        ArrayList<String> partitionNames = new ArrayList<String>();
        List<Partition> allPartitions = sharedCache.listCachedPartitions(catName, dbName, tblName, maxParts);
        int count = 0;
        for (Partition part : allPartitions) {
            String partName = Warehouse.makePartName((List)table.getPartitionKeys(), (List)part.getValues());
            if (!partName.matches(partNameMatcher) || maxParts != -1 && count >= maxParts) continue;
            partitionNames.add(partName);
            ++count;
        }
        return partitionNames;
    }

    @Override
    public int getNumPartitionsByPs(String catName, String dbName, String tblName, List<String> partSpecs) throws MetaException, NoSuchObjectException {
        return this.rawStore.getNumPartitionsByPs(catName, dbName, tblName, partSpecs);
    }

    @Override
    public List<Partition> listPartitionsPsWithAuth(String catName, String dbName, String tblName, GetPartitionsArgs args) throws MetaException, InvalidObjectException, NoSuchObjectException {
        if (!CachedStore.shouldCacheTable(catName = StringUtils.normalizeIdentifier((String)catName), dbName = StringUtils.normalizeIdentifier((String)dbName), tblName = StringUtils.normalizeIdentifier((String)tblName)) || canUseEvents && this.rawStore.isActiveTransaction()) {
            return this.rawStore.listPartitionsPsWithAuth(catName, dbName, tblName, args);
        }
        Table table = sharedCache.getTableFromCache(catName, dbName, tblName);
        if (table == null) {
            return this.rawStore.listPartitionsPsWithAuth(catName, dbName, tblName, args);
        }
        String partNameMatcher = null;
        if (args.getPart_vals() != null && !args.getPart_vals().isEmpty()) {
            partNameMatcher = this.getPartNameMatcher(table, args.getPart_vals());
        }
        int maxParts = args.getMax();
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        List<Partition> allPartitions = sharedCache.listCachedPartitions(catName, dbName, tblName, maxParts);
        int count = 0;
        for (Partition part : allPartitions) {
            String partName = Warehouse.makePartName((List)table.getPartitionKeys(), (List)part.getValues());
            if (partNameMatcher != null && !partName.matches(partNameMatcher) || maxParts != -1 && count >= maxParts) continue;
            PrincipalPrivilegeSet privs = this.getPartitionPrivilegeSet(catName, dbName, tblName, partName, args.getUserName(), args.getGroupNames());
            part.setPrivileges(privs);
            partitions.add(part);
            ++count;
        }
        return partitions;
    }

    private String getPartNameMatcher(Table table, List<String> partSpecs) throws MetaException {
        List partCols = table.getPartitionKeys();
        int numPartKeys = partCols.size();
        if (partSpecs.size() > numPartKeys) {
            throw new MetaException("Incorrect number of partition values. numPartKeys=" + numPartKeys + ", partSpecs=" + partSpecs.size());
        }
        partCols = partCols.subList(0, partSpecs.size());
        Object partNameMatcher = Warehouse.makePartName(partCols, partSpecs, (String)".*");
        if (partSpecs.size() < numPartKeys) {
            partNameMatcher = (String)partNameMatcher + ".*";
        }
        return partNameMatcher;
    }

    private Map<String, String> adjustStatsParamsForGet(Map<String, String> tableParams, Map<String, String> params, long statsWriteId, String validWriteIds) throws MetaException {
        if (!TxnUtils.isTransactionalTable(tableParams)) {
            return params;
        }
        if (areTxnStatsSupported && (validWriteIds == null || ObjectStore.isCurrentStatsValidForTheQuery(params, statsWriteId, validWriteIds, false))) {
            return params;
        }
        params = new HashMap<String, String>(params);
        StatsSetupConst.setBasicStatsState(params, (String)"false");
        return params;
    }

    public static ColumnStatistics adjustColStatForGet(Map<String, String> tableParams, ColumnStatistics colStat, long statsWriteId, String validWriteIds, boolean areTxnStatsSupported) throws MetaException {
        colStat.setIsStatsCompliant(true);
        if (!TxnUtils.isTransactionalTable(tableParams)) {
            return colStat;
        }
        if (areTxnStatsSupported && (validWriteIds == null || ObjectStore.isCurrentStatsValidForTheQuery(tableParams, statsWriteId, validWriteIds, false))) {
            return colStat;
        }
        colStat.setIsStatsCompliant(false);
        return colStat;
    }

    private static void updateTableColumnsStatsInternal(Configuration conf, ColumnStatistics colStats, Map<String, String> newParams, String validWriteIds, long writeId) throws MetaException {
        String tblName;
        String dbName;
        String catName = colStats.getStatsDesc().isSetCatName() ? StringUtils.normalizeIdentifier((String)colStats.getStatsDesc().getCatName()) : MetaStoreUtils.getDefaultCatalog((Configuration)conf);
        if (!CachedStore.shouldCacheTable(catName, dbName = StringUtils.normalizeIdentifier((String)colStats.getStatsDesc().getDbName()), tblName = StringUtils.normalizeIdentifier((String)colStats.getStatsDesc().getTableName()))) {
            return;
        }
        Table table = sharedCache.getTableFromCache(catName, dbName, tblName);
        if (table == null) {
            return;
        }
        boolean isTxn = TxnUtils.isTransactionalTable(table.getParameters());
        if (isTxn && validWriteIds != null) {
            if (!areTxnStatsSupported) {
                StatsSetupConst.setBasicStatsState(newParams, (String)"false");
            } else {
                String errorMsg = ObjectStore.verifyStatsChangeCtx(TableName.getDbTable((String)dbName, (String)tblName), table.getParameters(), newParams, writeId, validWriteIds, true);
                if (errorMsg != null) {
                    throw new MetaException(errorMsg);
                }
                if (!ObjectStore.isCurrentStatsValidForTheQuery(newParams, table.getWriteId(), validWriteIds, true)) {
                    StatsSetupConst.setBasicStatsState(newParams, (String)"false");
                    LOG.info("Removed COLUMN_STATS_ACCURATE from the parameters of the table " + table.getDbName() + "." + table.getTableName());
                }
            }
        }
        table.setWriteId(writeId);
        table.setParameters(newParams);
        sharedCache.alterTableInCache(catName, dbName, tblName, table);
        sharedCache.updateTableColStatsInCache(catName, dbName, tblName, colStats.getStatsObj());
    }

    @Override
    public Map<String, String> updateTableColumnStatistics(ColumnStatistics colStats, String validWriteIds, long writeId) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        Map<String, String> newParams = this.rawStore.updateTableColumnStatistics(colStats, validWriteIds, writeId);
        if (newParams != null && !canUseEvents) {
            CachedStore.updateTableColumnsStatsInternal(this.conf, colStats, newParams, null, writeId);
        }
        return newParams;
    }

    @Override
    public List<ColumnStatistics> getTableColumnStatistics(String catName, String dbName, String tblName, List<String> colNames) throws MetaException, NoSuchObjectException {
        return this.rawStore.getTableColumnStatistics(catName, dbName, tblName, colNames);
    }

    @Override
    public ColumnStatistics getTableColumnStatistics(String catName, String dbName, String tblName, List<String> colNames, String engine) throws MetaException, NoSuchObjectException {
        return this.getTableColumnStatistics(catName, dbName, tblName, colNames, engine, null);
    }

    @Override
    public ColumnStatistics getTableColumnStatistics(String catName, String dbName, String tblName, List<String> colNames, String engine, String validWriteIds) throws MetaException, NoSuchObjectException {
        if (!"hive".equals(engine)) {
            throw new RuntimeException("CachedStore can only be enabled for Hive engine");
        }
        if (!CachedStore.shouldCacheTable(catName = StringUtils.normalizeIdentifier((String)catName), dbName = StringUtils.normalizeIdentifier((String)dbName), tblName = StringUtils.normalizeIdentifier((String)tblName))) {
            return this.rawStore.getTableColumnStatistics(catName, dbName, tblName, colNames, engine, validWriteIds);
        }
        Table table = sharedCache.getTableFromCache(catName, dbName, tblName);
        if (table == null) {
            return this.rawStore.getTableColumnStatistics(catName, dbName, tblName, colNames, engine, validWriteIds);
        }
        ColumnStatistics columnStatistics = sharedCache.getTableColStatsFromCache(catName, dbName, tblName, colNames, validWriteIds, areTxnStatsSupported);
        if (columnStatistics == null) {
            LOG.info("Stat of Table {}.{} for column {} is not present in cache.Getting from raw store", new Object[]{dbName, tblName, colNames});
            return this.rawStore.getTableColumnStatistics(catName, dbName, tblName, colNames, engine, validWriteIds);
        }
        return columnStatistics;
    }

    @Override
    public boolean deleteTableColumnStatistics(String catName, String dbName, String tblName, List<String> colNames, String engine) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        if (!"hive".equals(engine)) {
            throw new RuntimeException("CachedStore can only be enabled for Hive engine");
        }
        boolean succ = this.rawStore.deleteTableColumnStatistics(catName, dbName, tblName, colNames, engine);
        if (succ && !canUseEvents) {
            if (!CachedStore.shouldCacheTable(catName = StringUtils.normalizeIdentifier((String)catName), dbName = StringUtils.normalizeIdentifier((String)dbName), tblName = StringUtils.normalizeIdentifier((String)tblName))) {
                return succ;
            }
            if (colNames == null || colNames.isEmpty()) {
                colNames = this.getTable(catName, dbName, tblName).getSd().getCols().stream().map(FieldSchema::getName).collect(Collectors.toList());
            }
            for (String colName : colNames) {
                sharedCache.removeTableColStatsFromCache(catName, dbName, tblName, colName);
            }
        }
        return succ;
    }

    private void updatePartitionColumnStatisticsInCache(ColumnStatistics colStats, Map<String, String> newParams, List<String> partVals) throws MetaException, NoSuchObjectException {
        String tblName;
        String dbName;
        String catName = colStats.getStatsDesc().isSetCatName() ? StringUtils.normalizeIdentifier((String)colStats.getStatsDesc().getCatName()) : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        if (!CachedStore.shouldCacheTable(catName, dbName = StringUtils.normalizeIdentifier((String)colStats.getStatsDesc().getDbName()), tblName = StringUtils.normalizeIdentifier((String)colStats.getStatsDesc().getTableName()))) {
            return;
        }
        Partition part = this.getPartition(catName, dbName, tblName, partVals);
        part.setParameters(newParams);
        sharedCache.alterPartitionInCache(catName, dbName, tblName, partVals, part);
        sharedCache.updatePartitionColStatsInCache(catName, dbName, tblName, partVals, colStats.getStatsObj());
    }

    @Override
    public Map<String, String> updatePartitionColumnStatistics(ColumnStatistics colStats, List<String> partVals, String validWriteIds, long writeId) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        return this.updatePartitionColumnStatisticsInternal(null, null, colStats, partVals, validWriteIds, writeId);
    }

    @Override
    public Map<String, String> updatePartitionColumnStatistics(Table table, MTable mTable, ColumnStatistics colStats, List<String> partVals, String validWriteIds, long writeId) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        return this.updatePartitionColumnStatisticsInternal(table, mTable, colStats, partVals, validWriteIds, writeId);
    }

    private Map<String, String> updatePartitionColumnStatisticsInternal(Table table, MTable mTable, ColumnStatistics colStats, List<String> partVals, String validWriteIds, long writeId) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        ColumnStatisticsDesc statsDesc = colStats.getStatsDesc();
        Map<String, String> newParams = this.rawStore.updatePartitionColumnStatistics(table = Optional.ofNullable(table).orElse(this.getTable(statsDesc.getCatName(), statsDesc.getDbName(), statsDesc.getTableName())), mTable = Optional.ofNullable(mTable).orElse(this.ensureGetMTable(statsDesc.getCatName(), statsDesc.getDbName(), statsDesc.getTableName())), colStats, partVals, validWriteIds, writeId);
        if (newParams != null && !canUseEvents) {
            this.updatePartitionColumnStatisticsInCache(colStats, newParams, partVals);
        }
        return newParams;
    }

    @Override
    public Map<String, Map<String, String>> updatePartitionColumnStatisticsInBatch(Map<String, ColumnStatistics> partColStatsMap, Table tbl, List<TransactionalMetaStoreEventListener> listeners, String validWriteIds, long writeId) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        Map<String, Map<String, String>> result = this.rawStore.updatePartitionColumnStatisticsInBatch(partColStatsMap, tbl, listeners, validWriteIds, writeId);
        if (result == null) {
            return null;
        }
        if (!canUseEvents) {
            for (Map.Entry<String, Map<String, String>> entry : result.entrySet()) {
                Map<String, String> newParams = entry.getValue();
                ColumnStatistics colStats = partColStatsMap.get(entry.getKey());
                List<String> partVals = HMSHandler.getPartValsFromName(tbl, colStats.getStatsDesc().getPartName());
                this.updatePartitionColumnStatisticsInCache(colStats, newParams, partVals);
            }
        } else {
            this.updateCacheUsingEvents();
        }
        return result;
    }

    @Override
    public List<List<ColumnStatistics>> getPartitionColumnStatistics(String catName, String dbName, String tblName, List<String> partNames, List<String> colNames) throws MetaException, NoSuchObjectException {
        return this.rawStore.getPartitionColumnStatistics(catName, dbName, tblName, partNames, colNames);
    }

    @Override
    public List<ColumnStatistics> getPartitionColumnStatistics(String catName, String dbName, String tblName, List<String> partNames, List<String> colNames, String engine) throws MetaException, NoSuchObjectException {
        return this.getPartitionColumnStatistics(catName, dbName, tblName, partNames, colNames, engine, null);
    }

    @Override
    public List<ColumnStatistics> getPartitionColumnStatistics(String catName, String dbName, String tblName, List<String> partNames, List<String> colNames, String engine, String writeIdList) throws MetaException, NoSuchObjectException {
        if (!"hive".equals(engine)) {
            throw new RuntimeException("CachedStore can only be enabled for Hive engine");
        }
        List<ColumnStatistics> columnStatistics = sharedCache.getPartitionColStatsListFromCache(catName, dbName, tblName, partNames, colNames, writeIdList, areTxnStatsSupported);
        if (columnStatistics == null) {
            return this.rawStore.getPartitionColumnStatistics(catName, dbName, tblName, partNames, colNames, engine, writeIdList);
        }
        return columnStatistics;
    }

    @Override
    public boolean deletePartitionColumnStatistics(String catName, String dbName, String tblName, List<String> partNames, List<String> colNames, String engine) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        if (!"hive".equals(engine)) {
            throw new RuntimeException("CachedStore can only be enabled for Hive engine");
        }
        boolean succ = this.rawStore.deletePartitionColumnStatistics(catName, dbName, tblName, partNames, colNames, engine);
        if (succ && !canUseEvents) {
            if (!CachedStore.shouldCacheTable(catName = StringUtils.normalizeIdentifier((String)catName), dbName = StringUtils.normalizeIdentifier((String)dbName), tblName = StringUtils.normalizeIdentifier((String)tblName))) {
                return succ;
            }
            Table table = this.rawStore.getTable(catName, dbName, tblName);
            if (colNames == null || colNames.isEmpty()) {
                colNames = table.getSd().getCols().stream().map(FieldSchema::getName).collect(Collectors.toList());
            }
            for (String partName : partNames) {
                List<String> partVals = HMSHandler.getPartValsFromName(table, partName);
                for (String colName : colNames) {
                    sharedCache.removePartitionColStatsFromCache(catName, dbName, tblName, partVals, colName);
                }
            }
        }
        return succ;
    }

    @Override
    public AggrStats get_aggr_stats_for(String catName, String dbName, String tblName, List<String> partNames, List<String> colNames, String engine) throws MetaException, NoSuchObjectException {
        return this.get_aggr_stats_for(catName, dbName, tblName, partNames, colNames, engine, null);
    }

    @Override
    public AggrStats get_aggr_stats_for(String catName, String dbName, String tblName, List<String> partNames, List<String> colNames, String engine, String writeIdList) throws MetaException, NoSuchObjectException {
        String defaultPartitionName;
        if (!"hive".equals(engine)) {
            throw new RuntimeException("CachedStore can only be enabled for Hive engine");
        }
        if (!CachedStore.shouldCacheTable(catName = StringUtils.normalizeIdentifier((String)catName), dbName = StringUtils.normalizeIdentifier((String)dbName), tblName = StringUtils.normalizeIdentifier((String)tblName)) || writeIdList != null && !canUseEvents) {
            return this.rawStore.get_aggr_stats_for(catName, dbName, tblName, partNames, colNames, engine, writeIdList);
        }
        Table table = sharedCache.getTableFromCache(catName, dbName, tblName);
        if (table == null) {
            return this.rawStore.get_aggr_stats_for(catName, dbName, tblName, partNames, colNames, engine, writeIdList);
        }
        List<String> allPartNames = this.rawStore.listPartitionNames(catName, dbName, tblName, (short)-1);
        SharedCache.StatsType type = SharedCache.StatsType.PARTIAL;
        if (partNames.size() == allPartNames.size()) {
            List<ColumnStatisticsObj> colStats = sharedCache.getAggrStatsFromCache(catName, dbName, tblName, colNames, SharedCache.StatsType.ALL);
            if (colStats != null) {
                return new AggrStats(colStats, (long)partNames.size());
            }
            type = SharedCache.StatsType.ALL;
        } else if (partNames.size() == allPartNames.size() - 1 && !partNames.contains(defaultPartitionName = MetastoreConf.getVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DEFAULTPARTITIONNAME))) {
            List<ColumnStatisticsObj> colStats = sharedCache.getAggrStatsFromCache(catName, dbName, tblName, colNames, SharedCache.StatsType.ALLBUTDEFAULT);
            if (colStats != null) {
                return new AggrStats(colStats, (long)partNames.size());
            }
            type = SharedCache.StatsType.ALLBUTDEFAULT;
        }
        LOG.debug("Didn't find aggr stats in cache. Merging them. tblName= {}, parts= {}, cols= {}", new Object[]{tblName, partNames, colNames});
        MergedColumnStatsForPartitions mergedColStats = this.mergeColStatsForPartitions(catName, dbName, tblName, partNames, colNames, sharedCache, type, writeIdList);
        if (mergedColStats == null) {
            LOG.info("Aggregate stats of partition " + TableName.getQualified((String)catName, (String)dbName, (String)tblName) + "." + String.valueOf(partNames) + " for columns " + String.valueOf(colNames) + " is not present in cache. Getting it from raw store");
            return this.rawStore.get_aggr_stats_for(catName, dbName, tblName, partNames, colNames, engine, writeIdList);
        }
        return new AggrStats(mergedColStats.getColStats(), mergedColStats.getPartsFound());
    }

    private MergedColumnStatsForPartitions mergeColStatsForPartitions(String catName, String dbName, String tblName, List<String> partNames, List<String> colNames, SharedCache sharedCache, SharedCache.StatsType type, String writeIdList) throws MetaException {
        boolean useDensityFunctionForNDVEstimation = MetastoreConf.getBoolVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STATS_NDV_DENSITY_FUNCTION);
        double ndvTuner = MetastoreConf.getDoubleVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STATS_NDV_TUNER);
        HashMap<ColumnStatsAggregator, List<MetaStoreServerUtils.ColStatsObjWithSourceInfo>> colStatsMap = new HashMap<ColumnStatsAggregator, List<MetaStoreServerUtils.ColStatsObjWithSourceInfo>>();
        long partsFound = partNames.size();
        HashMap<List<String>, Long> partNameToWriteId = writeIdList != null ? new HashMap<List<String>, Long>() : null;
        for (String colName : colNames) {
            long partsFoundForColumn = 0L;
            ColumnStatsAggregator colStatsAggregator = null;
            ArrayList<MetaStoreServerUtils.ColStatsObjWithSourceInfo> colStatsWithPartInfoList = new ArrayList<MetaStoreServerUtils.ColStatsObjWithSourceInfo>();
            for (String partName : partNames) {
                List<String> partValue = CachedStore.partNameToVals(partName);
                SharedCache.ColumStatsWithWriteId colStatsWriteId = sharedCache.getPartitionColStatsFromCache(catName, dbName, tblName, partValue, colName, writeIdList);
                if (colStatsWriteId == null) {
                    return null;
                }
                if (colStatsWriteId.getColumnStatisticsObj() != null) {
                    ColumnStatisticsObj colStatsForPart = colStatsWriteId.getColumnStatisticsObj();
                    if (partNameToWriteId != null) {
                        partNameToWriteId.put(partValue, colStatsWriteId.getWriteId());
                    }
                    MetaStoreServerUtils.ColStatsObjWithSourceInfo colStatsWithPartInfo = new MetaStoreServerUtils.ColStatsObjWithSourceInfo(colStatsForPart, catName, dbName, tblName, partName);
                    colStatsWithPartInfoList.add(colStatsWithPartInfo);
                    if (colStatsAggregator == null) {
                        colStatsAggregator = ColumnStatsAggregatorFactory.getColumnStatsAggregator((ColumnStatisticsData._Fields)colStatsForPart.getStatsData().getSetField(), useDensityFunctionForNDVEstimation, ndvTuner);
                    }
                    ++partsFoundForColumn;
                    continue;
                }
                LOG.debug("Stats not found in CachedStore for: dbName={} tblName={} partName={} colName={}", new Object[]{dbName, tblName, partName, colName});
            }
            if (colStatsWithPartInfoList.size() > 0) {
                colStatsMap.put(colStatsAggregator, colStatsWithPartInfoList);
            }
            if (partsFoundForColumn < partsFound) {
                partsFound = partsFoundForColumn;
            }
            if (colStatsMap.size() >= 1) continue;
            LOG.debug("No stats data found for: dbName={} tblName= {} partNames= {} colNames= ", new Object[]{dbName, tblName, partNames, colNames});
            return new MergedColumnStatsForPartitions(this, new ArrayList<ColumnStatisticsObj>(), 0L);
        }
        List<ColumnStatisticsObj> colAggrStats = MetaStoreServerUtils.aggrPartitionStats(colStatsMap, partNames, partsFound == (long)partNames.size(), useDensityFunctionForNDVEstimation, ndvTuner);
        if (canUseEvents) {
            if (type == SharedCache.StatsType.ALL) {
                sharedCache.refreshAggregateStatsInCache(StringUtils.normalizeIdentifier((String)catName), StringUtils.normalizeIdentifier((String)dbName), StringUtils.normalizeIdentifier((String)tblName), new AggrStats(colAggrStats, partsFound), null, partNameToWriteId);
            } else if (type == SharedCache.StatsType.ALLBUTDEFAULT) {
                sharedCache.refreshAggregateStatsInCache(StringUtils.normalizeIdentifier((String)catName), StringUtils.normalizeIdentifier((String)dbName), StringUtils.normalizeIdentifier((String)tblName), null, new AggrStats(colAggrStats, partsFound), partNameToWriteId);
            }
        }
        return new MergedColumnStatsForPartitions(this, colAggrStats, partsFound);
    }

    @Override
    public long cleanupEvents() {
        return this.rawStore.cleanupEvents();
    }

    @Override
    public boolean addToken(String tokenIdentifier, String delegationToken) {
        return this.rawStore.addToken(tokenIdentifier, delegationToken);
    }

    @Override
    public boolean removeToken(String tokenIdentifier) {
        return this.rawStore.removeToken(tokenIdentifier);
    }

    @Override
    public String getToken(String tokenIdentifier) {
        return this.rawStore.getToken(tokenIdentifier);
    }

    @Override
    public List<String> getAllTokenIdentifiers() {
        return this.rawStore.getAllTokenIdentifiers();
    }

    @Override
    public int addMasterKey(String key) throws MetaException {
        return this.rawStore.addMasterKey(key);
    }

    @Override
    public void updateMasterKey(Integer seqNo, String key) throws NoSuchObjectException, MetaException {
        this.rawStore.updateMasterKey(seqNo, key);
    }

    @Override
    public boolean removeMasterKey(Integer keySeq) {
        return this.rawStore.removeMasterKey(keySeq);
    }

    @Override
    public String[] getMasterKeys() {
        return this.rawStore.getMasterKeys();
    }

    @Override
    public void verifySchema() throws MetaException {
        this.rawStore.verifySchema();
    }

    @Override
    public String getMetaStoreSchemaVersion() throws MetaException {
        return this.rawStore.getMetaStoreSchemaVersion();
    }

    @Override
    public void setMetaStoreSchemaVersion(String version, String comment) throws MetaException {
        this.rawStore.setMetaStoreSchemaVersion(version, comment);
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalDBGrantsAll(String principalName, PrincipalType principalType) {
        return this.rawStore.listPrincipalDBGrantsAll(principalName, principalType);
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalDCGrantsAll(String principalName, PrincipalType principalType) {
        return this.rawStore.listPrincipalDCGrantsAll(principalName, principalType);
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalTableGrantsAll(String principalName, PrincipalType principalType) {
        return this.rawStore.listPrincipalTableGrantsAll(principalName, principalType);
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalPartitionGrantsAll(String principalName, PrincipalType principalType) {
        return this.rawStore.listPrincipalPartitionGrantsAll(principalName, principalType);
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalTableColumnGrantsAll(String principalName, PrincipalType principalType) {
        return this.rawStore.listPrincipalTableColumnGrantsAll(principalName, principalType);
    }

    @Override
    public List<HiveObjectPrivilege> listPrincipalPartitionColumnGrantsAll(String principalName, PrincipalType principalType) {
        return this.rawStore.listPrincipalPartitionColumnGrantsAll(principalName, principalType);
    }

    @Override
    public List<HiveObjectPrivilege> listGlobalGrantsAll() {
        return this.rawStore.listGlobalGrantsAll();
    }

    @Override
    public List<HiveObjectPrivilege> listDBGrantsAll(String catName, String dbName) {
        return this.rawStore.listDBGrantsAll(catName, dbName);
    }

    @Override
    public List<HiveObjectPrivilege> listDCGrantsAll(String dcName) {
        return this.rawStore.listDCGrantsAll(dcName);
    }

    @Override
    public List<HiveObjectPrivilege> listPartitionColumnGrantsAll(String catName, String dbName, String tableName, String partitionName, String columnName) {
        return this.rawStore.listPartitionColumnGrantsAll(catName, dbName, tableName, partitionName, columnName);
    }

    @Override
    public List<HiveObjectPrivilege> listTableGrantsAll(String catName, String dbName, String tableName) {
        return this.rawStore.listTableGrantsAll(catName, dbName, tableName);
    }

    @Override
    public List<HiveObjectPrivilege> listPartitionGrantsAll(String catName, String dbName, String tableName, String partitionName) {
        return this.rawStore.listPartitionGrantsAll(catName, dbName, tableName, partitionName);
    }

    @Override
    public List<HiveObjectPrivilege> listTableColumnGrantsAll(String catName, String dbName, String tableName, String columnName) {
        return this.rawStore.listTableColumnGrantsAll(catName, dbName, tableName, columnName);
    }

    @Override
    public void createFunction(Function func) throws InvalidObjectException, MetaException {
        this.rawStore.createFunction(func);
    }

    @Override
    public void alterFunction(String catName, String dbName, String funcName, Function newFunction) throws InvalidObjectException, MetaException {
        this.rawStore.alterFunction(catName, dbName, funcName, newFunction);
    }

    @Override
    public void dropFunction(String catName, String dbName, String funcName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException {
        this.rawStore.dropFunction(catName, dbName, funcName);
    }

    @Override
    public Function getFunction(String catName, String dbName, String funcName) throws MetaException {
        return this.rawStore.getFunction(catName, dbName, funcName);
    }

    @Override
    public List<Function> getAllFunctions(String catName) throws MetaException {
        return this.rawStore.getAllFunctions(catName);
    }

    @Override
    public <T> List<T> getFunctionsRequest(String catName, String dbName, String pattern, boolean isReturnNames) throws MetaException {
        return this.rawStore.getFunctionsRequest(catName, dbName, pattern, isReturnNames);
    }

    @Override
    public NotificationEventResponse getNextNotification(NotificationEventRequest rqst) {
        return this.rawStore.getNextNotification(rqst);
    }

    @Override
    public void addNotificationEvent(NotificationEvent event) throws MetaException {
        this.rawStore.addNotificationEvent(event);
    }

    @Override
    public void cleanNotificationEvents(int olderThan) {
        this.rawStore.cleanNotificationEvents(olderThan);
    }

    @Override
    public CurrentNotificationEventId getCurrentNotificationEventId() {
        return this.rawStore.getCurrentNotificationEventId();
    }

    @Override
    public NotificationEventsCountResponse getNotificationEventsCount(NotificationEventsCountRequest rqst) {
        return this.rawStore.getNotificationEventsCount(rqst);
    }

    @Override
    public int getTableCount() throws MetaException {
        return this.rawStore.getTableCount();
    }

    @Override
    public int getPartitionCount() throws MetaException {
        return this.rawStore.getPartitionCount();
    }

    @Override
    public int getDatabaseCount() throws MetaException {
        return this.rawStore.getDatabaseCount();
    }

    @Override
    public List<SQLPrimaryKey> getPrimaryKeys(PrimaryKeysRequest request) throws MetaException {
        String tblName;
        String dbName;
        String catName = StringUtils.normalizeIdentifier((String)request.getCatName());
        if (this.shouldGetConstraintFromRawStore(catName, dbName = StringUtils.normalizeIdentifier((String)request.getDb_name()), tblName = StringUtils.normalizeIdentifier((String)request.getTbl_name()))) {
            return this.rawStore.getPrimaryKeys(request);
        }
        return sharedCache.listCachedPrimaryKeys(catName, dbName, tblName);
    }

    @Override
    public List<SQLForeignKey> getForeignKeys(ForeignKeysRequest request) throws MetaException {
        String parentTblName;
        if (StringUtils.isEmpty((CharSequence)request.getParent_db_name()) || StringUtils.isEmpty((CharSequence)request.getParent_tbl_name()) || StringUtils.isEmpty((CharSequence)request.getForeign_db_name()) || StringUtils.isEmpty((CharSequence)request.getForeign_tbl_name())) {
            return this.rawStore.getForeignKeys(request);
        }
        String catName = StringUtils.normalizeIdentifier((String)request.getCatName());
        String foreignDbName = StringUtils.normalizeIdentifier((String)request.getForeign_db_name());
        String foreignTblName = StringUtils.normalizeIdentifier((String)request.getForeign_tbl_name());
        String parentDbName = StringUtils.isEmpty((CharSequence)request.getParent_db_name()) ? "" : StringUtils.normalizeIdentifier((String)request.getParent_db_name());
        String string = parentTblName = StringUtils.isEmpty((CharSequence)request.getParent_tbl_name()) ? "" : StringUtils.normalizeIdentifier((String)request.getParent_tbl_name());
        if (this.shouldGetConstraintFromRawStore(catName, foreignDbName, foreignTblName)) {
            return this.rawStore.getForeignKeys(request);
        }
        return sharedCache.listCachedForeignKeys(catName, foreignDbName, foreignTblName, parentDbName, parentTblName);
    }

    @Override
    public List<SQLUniqueConstraint> getUniqueConstraints(UniqueConstraintsRequest request) throws MetaException {
        String tblName;
        String dbName;
        String catName = StringUtils.normalizeIdentifier((String)request.getCatName());
        if (this.shouldGetConstraintFromRawStore(catName, dbName = StringUtils.normalizeIdentifier((String)request.getDb_name()), tblName = StringUtils.normalizeIdentifier((String)request.getTbl_name()))) {
            return this.rawStore.getUniqueConstraints(request);
        }
        return sharedCache.listCachedUniqueConstraint(catName, dbName, tblName);
    }

    @Override
    public List<SQLNotNullConstraint> getNotNullConstraints(NotNullConstraintsRequest request) throws MetaException {
        String tblName;
        String dbName;
        String catName = StringUtils.normalizeIdentifier((String)request.getCatName());
        if (this.shouldGetConstraintFromRawStore(catName, dbName = StringUtils.normalizeIdentifier((String)request.getDb_name()), tblName = StringUtils.normalizeIdentifier((String)request.getTbl_name()))) {
            return this.rawStore.getNotNullConstraints(request);
        }
        return sharedCache.listCachedNotNullConstraints(catName, dbName, tblName);
    }

    @Override
    public List<SQLDefaultConstraint> getDefaultConstraints(DefaultConstraintsRequest request) throws MetaException {
        String tblName;
        String dbName;
        String catName = StringUtils.normalizeIdentifier((String)request.getCatName());
        if (this.shouldGetConstraintFromRawStore(catName, dbName = StringUtils.normalizeIdentifier((String)request.getDb_name()), tblName = StringUtils.normalizeIdentifier((String)request.getTbl_name()))) {
            return this.rawStore.getDefaultConstraints(request);
        }
        return sharedCache.listCachedDefaultConstraint(catName, dbName, tblName);
    }

    @Override
    public List<SQLCheckConstraint> getCheckConstraints(CheckConstraintsRequest request) throws MetaException {
        String tblName;
        String dbName;
        String catName = StringUtils.normalizeIdentifier((String)request.getCatName());
        if (this.shouldGetConstraintFromRawStore(catName, dbName = StringUtils.normalizeIdentifier((String)request.getDb_name()), tblName = StringUtils.normalizeIdentifier((String)request.getTbl_name()))) {
            return this.rawStore.getCheckConstraints(request);
        }
        return sharedCache.listCachedCheckConstraint(catName, dbName, tblName);
    }

    @Override
    public SQLAllTableConstraints getAllTableConstraints(AllTableConstraintsRequest request) throws MetaException, NoSuchObjectException {
        String tblName;
        String dbName;
        String catName = StringUtils.normalizeIdentifier((String)request.getCatName());
        if (this.shouldGetConstraintFromRawStore(catName, dbName = StringUtils.normalizeIdentifier((String)request.getDbName()), tblName = StringUtils.normalizeIdentifier((String)request.getTblName()))) {
            return this.rawStore.getAllTableConstraints(request);
        }
        return sharedCache.listCachedAllTableConstraints(catName, dbName, tblName);
    }

    @Override
    public SQLAllTableConstraints createTableWithConstraints(Table tbl, SQLAllTableConstraints constraints) throws InvalidObjectException, MetaException {
        String catName;
        constraints = this.rawStore.createTableWithConstraints(tbl, constraints);
        if (canUseEvents) {
            return constraints;
        }
        String dbName = StringUtils.normalizeIdentifier((String)tbl.getDbName());
        String tblName = StringUtils.normalizeIdentifier((String)tbl.getTableName());
        String string = catName = tbl.isSetCatName() ? StringUtils.normalizeIdentifier((String)tbl.getCatName()) : MetaStoreUtils.getDefaultCatalog((Configuration)this.conf);
        if (!CachedStore.shouldCacheTable(catName, dbName, tblName)) {
            return constraints;
        }
        sharedCache.addTableToCache(catName, dbName, tblName, tbl);
        sharedCache.addTableConstraintsToCache(catName, dbName, tblName, constraints);
        return constraints;
    }

    @Override
    public void dropConstraint(String catName, String dbName, String tableName, String constraintName, boolean missingOk) throws NoSuchObjectException {
        this.rawStore.dropConstraint(catName, dbName, tableName, constraintName, missingOk);
        if (!canUseEvents && CachedStore.shouldCacheTable(catName = StringUtils.normalizeIdentifier((String)catName), dbName = StringUtils.normalizeIdentifier((String)dbName), tableName = StringUtils.normalizeIdentifier((String)tableName))) {
            sharedCache.removeConstraintFromCache(catName, dbName, tableName, constraintName);
        }
    }

    @Override
    public List<SQLPrimaryKey> addPrimaryKeys(List<SQLPrimaryKey> pks) throws InvalidObjectException, MetaException {
        pks = this.rawStore.addPrimaryKeys(pks);
        if (!canUseEvents && pks != null && !pks.isEmpty()) {
            String tblName;
            String dbName;
            String catName = StringUtils.normalizeIdentifier((String)pks.get(0).getCatName());
            if (!CachedStore.shouldCacheTable(catName, dbName = StringUtils.normalizeIdentifier((String)pks.get(0).getTable_db()), tblName = StringUtils.normalizeIdentifier((String)pks.get(0).getTable_name()))) {
                return pks;
            }
            sharedCache.addPrimaryKeysToCache(catName, dbName, tblName, pks);
        }
        return pks;
    }

    @Override
    public List<SQLForeignKey> addForeignKeys(List<SQLForeignKey> fks) throws InvalidObjectException, MetaException {
        fks = this.rawStore.addForeignKeys(fks);
        if (!canUseEvents && fks != null && !fks.isEmpty()) {
            String tblName;
            String dbName;
            String catName = StringUtils.normalizeIdentifier((String)fks.get(0).getCatName());
            if (!CachedStore.shouldCacheTable(catName, dbName = StringUtils.normalizeIdentifier((String)fks.get(0).getFktable_db()), tblName = StringUtils.normalizeIdentifier((String)fks.get(0).getFktable_db()))) {
                return fks;
            }
            sharedCache.addForeignKeysToCache(catName, dbName, tblName, fks);
        }
        return fks;
    }

    @Override
    public List<SQLUniqueConstraint> addUniqueConstraints(List<SQLUniqueConstraint> uks) throws InvalidObjectException, MetaException {
        uks = this.rawStore.addUniqueConstraints(uks);
        if (!canUseEvents && uks != null && !uks.isEmpty()) {
            String tblName;
            String dbName;
            String catName = StringUtils.normalizeIdentifier((String)uks.get(0).getCatName());
            if (!CachedStore.shouldCacheTable(catName, dbName = StringUtils.normalizeIdentifier((String)uks.get(0).getTable_db()), tblName = StringUtils.normalizeIdentifier((String)uks.get(0).getTable_name()))) {
                return uks;
            }
            sharedCache.addUniqueConstraintsToCache(catName, dbName, tblName, uks);
        }
        return uks;
    }

    @Override
    public List<SQLNotNullConstraint> addNotNullConstraints(List<SQLNotNullConstraint> nns) throws InvalidObjectException, MetaException {
        nns = this.rawStore.addNotNullConstraints(nns);
        if (!canUseEvents && CollectionUtils.isNotEmpty(nns)) {
            String tblName;
            String dbName;
            String catName = StringUtils.normalizeIdentifier((String)nns.get(0).getCatName());
            if (!CachedStore.shouldCacheTable(catName, dbName = StringUtils.normalizeIdentifier((String)nns.get(0).getTable_db()), tblName = StringUtils.normalizeIdentifier((String)nns.get(0).getTable_name()))) {
                return nns;
            }
            sharedCache.addNotNullConstraintsToCache(catName, dbName, tblName, nns);
        }
        return nns;
    }

    @Override
    public List<SQLDefaultConstraint> addDefaultConstraints(List<SQLDefaultConstraint> dcs) throws InvalidObjectException, MetaException {
        dcs = this.rawStore.addDefaultConstraints(dcs);
        if (!canUseEvents && CollectionUtils.isNotEmpty(dcs)) {
            String tblName;
            String dbName;
            String catName = StringUtils.normalizeIdentifier((String)dcs.get(0).getCatName());
            if (!CachedStore.shouldCacheTable(catName, dbName = StringUtils.normalizeIdentifier((String)dcs.get(0).getTable_db()), tblName = StringUtils.normalizeIdentifier((String)dcs.get(0).getTable_name()))) {
                return dcs;
            }
            sharedCache.addDefaultConstraintsToCache(catName, dbName, tblName, dcs);
        }
        return dcs;
    }

    @Override
    public List<SQLCheckConstraint> addCheckConstraints(List<SQLCheckConstraint> ccs) throws InvalidObjectException, MetaException {
        ccs = this.rawStore.addCheckConstraints(ccs);
        if (!canUseEvents && CollectionUtils.isNotEmpty(ccs)) {
            String tblName;
            String dbName;
            String catName = StringUtils.normalizeIdentifier((String)ccs.get(0).getCatName());
            if (!CachedStore.shouldCacheTable(catName, dbName = StringUtils.normalizeIdentifier((String)ccs.get(0).getTable_db()), tblName = StringUtils.normalizeIdentifier((String)ccs.get(0).getTable_name()))) {
                return ccs;
            }
            sharedCache.addCheckConstraintsToCache(catName, dbName, tblName, ccs);
        }
        return ccs;
    }

    @Override
    public void createISchema(ISchema schema) throws AlreadyExistsException, NoSuchObjectException, MetaException {
        this.rawStore.createISchema(schema);
    }

    @Override
    public List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> getPartitionColStatsForDatabase(String catName, String dbName) throws MetaException, NoSuchObjectException {
        return this.rawStore.getPartitionColStatsForDatabase(catName, dbName);
    }

    @Override
    public void alterISchema(ISchemaName schemaName, ISchema newSchema) throws NoSuchObjectException, MetaException {
        this.rawStore.alterISchema(schemaName, newSchema);
    }

    @Override
    public ISchema getISchema(ISchemaName schemaName) throws MetaException {
        return this.rawStore.getISchema(schemaName);
    }

    @Override
    public void dropISchema(ISchemaName schemaName) throws NoSuchObjectException, MetaException {
        this.rawStore.dropISchema(schemaName);
    }

    @Override
    public void addSchemaVersion(SchemaVersion schemaVersion) throws AlreadyExistsException, InvalidObjectException, NoSuchObjectException, MetaException {
        this.rawStore.addSchemaVersion(schemaVersion);
    }

    @Override
    public void alterSchemaVersion(SchemaVersionDescriptor version, SchemaVersion newVersion) throws NoSuchObjectException, MetaException {
        this.rawStore.alterSchemaVersion(version, newVersion);
    }

    @Override
    public SchemaVersion getSchemaVersion(SchemaVersionDescriptor version) throws MetaException {
        return this.rawStore.getSchemaVersion(version);
    }

    @Override
    public SchemaVersion getLatestSchemaVersion(ISchemaName schemaName) throws MetaException {
        return this.rawStore.getLatestSchemaVersion(schemaName);
    }

    @Override
    public List<SchemaVersion> getAllSchemaVersion(ISchemaName schemaName) throws MetaException {
        return this.rawStore.getAllSchemaVersion(schemaName);
    }

    @Override
    public List<SchemaVersion> getSchemaVersionsByColumns(String colName, String colNamespace, String type) throws MetaException {
        return this.rawStore.getSchemaVersionsByColumns(colName, colNamespace, type);
    }

    @Override
    public void dropSchemaVersion(SchemaVersionDescriptor version) throws NoSuchObjectException, MetaException {
        this.rawStore.dropSchemaVersion(version);
    }

    @Override
    public SerDeInfo getSerDeInfo(String serDeName) throws NoSuchObjectException, MetaException {
        return this.rawStore.getSerDeInfo(serDeName);
    }

    @Override
    public void addSerde(SerDeInfo serde) throws AlreadyExistsException, MetaException {
        this.rawStore.addSerde(serde);
    }

    public RawStore getRawStore() {
        return this.rawStore;
    }

    @VisibleForTesting
    public void setRawStore(RawStore rawStore) {
        this.rawStore = rawStore;
    }

    @Override
    public String getMetastoreDbUuid() throws MetaException {
        return this.rawStore.getMetastoreDbUuid();
    }

    @Override
    public void createResourcePlan(WMResourcePlan resourcePlan, String copyFrom, int defaultPoolSize) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException {
        this.rawStore.createResourcePlan(resourcePlan, copyFrom, defaultPoolSize);
    }

    @Override
    public WMFullResourcePlan getResourcePlan(String name, String ns) throws NoSuchObjectException, MetaException {
        return this.rawStore.getResourcePlan(name, ns);
    }

    @Override
    public List<WMResourcePlan> getAllResourcePlans(String ns) throws MetaException {
        return this.rawStore.getAllResourcePlans(ns);
    }

    @Override
    public WMFullResourcePlan alterResourcePlan(String name, String ns, WMNullableResourcePlan resourcePlan, boolean canActivateDisabled, boolean canDeactivate, boolean isReplace) throws AlreadyExistsException, NoSuchObjectException, InvalidOperationException, MetaException {
        return this.rawStore.alterResourcePlan(name, ns, resourcePlan, canActivateDisabled, canDeactivate, isReplace);
    }

    @Override
    public WMFullResourcePlan getActiveResourcePlan(String ns) throws MetaException {
        return this.rawStore.getActiveResourcePlan(ns);
    }

    @Override
    public WMValidateResourcePlanResponse validateResourcePlan(String name, String ns) throws NoSuchObjectException, InvalidObjectException, MetaException {
        return this.rawStore.validateResourcePlan(name, ns);
    }

    @Override
    public void dropResourcePlan(String name, String ns) throws NoSuchObjectException, MetaException {
        this.rawStore.dropResourcePlan(name, ns);
    }

    @Override
    public void createWMTrigger(WMTrigger trigger) throws AlreadyExistsException, MetaException, NoSuchObjectException, InvalidOperationException {
        this.rawStore.createWMTrigger(trigger);
    }

    @Override
    public void alterWMTrigger(WMTrigger trigger) throws NoSuchObjectException, InvalidOperationException, MetaException {
        this.rawStore.alterWMTrigger(trigger);
    }

    @Override
    public void dropWMTrigger(String resourcePlanName, String triggerName, String ns) throws NoSuchObjectException, InvalidOperationException, MetaException {
        this.rawStore.dropWMTrigger(resourcePlanName, triggerName, ns);
    }

    @Override
    public List<WMTrigger> getTriggersForResourcePlan(String resourcePlanName, String ns) throws NoSuchObjectException, MetaException {
        return this.rawStore.getTriggersForResourcePlan(resourcePlanName, ns);
    }

    @Override
    public void createPool(WMPool pool) throws AlreadyExistsException, NoSuchObjectException, InvalidOperationException, MetaException {
        this.rawStore.createPool(pool);
    }

    @Override
    public void alterPool(WMNullablePool pool, String poolPath) throws AlreadyExistsException, NoSuchObjectException, InvalidOperationException, MetaException {
        this.rawStore.alterPool(pool, poolPath);
    }

    @Override
    public void dropWMPool(String resourcePlanName, String poolPath, String ns) throws NoSuchObjectException, InvalidOperationException, MetaException {
        this.rawStore.dropWMPool(resourcePlanName, poolPath, ns);
    }

    @Override
    public void createOrUpdateWMMapping(WMMapping mapping, boolean update) throws AlreadyExistsException, NoSuchObjectException, InvalidOperationException, MetaException {
        this.rawStore.createOrUpdateWMMapping(mapping, update);
    }

    @Override
    public void dropWMMapping(WMMapping mapping) throws NoSuchObjectException, InvalidOperationException, MetaException {
        this.rawStore.dropWMMapping(mapping);
    }

    @Override
    public void createWMTriggerToPoolMapping(String resourcePlanName, String triggerName, String poolPath, String ns) throws AlreadyExistsException, NoSuchObjectException, InvalidOperationException, MetaException {
        this.rawStore.createWMTriggerToPoolMapping(resourcePlanName, triggerName, poolPath, ns);
    }

    @Override
    public void dropWMTriggerToPoolMapping(String resourcePlanName, String triggerName, String poolPath, String ns) throws NoSuchObjectException, InvalidOperationException, MetaException {
        this.rawStore.dropWMTriggerToPoolMapping(resourcePlanName, triggerName, poolPath, ns);
    }

    public long getCacheUpdateCount() {
        return sharedCache.getUpdateCount();
    }

    @Override
    public void cleanWriteNotificationEvents(int olderThan) {
        this.rawStore.cleanWriteNotificationEvents(olderThan);
    }

    @Override
    public List<WriteEventInfo> getAllWriteEventInfo(long txnId, String dbName, String tableName) throws MetaException {
        return this.rawStore.getAllWriteEventInfo(txnId, dbName, tableName);
    }

    static boolean isNotInBlackList(String catName, String dbName, String tblName) {
        String str = TableName.getQualified((String)catName, (String)dbName, (String)tblName);
        for (Pattern pattern : blacklistPatterns) {
            LOG.debug("Trying to match: {} against blacklist pattern: {}", (Object)str, (Object)pattern);
            Matcher matcher = pattern.matcher(str);
            if (!matcher.matches()) continue;
            LOG.debug("Found matcher group: {} at start index: {} and end index: {}", new Object[]{matcher.group(), matcher.start(), matcher.end()});
            return false;
        }
        return true;
    }

    private static boolean isInWhitelist(String catName, String dbName, String tblName) {
        String str = TableName.getQualified((String)catName, (String)dbName, (String)tblName);
        for (Pattern pattern : whitelistPatterns) {
            LOG.debug("Trying to match: {} against whitelist pattern: {}", (Object)str, (Object)pattern);
            Matcher matcher = pattern.matcher(str);
            if (!matcher.matches()) continue;
            LOG.debug("Found matcher group: {} at start index: {} and end index: {}", new Object[]{matcher.group(), matcher.start(), matcher.end()});
            return true;
        }
        return false;
    }

    static void setWhitelistPattern(List<Pattern> patterns) {
        whitelistPatterns = patterns;
    }

    static void setBlacklistPattern(List<Pattern> patterns) {
        blacklistPatterns = patterns;
    }

    static boolean shouldCacheTable(String catName, String dbName, String tblName) {
        if (!CachedStore.isNotInBlackList(catName, dbName, tblName)) {
            LOG.debug("{}.{} is in blacklist, skipping", (Object)dbName, (Object)tblName);
            return false;
        }
        if (!CachedStore.isInWhitelist(catName, dbName, tblName)) {
            LOG.debug("{}.{} is not in whitelist, skipping", (Object)dbName, (Object)tblName);
            return false;
        }
        return true;
    }

    static List<Pattern> createPatterns(String configStr) {
        List<String> patternStrs = Arrays.asList(configStr.split(","));
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String str : patternStrs) {
            patterns.add(Pattern.compile(str));
        }
        return patterns;
    }

    static boolean isBlacklistWhitelistEmpty(Configuration conf) {
        return MetastoreConf.getAsString((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_CACHED_OBJECTS_WHITELIST).equals(".*") && MetastoreConf.getAsString((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_CACHED_OBJECTS_BLACKLIST).isEmpty();
    }

    @VisibleForTesting
    void resetCatalogCache() {
        sharedCache.resetCatalogCache();
        CachedStore.setCachePrewarmedState(false);
    }

    @Override
    public void addRuntimeStat(RuntimeStat stat) throws MetaException {
        this.rawStore.addRuntimeStat(stat);
    }

    @Override
    public List<RuntimeStat> getRuntimeStats(int maxEntries, int maxCreateTime) throws MetaException {
        return this.rawStore.getRuntimeStats(maxEntries, maxCreateTime);
    }

    @Override
    public int deleteRuntimeStats(int maxRetainSecs) throws MetaException {
        return this.rawStore.deleteRuntimeStats(maxRetainSecs);
    }

    @Override
    public List<TableName> getTableNamesWithStats() throws MetaException, NoSuchObjectException {
        return this.rawStore.getTableNamesWithStats();
    }

    @Override
    public List<TableName> getAllTableNamesForStats() throws MetaException, NoSuchObjectException {
        return this.rawStore.getAllTableNamesForStats();
    }

    @Override
    public Map<String, List<String>> getPartitionColsWithStats(String catName, String dbName, String tableName) throws MetaException, NoSuchObjectException {
        return this.rawStore.getPartitionColsWithStats(catName, dbName, tableName);
    }

    @Override
    public List<String> isPartOfMaterializedView(String catName, String dbName, String tblName) {
        return this.rawStore.isPartOfMaterializedView(catName, dbName, tblName);
    }

    @Override
    public ScheduledQueryPollResponse scheduledQueryPoll(ScheduledQueryPollRequest request) throws MetaException {
        return this.rawStore.scheduledQueryPoll(request);
    }

    @Override
    public void scheduledQueryMaintenance(ScheduledQueryMaintenanceRequest request) throws MetaException, NoSuchObjectException, AlreadyExistsException, InvalidInputException {
        this.rawStore.scheduledQueryMaintenance(request);
    }

    @Override
    public void scheduledQueryProgress(ScheduledQueryProgressInfo info) throws MetaException, NoSuchObjectException, InvalidOperationException {
        this.rawStore.scheduledQueryProgress(info);
    }

    @Override
    public void addReplicationMetrics(ReplicationMetricList replicationMetricList) {
        this.rawStore.addReplicationMetrics(replicationMetricList);
    }

    @Override
    public ReplicationMetricList getReplicationMetrics(GetReplicationMetricsRequest replicationMetricsRequest) {
        return this.rawStore.getReplicationMetrics(replicationMetricsRequest);
    }

    @Override
    public int deleteReplicationMetrics(int maxRetainSecs) {
        return this.rawStore.deleteReplicationMetrics(maxRetainSecs);
    }

    @Override
    public ScheduledQuery getScheduledQuery(ScheduledQueryKey scheduleKey) throws MetaException, NoSuchObjectException {
        return this.rawStore.getScheduledQuery(scheduleKey);
    }

    @Override
    public int deleteScheduledExecutions(int maxRetainSecs) {
        return this.rawStore.deleteScheduledExecutions(maxRetainSecs);
    }

    @Override
    public int markScheduledExecutionsTimedOut(int timeoutSecs) throws InvalidOperationException, MetaException {
        return this.rawStore.markScheduledExecutionsTimedOut(timeoutSecs);
    }

    @Override
    public void deleteAllPartitionColumnStatistics(TableName tn, String w) {
        this.rawStore.deleteAllPartitionColumnStatistics(tn, w);
    }

    @Override
    public void createOrUpdateStoredProcedure(StoredProcedure proc) throws NoSuchObjectException, MetaException {
        this.rawStore.createOrUpdateStoredProcedure(proc);
    }

    @Override
    public StoredProcedure getStoredProcedure(String catName, String db, String name) throws MetaException {
        return this.rawStore.getStoredProcedure(catName, db, name);
    }

    @Override
    public void dropStoredProcedure(String catName, String dbName, String funcName) throws MetaException {
        this.rawStore.dropStoredProcedure(catName, dbName, funcName);
    }

    @Override
    public List<String> getAllStoredProcedures(ListStoredProcedureRequest request) {
        return this.rawStore.getAllStoredProcedures(request);
    }

    @Override
    public void addPackage(AddPackageRequest request) throws MetaException, NoSuchObjectException {
        this.rawStore.addPackage(request);
    }

    @Override
    public Package findPackage(GetPackageRequest request) {
        return this.rawStore.findPackage(request);
    }

    @Override
    public List<String> listPackages(ListPackageRequest request) {
        return this.rawStore.listPackages(request);
    }

    @Override
    public void dropPackage(DropPackageRequest request) {
        this.rawStore.dropPackage(request);
    }

    @Override
    public MTable ensureGetMTable(String catName, String dbName, String tblName) throws NoSuchObjectException {
        return this.rawStore.ensureGetMTable(catName, dbName, tblName);
    }

    private boolean shouldGetConstraintFromRawStore(String catName, String dbName, String tblName) {
        return !CachedStore.shouldCacheTable(catName, dbName, tblName) || canUseEvents && this.rawStore.isActiveTransaction() || !sharedCache.isTableConstraintValid(catName, dbName, tblName);
    }

    static {
        cacheRefreshPeriodMS = DEFAULT_CACHE_REFRESH_PERIOD = 100L;
        MAX_RETRIES = 10;
        isCachePrewarmed = new AtomicBoolean(false);
        isCachedAllMetadata = new AtomicBoolean(false);
        tblsPendingPrewarm = new TablesPendingPrewarm();
        lock = "L";
        sharedCacheInited = false;
        sharedCache = new SharedCache();
        canUseEvents = false;
        LOG = LoggerFactory.getLogger((String)CachedStore.class.getName());
    }

    static class TablesPendingPrewarm {
        private Stack<String> tableNames = new Stack();

        TablesPendingPrewarm() {
        }

        private synchronized void addTableNamesForPrewarming(List<String> tblNames) {
            this.tableNames.clear();
            if (tblNames != null) {
                this.tableNames.addAll(tblNames);
            }
        }

        private synchronized boolean hasMoreTablesToPrewarm() {
            return !this.tableNames.empty();
        }

        private synchronized String getNextTableNameToPrewarm() {
            return this.tableNames.pop();
        }

        private synchronized void prioritizeTableForPrewarm(String tblName) {
            if (this.tableNames.remove(tblName)) {
                this.tableNames.push(tblName);
            }
        }
    }

    static class CacheUpdateMasterWork
    implements Runnable {
        private boolean shouldRunPrewarm = true;
        private final RawStore rawStore;

        CacheUpdateMasterWork(Configuration conf, boolean shouldRunPrewarm) {
            this.shouldRunPrewarm = shouldRunPrewarm;
            String rawStoreClassName = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CACHED_RAW_STORE_IMPL, (String)ObjectStore.class.getName());
            try {
                this.rawStore = (RawStore)JavaUtils.getClass((String)rawStoreClassName, RawStore.class).newInstance();
                this.rawStore.setConf(conf);
            }
            catch (IllegalAccessException | InstantiationException | MetaException e) {
                throw new RuntimeException("Cannot instantiate " + rawStoreClassName, e);
            }
        }

        @Override
        public void run() {
            if (!this.shouldRunPrewarm) {
                if (canUseEvents) {
                    try {
                        CachedStore.triggerUpdateUsingEvent(this.rawStore);
                    }
                    catch (Exception e) {
                        LOG.error("failed to update cache using events ", (Throwable)e);
                    }
                } else {
                    try {
                        this.update();
                    }
                    catch (Exception e) {
                        LOG.error("periodical refresh fail ", (Throwable)e);
                    }
                }
            } else {
                try {
                    CachedStore.triggerPreWarm(this.rawStore);
                    this.shouldRunPrewarm = false;
                }
                catch (Exception e) {
                    LOG.error("Prewarm failure", (Throwable)e);
                    return;
                }
            }
        }

        void update() {
            Deadline.registerIfNot(1000000L);
            LOG.debug("CachedStore: updating cached objects. Shared cache has been update {} times so far.", (Object)sharedCache.getUpdateCount());
            try {
                for (String catName : CachedStore.catalogsToCache(this.rawStore)) {
                    List<String> dbNames = this.rawStore.getAllDatabases(catName);
                    this.updateDatabases(this.rawStore, catName, dbNames);
                    for (String dbName : dbNames) {
                        List<String> tblNames;
                        this.updateTables(this.rawStore, catName, dbName);
                        try {
                            tblNames = this.rawStore.getAllTables(catName, dbName);
                        }
                        catch (MetaException e) {
                            LOG.debug(ExceptionUtils.getStackTrace((Throwable)e));
                            continue;
                        }
                        for (String tblName : tblNames) {
                            if (!CachedStore.shouldCacheTable(catName, dbName, tblName)) continue;
                            this.updateTableColStats(this.rawStore, catName, dbName, tblName);
                            this.updateTablePartitions(this.rawStore, catName, dbName, tblName);
                            this.updateTablePartitionColStats(this.rawStore, catName, dbName, tblName);
                            CacheUpdateMasterWork.updateTableAggregatePartitionColStats(this.rawStore, catName, dbName, tblName);
                            this.updateAllTableConstraints(this.rawStore, catName, dbName, tblName);
                        }
                    }
                }
                sharedCache.incrementUpdateCount();
                LOG.debug("CachedStore: updated cached objects. Shared cache update count is: {}", (Object)sharedCache.getUpdateCount());
            }
            catch (MetaException e) {
                LOG.error("Updating CachedStore: error happen when refresh; skipping this iteration", (Throwable)e);
            }
        }

        private void updateDatabases(RawStore rawStore, String catName, List<String> dbNames) {
            LOG.debug("CachedStore: updating cached database objects for catalog: {}", (Object)catName);
            boolean success = false;
            int maxTries = MAX_RETRIES;
            while (!success && maxTries-- > 0) {
                ArrayList<Database> databases = new ArrayList<Database>();
                for (String dbName : dbNames) {
                    try {
                        Database db = rawStore.getDatabase(catName, dbName);
                        databases.add(db);
                    }
                    catch (NoSuchObjectException e) {
                        LOG.info("Updating CachedStore: database: " + catName + "." + dbName + " does not exist.", (Throwable)e);
                    }
                }
                success = sharedCache.refreshDatabasesInCache(databases);
                LOG.debug("CachedStore: updated cached database objects for catalog: {}", (Object)catName);
            }
        }

        private void updateTables(RawStore rawStore, String catName, String dbName) {
            LOG.debug("CachedStore: updating cached table objects for catalog: {}, database: {}", (Object)catName, (Object)dbName);
            boolean success = false;
            int maxTries = MAX_RETRIES;
            while (!success && maxTries-- > 0) {
                ArrayList<Table> tables = new ArrayList<Table>();
                try {
                    List<String> tblNames = rawStore.getAllTables(catName, dbName);
                    for (String tblName : tblNames) {
                        if (!CachedStore.shouldCacheTable(catName, dbName, tblName)) continue;
                        Table table = rawStore.getTable(StringUtils.normalizeIdentifier((String)catName), StringUtils.normalizeIdentifier((String)dbName), StringUtils.normalizeIdentifier((String)tblName));
                        tables.add(table);
                    }
                    success = sharedCache.refreshTablesInCache(catName, dbName, tables);
                    LOG.debug("CachedStore: updated cached table objects for catalog: {}, database: {}", (Object)catName, (Object)dbName);
                }
                catch (MetaException e) {
                    LOG.debug("Unable to refresh cached tables for database: " + dbName, (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateTableColStats(RawStore rawStore, String catName, String dbName, String tblName) {
            LOG.debug("CachedStore: updating cached table col stats objects for catalog: {}, database: {}", (Object)catName, (Object)dbName);
            boolean committed = false;
            rawStore.openTransaction();
            try {
                Table table = rawStore.getTable(catName, dbName, tblName);
                if (table != null && !table.isSetPartitionKeys()) {
                    List colNames = MetaStoreUtils.getColumnNamesForTable((Table)table);
                    Deadline.startTimer("getTableColumnStatistics");
                    ColumnStatistics tableColStats = rawStore.getTableColumnStatistics(catName, dbName, tblName, colNames, "hive");
                    Deadline.stopTimer();
                    if (tableColStats != null) {
                        sharedCache.refreshTableColStatsInCache(StringUtils.normalizeIdentifier((String)catName), StringUtils.normalizeIdentifier((String)dbName), StringUtils.normalizeIdentifier((String)tblName), tableColStats.getStatsObj());
                    }
                }
                committed = rawStore.commitTransaction();
                LOG.debug("CachedStore: updated cached table col stats objects for catalog: {}, database: {}", (Object)catName, (Object)dbName);
            }
            catch (MetaException | NoSuchObjectException e) {
                LOG.info("Unable to refresh table column stats for table: " + tblName, e);
            }
            finally {
                if (!committed) {
                    sharedCache.removeAllTableColStatsFromCache(catName, dbName, tblName);
                    rawStore.rollbackTransaction();
                }
            }
        }

        private void updateAllTableConstraints(RawStore rawStore, String catName, String dbName, String tblName) {
            catName = StringUtils.normalizeIdentifier((String)catName);
            dbName = StringUtils.normalizeIdentifier((String)dbName);
            tblName = StringUtils.normalizeIdentifier((String)tblName);
            LOG.debug("CachedStore: updating cached table constraints objects for catalog: {}, database: {}, table: {}", new Object[]{catName, dbName, tblName});
            SQLAllTableConstraints constraints = null;
            try {
                Deadline.startTimer("getAllTableConstraints");
                constraints = rawStore.getAllTableConstraints(new AllTableConstraintsRequest(catName, dbName, tblName));
                Deadline.stopTimer();
            }
            catch (MetaException | NoSuchObjectException e) {
                LOG.info("Updating CachedStore: unable to update table constraints of catalog: " + catName + ", database: " + dbName + ", table: " + tblName, e);
            }
            if (constraints != null) {
                sharedCache.refreshAllTableConstraintsInCache(catName, dbName, tblName, constraints);
                LOG.debug("CachedStore: updated cached table constraints objects for catalog: {}, database: {}, table: {}", new Object[]{catName, dbName, tblName});
            }
        }

        private void updateTablePartitions(RawStore rawStore, String catName, String dbName, String tblName) {
            LOG.debug("CachedStore: updating cached partition objects for catalog: {}, database: {}, table: {}", new Object[]{catName, dbName, tblName});
            try {
                Deadline.startTimer("getPartitions");
                List<Partition> partitions = rawStore.getPartitions(catName, dbName, tblName, GetPartitionsArgs.getAllPartitions());
                Deadline.stopTimer();
                sharedCache.refreshPartitionsInCache(StringUtils.normalizeIdentifier((String)catName), StringUtils.normalizeIdentifier((String)dbName), StringUtils.normalizeIdentifier((String)tblName), partitions);
                LOG.debug("CachedStore: updated cached partition objects for catalog: {}, database: {}, table: {}", new Object[]{catName, dbName, tblName});
            }
            catch (MetaException | NoSuchObjectException e) {
                LOG.info("Updating CachedStore: unable to read partitions of table: " + tblName, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateTablePartitionColStats(RawStore rawStore, String catName, String dbName, String tblName) {
            LOG.debug("CachedStore: updating cached partition col stats objects for catalog: {}, database: {}, table: {}", new Object[]{catName, dbName, tblName});
            boolean committed = false;
            rawStore.openTransaction();
            try {
                Table table = rawStore.getTable(catName, dbName, tblName);
                if (table != null) {
                    List colNames = MetaStoreUtils.getColumnNamesForTable((Table)table);
                    List<String> partNames = rawStore.listPartitionNames(catName, dbName, tblName, (short)-1);
                    Deadline.startTimer("getPartitionColumnStatistics");
                    List<ColumnStatistics> partitionColStats = rawStore.getPartitionColumnStatistics(catName, dbName, tblName, partNames, colNames, "hive");
                    Deadline.stopTimer();
                    sharedCache.refreshPartitionColStatsInCache(catName, dbName, tblName, partitionColStats);
                }
                committed = rawStore.commitTransaction();
                LOG.debug("CachedStore: updated cached partition col stats objects for catalog: {}, database: {}, table: {}", new Object[]{catName, dbName, tblName});
            }
            catch (MetaException | NoSuchObjectException e) {
                LOG.info("Updating CachedStore: unable to read partitions of table: " + tblName, e);
            }
            finally {
                if (!committed) {
                    sharedCache.removeAllPartitionColStatsFromCache(catName, dbName, tblName);
                    rawStore.rollbackTransaction();
                }
            }
        }

        private static void updateTableAggregatePartitionColStats(RawStore rawStore, String catName, String dbName, String tblName) {
            LOG.debug("CachedStore: updating cached aggregate partition col stats objects for catalog: {}, database: {}, table: {}", new Object[]{catName, dbName, tblName});
            try {
                Table table = rawStore.getTable(catName, dbName, tblName);
                if (table == null) {
                    return;
                }
                List<String> partNames = rawStore.listPartitionNames(catName, dbName, tblName, (short)-1);
                List colNames = MetaStoreUtils.getColumnNamesForTable((Table)table);
                if (partNames != null && partNames.size() > 0) {
                    Deadline.startTimer("getAggregateStatsForAllPartitions");
                    AggrStats aggrStatsAllPartitions = rawStore.get_aggr_stats_for(catName, dbName, tblName, partNames, colNames, "hive");
                    Deadline.stopTimer();
                    List partKeys = table.getPartitionKeys();
                    String defaultPartitionValue = MetastoreConf.getVar((Configuration)rawStore.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DEFAULTPARTITIONNAME);
                    ArrayList<String> partCols = new ArrayList<String>();
                    ArrayList<String> partVals = new ArrayList<String>();
                    for (FieldSchema fs : partKeys) {
                        partCols.add(fs.getName());
                        partVals.add(defaultPartitionValue);
                    }
                    String defaultPartitionName = FileUtils.makePartName(partCols, partVals);
                    partNames.remove(defaultPartitionName);
                    Deadline.startTimer("getAggregateStatsForAllPartitionsExceptDefault");
                    AggrStats aggrStatsAllButDefaultPartition = rawStore.get_aggr_stats_for(catName, dbName, tblName, partNames, colNames, "hive");
                    Deadline.stopTimer();
                    sharedCache.refreshAggregateStatsInCache(StringUtils.normalizeIdentifier((String)catName), StringUtils.normalizeIdentifier((String)dbName), StringUtils.normalizeIdentifier((String)tblName), aggrStatsAllPartitions, aggrStatsAllButDefaultPartition, null);
                    LOG.debug("CachedStore: updated cached aggregate partition col stats objects for catalog: {}, database: {}, table: {}", new Object[]{catName, dbName, tblName});
                }
            }
            catch (MetaException | NoSuchObjectException e) {
                LOG.info("Updating CachedStore: unable to read aggregate column stats of table: " + tblName, e);
            }
        }
    }

    class MergedColumnStatsForPartitions {
        List<ColumnStatisticsObj> colStats = new ArrayList<ColumnStatisticsObj>();
        long partsFound;

        MergedColumnStatsForPartitions(CachedStore this$0, List<ColumnStatisticsObj> colStats, long partsFound) {
            this.colStats = colStats;
            this.partsFound = partsFound;
        }

        List<ColumnStatisticsObj> getColStats() {
            return this.colStats;
        }

        long getPartsFound() {
            return this.partsFound;
        }
    }
}

