/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.net.URI;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class URIStringConverter
implements TypeConverter<URI, String> {
    private static final long serialVersionUID = -3784990025093845546L;

    @Override
    public URI toMemberType(String str) {
        if (StringUtils.isWhitespace(str)) {
            return null;
        }
        try {
            return URI.create(str.trim());
        }
        catch (IllegalArgumentException iae) {
            throw new NucleusDataStoreException(Localiser.msg("016002", str, URI.class.getName()), iae);
        }
    }

    @Override
    public String toDatastoreType(URI uri) {
        return uri != null ? uri.toString() : null;
    }
}

