/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Properties;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.BuiltInConnectionProperty;
import org.apache.calcite.avatica.ConnectionConfig;
import org.apache.calcite.avatica.ConnectionProperty;
import org.apache.calcite.avatica.DriverVersion;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.UnregisteredDriver;
import org.apache.calcite.avatica.remote.AvaticaHttpClient;
import org.apache.calcite.avatica.remote.AvaticaHttpClientFactory;
import org.apache.calcite.avatica.remote.AvaticaRemoteConnectionProperty;
import org.apache.calcite.avatica.remote.KerberosConnection;
import org.apache.calcite.avatica.remote.MockJsonService;
import org.apache.calcite.avatica.remote.ProtobufTranslationImpl;
import org.apache.calcite.avatica.remote.RemoteMeta;
import org.apache.calcite.avatica.remote.RemoteProtobufService;
import org.apache.calcite.avatica.remote.RemoteService;
import org.apache.calcite.avatica.remote.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Driver
extends UnregisteredDriver {
    private static final Logger LOG = LoggerFactory.getLogger(Driver.class);
    public static final String CONNECT_STRING_PREFIX = "jdbc:avatica:remote:";

    @Override
    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    @Override
    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(Driver.class, "org-apache-calcite-jdbc.properties", "Avatica Remote JDBC Driver", "unknown version", "Avatica", "unknown version");
    }

    @Override
    protected Collection<ConnectionProperty> getConnectionProperties() {
        ArrayList<ConnectionProperty> list = new ArrayList<ConnectionProperty>();
        Collections.addAll(list, BuiltInConnectionProperty.values());
        Collections.addAll(list, AvaticaRemoteConnectionProperty.values());
        return list;
    }

    @Override
    public Meta createMeta(AvaticaConnection connection) {
        ConnectionConfig config = connection.config();
        KerberosConnection kerberosUtil = this.createKerberosUtility(config);
        if (null != kerberosUtil) {
            kerberosUtil.login();
            connection.setKerberosConnection(kerberosUtil);
        }
        Service service = this.createService(connection, config);
        connection.setService(service);
        return new RemoteMeta(connection, service);
    }

    KerberosConnection createKerberosUtility(ConnectionConfig config) {
        String principal = config.kerberosPrincipal();
        if (null != principal) {
            return new KerberosConnection(principal, config.kerberosKeytab());
        }
        return null;
    }

    Service createService(AvaticaConnection connection, ConnectionConfig config) {
        Service service;
        Service.Factory metaFactory = config.factory();
        if (metaFactory != null) {
            service = metaFactory.create(connection);
        } else if (config.url() != null) {
            AvaticaHttpClient httpClient = this.getHttpClient(connection, config);
            Serialization serializationType = this.getSerialization(config);
            LOG.debug("Instantiating {} service", (Object)serializationType);
            switch (serializationType) {
                case JSON: {
                    service = new RemoteService(httpClient);
                    break;
                }
                case PROTOBUF: {
                    service = new RemoteProtobufService(httpClient, new ProtobufTranslationImpl());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled serialization type: " + (Object)((Object)serializationType));
                }
            }
        } else {
            service = new MockJsonService(Collections.emptyMap());
        }
        return service;
    }

    AvaticaHttpClient getHttpClient(AvaticaConnection connection, ConnectionConfig config) {
        URL url;
        String urlStr = config.useClientSideLb() ? config.getLBStrategy().getLbURL(config) : config.url();
        try {
            url = new URI(urlStr).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        AvaticaHttpClientFactory httpClientFactory = config.httpClientFactory();
        return httpClientFactory.getClient(url, config, connection.getKerberosConnection());
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        int retries = 0;
        int currentRetry = 0;
        long failoverSleepTime = 0L;
        while (true) {
            long startTime = System.currentTimeMillis();
            AvaticaConnection conn = (AvaticaConnection)super.connect(url, info);
            if (conn == null) {
                return null;
            }
            ConnectionConfig config = conn.config();
            if (config.useClientSideLb()) {
                retries = config.getLBConnectionFailoverRetries();
                failoverSleepTime = config.getLBConnectionFailoverSleepTime();
            }
            Service service = conn.getService();
            assert (null != service);
            try {
                service.apply(new Service.OpenConnectionRequest(conn.id, Service.OpenConnectionRequest.serializeProperties(info)));
                return conn;
            }
            catch (Exception e) {
                long endTime = System.currentTimeMillis();
                long elapsedTime = endTime - startTime;
                LOG.warn("Connection Failed: {}", (Object)e.getMessage());
                LOG.debug("Failure detected in: {} milliseconds", (Object)elapsedTime);
                if (currentRetry < retries) {
                    ++currentRetry;
                    if (failoverSleepTime > 0L) {
                        try {
                            LOG.info("Sleeping for {} milliseconds before load balancer failover", (Object)failoverSleepTime);
                            Thread.sleep(failoverSleepTime);
                        }
                        catch (InterruptedException ex) {
                            throw new SQLException(ex);
                        }
                    }
                    LOG.info("Load balancer failover retry: {}", (Object)currentRetry);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    Serialization getSerialization(ConnectionConfig config) {
        String serializationStr = config.serialization();
        Serialization serializationType = Serialization.JSON;
        if (null != serializationStr) {
            try {
                serializationType = Serialization.valueOf(serializationStr.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return serializationType;
    }

    static {
        new Driver().register();
    }

    public static enum Serialization {
        JSON,
        PROTOBUF;

    }
}

