/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel;

import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Util;
import org.apache.ignite.internal.sql.engine.metadata.cost.IgniteCostFactory;
import org.apache.ignite.internal.sql.engine.rel.AbstractIgniteJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite.internal.sql.engine.util.Commons;

public class IgniteHashJoin
extends AbstractIgniteJoin {
    private static final String REL_TYPE_NAME = "HashJoin";

    public IgniteHashJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        super(cluster, traitSet, left, right, condition, variablesSet, joinType);
    }

    public IgniteHashJoin(RelInput input) {
        this(input.getCluster(), input.getTraitSet().replace((RelTrait)IgniteConvention.INSTANCE), (RelNode)input.getInputs().get(0), (RelNode)input.getInputs().get(1), input.getExpression("condition"), Set.copyOf(Commons.transform(input.getIntegerList("variablesSet"), CorrelationId::new)), (JoinRelType)input.getEnum("joinType", JoinRelType.class));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        IgniteCostFactory costFactory = (IgniteCostFactory)planner.getCostFactory();
        double leftRowCount = mq.getRowCount(this.getLeft());
        double rightRowCount = mq.getRowCount(this.getRight());
        if (Double.isInfinite(leftRowCount) || Double.isInfinite(rightRowCount)) {
            return planner.getCostFactory().makeInfiniteCost();
        }
        double rowCount = leftRowCount + rightRowCount;
        int rightKeysSize = this.joinInfo.rightKeys.size();
        double rightSize = rightRowCount * 4.0 * (double)this.getRight().getRowType().getFieldCount();
        double distRightRows = Util.first((Double)mq.getDistinctRowCount(this.right, ImmutableBitSet.of((ImmutableIntList)this.joinInfo.rightKeys), null), (double)(0.9 * rightRowCount));
        return costFactory.makeCost(rowCount, rowCount * 10.0, 0.0, rightSize += distRightRows * (double)rightKeysSize * 4.0, 0.0);
    }

    public Join copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new IgniteHashJoin(this.getCluster(), traitSet, left, right, condition, (Set<CorrelationId>)this.variablesSet, joinType);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteHashJoin(cluster, this.getTraitSet(), (RelNode)inputs.get(0), (RelNode)inputs.get(1), this.getCondition(), this.getVariablesSet(), this.getJoinType());
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }
}

