/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partitiondistribution;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.ignite.internal.partitiondistribution.Assignments;
import org.apache.ignite.internal.partitiondistribution.AssignmentsQueue;
import org.apache.ignite.internal.partitiondistribution.AssignmentsSerializer;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerializer;

public class AssignmentsQueueSerializer
extends VersionedSerializer<AssignmentsQueue> {
    public static final AssignmentsQueueSerializer INSTANCE = new AssignmentsQueueSerializer();

    protected void writeExternalData(AssignmentsQueue queue, IgniteDataOutput out) throws IOException {
        out.writeVarInt((long)queue.size());
        for (Assignments assignments : queue) {
            AssignmentsSerializer.INSTANCE.writeExternalData(assignments, out);
        }
    }

    protected AssignmentsQueue readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        if (protoVer == 1) {
            return AssignmentsQueueSerializer.readLegacySchema(protoVer, in);
        }
        return AssignmentsQueueSerializer.readActualSchema(protoVer, in);
    }

    private static AssignmentsQueue readActualSchema(byte protoVer, IgniteDataInput in) throws IOException {
        int length = in.readVarIntAsInt();
        LinkedList<Assignments> queue = new LinkedList<Assignments>();
        for (int i = 0; i < length; ++i) {
            queue.add(AssignmentsSerializer.INSTANCE.readExternalData(protoVer, in));
        }
        return new AssignmentsQueue(queue);
    }

    private static AssignmentsQueue readLegacySchema(byte protoVer, IgniteDataInput in) throws IOException {
        return new AssignmentsQueue(List.of(AssignmentsSerializer.INSTANCE.readExternalData(protoVer, in)));
    }

    protected byte getProtocolVersion() {
        return 2;
    }
}

