/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.descriptors;

import java.io.IOException;
import java.util.List;
import org.apache.ignite3.internal.catalog.descriptors.CatalogStorageProfileDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogStorageProfilesDescriptor;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;

public class CatalogStorageProfilesDescriptorSerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class StorageProfilesDescriptorSerializerV2
    implements CatalogObjectSerializer<CatalogStorageProfilesDescriptor> {
        StorageProfilesDescriptorSerializerV2() {
        }

        @Override
        public CatalogStorageProfilesDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            List<CatalogStorageProfileDescriptor> storageProfileDescriptors = input.readEntryList(CatalogStorageProfileDescriptor.class);
            return new CatalogStorageProfilesDescriptor(storageProfileDescriptors);
        }

        @Override
        public void writeTo(CatalogStorageProfilesDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            output.writeEntryList(descriptor.profiles());
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    static class StorageProfilesDescriptorSerializerV1
    implements CatalogObjectSerializer<CatalogStorageProfilesDescriptor> {
        private final CatalogEntrySerializerProvider serializers;

        public StorageProfilesDescriptorSerializerV1(CatalogEntrySerializerProvider serializers) {
            this.serializers = serializers;
        }

        @Override
        public CatalogStorageProfilesDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogObjectSerializer profileSerializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_STORAGE_PROFILE.id());
            List<CatalogStorageProfileDescriptor> storageProfileDescriptors = CatalogSerializationUtils.readList(profileSerializer, input);
            return new CatalogStorageProfilesDescriptor(storageProfileDescriptors);
        }

        @Override
        public void writeTo(CatalogStorageProfilesDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            CatalogObjectSerializer profileSerializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_STORAGE_PROFILE.id());
            CatalogSerializationUtils.writeList(descriptor.profiles(), profileSerializer, output);
        }
    }
}

