/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.processors.cache.CacheConfigurationEnrichment;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class GridCacheAttributes
implements Serializable {
    private static final long serialVersionUID = 0L;
    private CacheConfiguration ccfg;
    private CacheConfigurationEnrichment enrichment;

    public GridCacheAttributes(CacheConfiguration cfg) {
        this.ccfg = cfg;
    }

    public GridCacheAttributes(CacheConfiguration cfg, CacheConfigurationEnrichment enrichment) {
        this.ccfg = cfg;
        this.enrichment = enrichment;
    }

    public String groupName() {
        return this.ccfg.getGroupName();
    }

    public CacheConfiguration configuration() {
        return this.ccfg;
    }

    public String cacheName() {
        return this.ccfg.getName();
    }

    public int qryParallelism() {
        return this.ccfg.getQueryParallelism();
    }

    public CacheMode cacheMode() {
        CacheMode cacheMode = this.ccfg.getCacheMode();
        return cacheMode != null ? cacheMode : CacheConfiguration.DFLT_CACHE_MODE;
    }

    public CacheAtomicityMode atomicityMode() {
        CacheAtomicityMode atomicityMode = this.ccfg.getAtomicityMode();
        return atomicityMode != null ? atomicityMode : CacheConfiguration.DFLT_CACHE_ATOMICITY_MODE;
    }

    public boolean nearCacheEnabled() {
        return this.ccfg.getNearConfiguration() != null;
    }

    public CacheRebalanceMode cacheRebalanceMode() {
        return this.ccfg.getRebalanceMode();
    }

    public String cacheAffinityClassName() {
        return GridCacheAttributes.className(this.ccfg.getAffinity());
    }

    public String cacheAffinityMapperClassName() {
        return GridCacheAttributes.className(this.ccfg.getAffinityMapper());
    }

    public boolean affinityIncludeNeighbors() {
        AffinityFunction aff = this.ccfg.getAffinity();
        return aff instanceof RendezvousAffinityFunction && !((RendezvousAffinityFunction)aff).isExcludeNeighbors();
    }

    public int affinityKeyBackups() {
        return this.ccfg.getBackups();
    }

    public int affinityPartitionsCount() {
        return this.ccfg.getAffinity().partitions();
    }

    public String evictionFilterClassName() {
        if (this.enrichment != null) {
            return this.enrichment.getFieldClassName("evictFilter");
        }
        return GridCacheAttributes.className(this.ccfg.getEvictionFilter());
    }

    @Deprecated
    public String evictionPolicyClassName() {
        return GridCacheAttributes.className(this.ccfg.getEvictionPolicy());
    }

    public String evictionPolicyFactoryClassName() {
        if (this.enrichment != null) {
            return this.enrichment.getFieldClassName("evictPlcFactory");
        }
        return GridCacheAttributes.className(this.ccfg.getEvictionPolicyFactory());
    }

    public String nearEvictionPolicyClassName() {
        NearCacheConfiguration nearCfg = this.ccfg.getNearConfiguration();
        if (nearCfg == null) {
            return null;
        }
        return GridCacheAttributes.className(nearCfg.getNearEvictionPolicy());
    }

    public String nearEvictionPolicyFactoryClassName() {
        NearCacheConfiguration nearCfg = this.ccfg.getNearConfiguration();
        if (nearCfg == null) {
            return null;
        }
        return GridCacheAttributes.className(nearCfg.getNearEvictionPolicyFactory());
    }

    public String storeFactoryClassName() {
        if (this.enrichment != null) {
            return this.enrichment.getFieldClassName("storeFactory");
        }
        return GridCacheAttributes.className(this.ccfg.getCacheStoreFactory());
    }

    @Deprecated
    public String transactionManagerLookupClassName() {
        return this.ccfg.getTransactionManagerLookupClassName();
    }

    public long defaultLockTimeout() {
        return this.ccfg.getDefaultLockTimeout();
    }

    @Deprecated
    public int rebalanceBatchSize() {
        return this.ccfg.getRebalanceBatchSize();
    }

    public long rebalanceDelay() {
        return this.ccfg.getRebalanceDelay();
    }

    @Deprecated
    public long rebalanceBatchesPrefetchCount() {
        return this.ccfg.getRebalanceBatchesPrefetchCount();
    }

    public int rebalanceOrder() {
        return this.ccfg.getRebalanceOrder();
    }

    @Deprecated
    public long rebalanceThrottle() {
        return this.ccfg.getRebalanceThrottle();
    }

    @Deprecated
    public long rebalanceTimeout() {
        return this.ccfg.getRebalanceTimeout();
    }

    public CacheWriteSynchronizationMode writeSynchronization() {
        return this.ccfg.getWriteSynchronizationMode();
    }

    public boolean readThrough() {
        return this.ccfg.isReadThrough();
    }

    public boolean writeThrough() {
        return this.ccfg.isWriteThrough();
    }

    public boolean loadPreviousValue() {
        return this.ccfg.isLoadPreviousValue();
    }

    public boolean writeBehindEnabled() {
        return this.ccfg.isWriteBehindEnabled();
    }

    public int writeBehindFlushSize() {
        return this.ccfg.getWriteBehindFlushSize();
    }

    public long writeBehindFlushFrequency() {
        return this.ccfg.getWriteBehindFlushFrequency();
    }

    public int writeBehindFlushThreadCount() {
        return this.ccfg.getWriteBehindFlushThreadCount();
    }

    public int writeBehindBatchSize() {
        return this.ccfg.getWriteBehindBatchSize();
    }

    public boolean writeBehindCoalescing() {
        return this.ccfg.getWriteBehindCoalescing();
    }

    public String interceptorClassName() {
        if (this.enrichment != null && this.enrichment.hasField("interceptor")) {
            return this.enrichment.getFieldClassName("interceptor");
        }
        return GridCacheAttributes.className(this.ccfg.getInterceptor());
    }

    String nodeFilterClassName() {
        return GridCacheAttributes.className(this.ccfg.getNodeFilter());
    }

    String topologyValidatorClassName() {
        return GridCacheAttributes.className(this.ccfg.getTopologyValidator());
    }

    public boolean isEncryptionEnabled() {
        return this.ccfg.isEncryptionEnabled();
    }

    @Nullable
    private static String className(@Nullable Object obj) {
        return obj != null ? obj.getClass().getName() : null;
    }

    public String toString() {
        return S.toString(GridCacheAttributes.class, this);
    }
}

