/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.regex.Pattern;
import org.apache.amoro.io.AuthenticatedHadoopFileIO;
import org.apache.amoro.io.SupportFileRecycleOperations;
import org.apache.amoro.io.TableTrashManager;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.base.Strings;
import org.apache.amoro.table.TableMetaStore;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoverableHadoopFileIO
extends AuthenticatedHadoopFileIO
implements SupportFileRecycleOperations {
    private static final Logger LOG = LoggerFactory.getLogger(RecoverableHadoopFileIO.class);
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    private final TableTrashManager trashManager;
    private final String trashFilePattern;
    private final Pattern pattern;

    RecoverableHadoopFileIO(TableMetaStore tableMetaStore, TableTrashManager trashManager, String trashFilePattern) {
        super(tableMetaStore);
        this.trashManager = trashManager;
        this.trashFilePattern = trashFilePattern;
        this.pattern = Strings.isNullOrEmpty((String)this.trashFilePattern) ? null : Pattern.compile(this.trashFilePattern);
    }

    @Override
    public void deleteFile(String path) {
        if (this.matchTrashFilePattern(path)) {
            this.moveToTrash(path);
        } else {
            super.deleteFile(path);
        }
    }

    public void deleteFile(InputFile file) {
        if (this.matchTrashFilePattern(file.location())) {
            this.moveToTrash(file.location());
        } else {
            super.deleteFile(file);
        }
    }

    public void deleteFile(OutputFile file) {
        if (this.matchTrashFilePattern(file.location())) {
            this.moveToTrash(file.location());
        } else {
            super.deleteFile(file);
        }
    }

    @VisibleForTesting
    protected boolean matchTrashFilePattern(String path) {
        return this.pattern.matcher(path).matches();
    }

    @VisibleForTesting
    public TableTrashManager getTrashManager() {
        return this.trashManager;
    }

    public String getTrashFilePattern() {
        return this.trashFilePattern;
    }

    private void moveToTrash(String filePath) {
        this.trashManager.moveFileToTrash(filePath);
        LOG.debug("Move file:{} to table trash", (Object)filePath);
    }

    @Override
    public boolean fileRecoverable(String path) {
        return this.trashManager.fileExistInTrash(path);
    }

    @Override
    public boolean recover(String path) {
        return this.trashManager.restoreFileFromTrash(path);
    }

    @Override
    public void expireRecycle(LocalDate expirationDate) {
        this.trashManager.cleanFiles(expirationDate);
    }
}

