/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.resource;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.config.Configurations;
import org.apache.amoro.resource.Resource;
import org.apache.amoro.resource.ResourceGroup;
import org.apache.amoro.server.catalog.CatalogManager;
import org.apache.amoro.server.persistence.PersistentBase;
import org.apache.amoro.server.persistence.mapper.OptimizerMapper;
import org.apache.amoro.server.persistence.mapper.ResourceMapper;
import org.apache.amoro.server.persistence.mapper.TableMetaMapper;
import org.apache.amoro.server.resource.OptimizerInstance;
import org.apache.amoro.server.resource.OptimizerManager;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;

public class DefaultOptimizerManager
extends PersistentBase
implements OptimizerManager {
    protected final Configurations serverConfiguration;
    private final CatalogManager catalogManager;

    public DefaultOptimizerManager(Configurations serverConfiguration, CatalogManager catalogManager) {
        this.catalogManager = catalogManager;
        this.serverConfiguration = serverConfiguration;
    }

    private void unregisterOptimizer(String token) {
        this.doAs(OptimizerMapper.class, mapper -> mapper.deleteOptimizer(token));
    }

    @Override
    public List<OptimizerInstance> listOptimizers() {
        return this.getAs(OptimizerMapper.class, OptimizerMapper::selectAll);
    }

    @Override
    public List<OptimizerInstance> listOptimizers(String group) {
        List authOptimizers = this.getAs(OptimizerMapper.class, OptimizerMapper::selectAll);
        return authOptimizers.stream().filter(optimizer -> optimizer.getGroupName().equals(group)).collect(Collectors.toList());
    }

    @Override
    public void deleteOptimizer(String group, String resourceId) {
        List deleteOptimizers = this.getAs(OptimizerMapper.class, mapper -> mapper.selectByResourceId(resourceId));
        deleteOptimizers.forEach(optimizer -> {
            String token = optimizer.getToken();
            this.unregisterOptimizer(token);
        });
    }

    public void createResourceGroup(ResourceGroup resourceGroup) {
        this.doAs(ResourceMapper.class, mapper -> mapper.insertResourceGroup(resourceGroup));
    }

    public void deleteResourceGroup(String groupName) {
        if (!this.canDeleteResourceGroup(groupName)) {
            throw new RuntimeException(String.format("The resource group %s cannot be deleted because it is currently in use.", groupName));
        }
        this.doAs(ResourceMapper.class, mapper -> mapper.deleteResourceGroup(groupName));
    }

    public void updateResourceGroup(ResourceGroup resourceGroup) {
        Preconditions.checkNotNull((Object)resourceGroup, (Object)"The resource group cannot be null.");
        this.doAs(ResourceMapper.class, mapper -> mapper.updateResourceGroup(resourceGroup));
    }

    public void createResource(Resource resource) {
        this.doAs(ResourceMapper.class, mapper -> mapper.insertResource(resource));
    }

    public void deleteResource(String resourceId) {
        this.doAs(ResourceMapper.class, mapper -> mapper.deleteResource(resourceId));
    }

    public List<ResourceGroup> listResourceGroups() {
        return this.getAs(ResourceMapper.class, ResourceMapper::selectResourceGroups);
    }

    public List<ResourceGroup> listResourceGroups(String containerName) {
        return this.getAs(ResourceMapper.class, ResourceMapper::selectResourceGroups).stream().filter(group -> group.getContainer().equals(containerName)).collect(Collectors.toList());
    }

    public ResourceGroup getResourceGroup(String groupName) {
        return this.getAs(ResourceMapper.class, mapper -> mapper.selectResourceGroup(groupName));
    }

    public List<Resource> listResourcesByGroup(String groupName) {
        return this.getAs(ResourceMapper.class, mapper -> mapper.selectResourcesByGroup(groupName));
    }

    public Resource getResource(String resourceId) {
        return this.getAs(ResourceMapper.class, mapper -> mapper.selectResource(resourceId));
    }

    @Override
    public boolean canDeleteResourceGroup(String name) {
        for (CatalogMeta catalogMeta : this.catalogManager.listCatalogMetas()) {
            if (catalogMeta.getCatalogProperties() == null || !catalogMeta.getCatalogProperties().getOrDefault("table.self-optimizing.group", "default").equals(name)) continue;
            return false;
        }
        for (OptimizerInstance optimizer : this.listOptimizers()) {
            if (!optimizer.getGroupName().equals(name)) continue;
            return false;
        }
        List tableRuntimeMetas = this.getAs(TableMetaMapper.class, mapper -> mapper.selectTableRuntimesForOptimizerGroup(name, null, null, null));
        return tableRuntimeMetas.isEmpty();
    }
}

