/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.amoro.parser;

import java.io.Serializable;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.amoro.spark.sql.parser.MixedFormatSqlExtendParser;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.parser.ParseException$;
import org.apache.spark.sql.catalyst.trees.Origin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;

public final class QueryParsingErrors$
implements QueryErrorsBase {
    public static QueryParsingErrors$ MODULE$;

    static {
        new QueryParsingErrors$();
    }

    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$((QueryErrorsBase)this, (Object)v, (DataType)t);
    }

    public String toSQLStmt(String text) {
        return QueryErrorsBase.toSQLStmt$((QueryErrorsBase)this, (String)text);
    }

    public String toSQLId(Seq<String> parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, parts);
    }

    public String toSQLId(String parts) {
        return QueryErrorsBase.toSQLId$((QueryErrorsBase)this, (String)parts);
    }

    public String toSQLType(DataType t) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, (DataType)t);
    }

    public String toSQLType(String text) {
        return QueryErrorsBase.toSQLType$((QueryErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return QueryErrorsBase.toSQLConf$((QueryErrorsBase)this, (String)conf);
    }

    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$((QueryErrorsBase)this, (String)option);
    }

    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$((QueryErrorsBase)this, (Expression)e);
    }

    public Throwable columnAliasInOperationNotAllowedError(String op, MixedFormatSqlExtendParser.TableAliasContext ctx) {
        return new ParseException(new StringBuilder(36).append("Columns aliases are not allowed in ").append(op).append(".").toString(), (ParserRuleContext)ctx.identifierList());
    }

    public Throwable combinationQueryResultClausesUnsupportedError(MixedFormatSqlExtendParser.QueryOrganizationContext ctx) {
        return new ParseException("Combination of ORDER BY/SORT BY/DISTRIBUTE BY/CLUSTER BY is not supported", (ParserRuleContext)ctx);
    }

    public Throwable distributeByUnsupportedError(MixedFormatSqlExtendParser.QueryOrganizationContext ctx) {
        return new ParseException("DISTRIBUTE BY is not supported", (ParserRuleContext)ctx);
    }

    public Throwable transformNotSupportQuantifierError(ParserRuleContext ctx) {
        return new ParseException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{new StringBuilder(29).append(this.toSQLStmt("TRANSFORM")).append(" does not support").append(" ").append(this.toSQLStmt("DISTINCT")).append("/").append(this.toSQLStmt("ALL")).append(" in inputs").toString()}), ctx);
    }

    public Throwable transformWithSerdeUnsupportedError(ParserRuleContext ctx) {
        return new ParseException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{new StringBuilder(42).append(this.toSQLStmt("TRANSFORM")).append(" with serde is only supported in hive mode").toString()}), ctx);
    }

    public Throwable lateralWithPivotInFromClauseNotAllowedError(MixedFormatSqlExtendParser.FromClauseContext ctx) {
        return new ParseException("LATERAL cannot be used together with PIVOT in FROM clause", (ParserRuleContext)ctx);
    }

    public Throwable lateralJoinWithNaturalJoinUnsupportedError(ParserRuleContext ctx) {
        return new ParseException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{new StringBuilder(17).append(this.toSQLStmt("LATERAL")).append(" join with ").append(this.toSQLStmt("NATURAL")).append(" join.").toString()}), ctx);
    }

    public Throwable lateralJoinWithUsingJoinUnsupportedError(ParserRuleContext ctx) {
        return new ParseException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{new StringBuilder(17).append(this.toSQLStmt("LATERAL")).append(" join with ").append(this.toSQLStmt("USING")).append(" join.").toString()}), ctx);
    }

    public Throwable unsupportedLateralJoinTypeError(ParserRuleContext ctx, String joinType) {
        return new ParseException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{new StringBuilder(12).append(this.toSQLStmt("LATERAL")).append(" join type ").append(this.toSQLStmt(joinType)).append(".").toString()}), ctx);
    }

    public Throwable invalidLateralJoinRelationError(MixedFormatSqlExtendParser.RelationPrimaryContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX", (String[])((Object[])new String[]{new StringBuilder(32).append(this.toSQLStmt("LATERAL")).append(" can only be used with subquery.").toString()}), (ParserRuleContext)ctx);
    }

    public Throwable repetitiveWindowDefinitionError(String name, MixedFormatSqlExtendParser.WindowClauseContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX", (String[])((Object[])new String[]{new StringBuilder(40).append("The definition of window ").append(this.toSQLId(name)).append(" is repetitive.").toString()}), (ParserRuleContext)ctx);
    }

    public Throwable invalidWindowReferenceError(String name, MixedFormatSqlExtendParser.WindowClauseContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX", (String[])((Object[])new String[]{new StringBuilder(48).append("Window reference ").append(this.toSQLId(name)).append(" is not a window specification.").toString()}), (ParserRuleContext)ctx);
    }

    public Throwable cannotResolveWindowReferenceError(String name, MixedFormatSqlExtendParser.WindowClauseContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX", (String[])((Object[])new String[]{new StringBuilder(33).append("Cannot resolve window reference ").append(this.toSQLId(name)).append(".").toString()}), (ParserRuleContext)ctx);
    }

    public Throwable naturalCrossJoinUnsupportedError(MixedFormatSqlExtendParser.RelationContext ctx) {
        return new ParseException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{new StringBuilder(1).append(this.toSQLStmt("NATURAL CROSS JOIN")).append(".").toString()}), (ParserRuleContext)ctx);
    }

    public Throwable emptyInputForTableSampleError(ParserRuleContext ctx) {
        return new ParseException("TABLESAMPLE does not accept empty inputs.", ctx);
    }

    public Throwable tableSampleByBytesUnsupportedError(String msg, MixedFormatSqlExtendParser.SampleMethodContext ctx) {
        return new ParseException(new StringBuilder(30).append("TABLESAMPLE(").append(msg).append(") is not supported").toString(), (ParserRuleContext)ctx);
    }

    public Throwable invalidByteLengthLiteralError(String bytesStr, MixedFormatSqlExtendParser.SampleByBytesContext ctx) {
        return new ParseException(new StringBuilder(84).append(bytesStr).append(" is not a valid byte length literal, ").append("expected syntax: DIGIT+ ('B' | 'K' | 'M' | 'G')").toString(), (ParserRuleContext)ctx);
    }

    public Throwable invalidEscapeStringError(MixedFormatSqlExtendParser.PredicateContext ctx) {
        return new ParseException("Invalid escape string. Escape string must contain only one character.", (ParserRuleContext)ctx);
    }

    public Throwable trimOptionUnsupportedError(int trimOption, MixedFormatSqlExtendParser.TrimContext ctx) {
        return new ParseException(new StringBuilder(91).append("Function trim doesn't support with ").append("type ").append(trimOption).append(". Please use BOTH, LEADING or TRAILING as trim type").toString(), (ParserRuleContext)ctx);
    }

    public Throwable functionNameUnsupportedError(String functionName, ParserRuleContext ctx) {
        return new ParseException(new StringBuilder(28).append("Unsupported function name '").append(functionName).append("'").toString(), ctx);
    }

    public Throwable cannotParseValueTypeError(String valueType, String value, MixedFormatSqlExtendParser.TypeConstructorContext ctx) {
        return new ParseException(new StringBuilder(25).append("Cannot parse the ").append(valueType).append(" value: ").append(value).toString(), (ParserRuleContext)ctx);
    }

    public Throwable cannotParseIntervalValueError(String value, MixedFormatSqlExtendParser.TypeConstructorContext ctx) {
        return new ParseException(new StringBuilder(33).append("Cannot parse the INTERVAL value: ").append(value).toString(), (ParserRuleContext)ctx);
    }

    public Throwable literalValueTypeUnsupportedError(String valueType, MixedFormatSqlExtendParser.TypeConstructorContext ctx) {
        return new ParseException(new StringBuilder(48).append("Literals of type '").append(valueType).append("' are currently not supported.").toString(), (ParserRuleContext)ctx);
    }

    public Throwable parsingValueTypeError(IllegalArgumentException e, String valueType, MixedFormatSqlExtendParser.TypeConstructorContext ctx) {
        String message = (String)Option$.MODULE$.apply((Object)e.getMessage()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Exception parsing ").append(valueType).toString());
        return new ParseException(message, (ParserRuleContext)ctx);
    }

    public Throwable invalidNumericLiteralRangeError(String rawStrippedQualifier, BigDecimal minValue, BigDecimal maxValue, String typeName, MixedFormatSqlExtendParser.NumberContext ctx) {
        return new ParseException(new StringBuilder(53).append("Numeric literal ").append(rawStrippedQualifier).append(" does not ").append("fit in range [").append(minValue).append(", ").append(maxValue).append("] for type ").append(typeName).toString(), (ParserRuleContext)ctx);
    }

    public Throwable moreThanOneFromToUnitInIntervalLiteralError(ParserRuleContext ctx) {
        return new ParseException("Can only have a single from-to unit in the interval literal syntax", ctx);
    }

    public Throwable invalidIntervalLiteralError(MixedFormatSqlExtendParser.IntervalContext ctx) {
        return new ParseException("at least one time unit should be given for interval literal", (ParserRuleContext)ctx);
    }

    public Throwable invalidIntervalFormError(String value, MixedFormatSqlExtendParser.MultiUnitsIntervalContext ctx) {
        return new ParseException(new StringBuilder(116).append("Can only use numbers in the interval value part for").append(" multiple unit value pairs interval form, but got invalid value: ").append(value).toString(), (ParserRuleContext)ctx);
    }

    public Throwable invalidFromToUnitValueError(MixedFormatSqlExtendParser.IntervalValueContext ctx) {
        return new ParseException("The value of from-to unit must be a string", (ParserRuleContext)ctx);
    }

    public Throwable fromToIntervalUnsupportedError(String from, String to, ParserRuleContext ctx) {
        return new ParseException(new StringBuilder(38).append("Intervals FROM ").append(from).append(" TO ").append(to).append(" are not supported.").toString(), ctx);
    }

    public Throwable mixedIntervalUnitsError(String literal, ParserRuleContext ctx) {
        return new ParseException(new StringBuilder(43).append("Cannot mix year-month and day-time fields: ").append(literal).toString(), ctx);
    }

    public Throwable dataTypeUnsupportedError(String dataType, MixedFormatSqlExtendParser.PrimitiveDataTypeContext ctx) {
        return new ParseException(new StringBuilder(27).append("DataType ").append(dataType).append(" is not supported.").toString(), (ParserRuleContext)ctx);
    }

    public Throwable charTypeMissingLengthError(String dataType, MixedFormatSqlExtendParser.PrimitiveDataTypeContext ctx) {
        return new ParseException("PARSE_CHAR_MISSING_LENGTH", (String[])((Object[])new String[]{dataType, dataType}), (ParserRuleContext)ctx);
    }

    public Throwable partitionTransformNotExpectedError(String name, String describe, MixedFormatSqlExtendParser.ApplyTransformContext ctx) {
        return new ParseException(new StringBuilder(44).append("Expected a column reference for transform ").append(name).append(": ").append(describe).toString(), (ParserRuleContext)ctx);
    }

    public Throwable tooManyArgumentsForTransformError(String name, MixedFormatSqlExtendParser.ApplyTransformContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX", (String[])((Object[])new String[]{new StringBuilder(33).append("Too many arguments for transform ").append(this.toSQLId(name)).toString()}), (ParserRuleContext)ctx);
    }

    public Throwable invalidBucketsNumberError(String describe, MixedFormatSqlExtendParser.ApplyTransformContext ctx) {
        return new ParseException(new StringBuilder(27).append("Invalid number of buckets: ").append(describe).toString(), (ParserRuleContext)ctx);
    }

    public ParseException cannotCleanReservedNamespacePropertyError(String property, ParserRuleContext ctx, String msg) {
        return new ParseException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{new StringBuilder(36).append(property).append(" is a reserved namespace property, ").append(msg).append(".").toString()}), ctx);
    }

    public ParseException cannotCleanReservedTablePropertyError(String property, ParserRuleContext ctx, String msg) {
        return new ParseException("UNSUPPORTED_FEATURE", (String[])((Object[])new String[]{new StringBuilder(32).append(property).append(" is a reserved table property, ").append(msg).append(".").toString()}), ctx);
    }

    public Throwable duplicatedTablePathsFoundError(String pathOne, String pathTwo, ParserRuleContext ctx) {
        return new ParseException(new StringBuilder(178).append("Duplicated table paths found: '").append(pathOne).append("' and '").append(pathTwo).append("'. LOCATION").append(" and the case insensitive key 'path' in OPTIONS are all used to indicate the custom").append(" table path, you can only specify one of them.").toString(), ctx);
    }

    public Throwable storedAsAndStoredByBothSpecifiedError(MixedFormatSqlExtendParser.CreateFileFormatContext ctx) {
        return new ParseException("Expected either STORED AS or STORED BY, not both", (ParserRuleContext)ctx);
    }

    public Throwable operationInHiveStyleCommandUnsupportedError(String operation, String command, MixedFormatSqlExtendParser.StatementContext ctx, Option<String> msgOpt) {
        String basicError = new StringBuilder(32).append(operation).append(" is not supported in Hive-style ").append(command).toString();
        String msg = msgOpt.isDefined() ? new StringBuilder(3).append(basicError).append(", ").append(msgOpt.get()).append(".").toString() : basicError;
        return new ParseException(msg, (ParserRuleContext)ctx);
    }

    public Option<String> operationInHiveStyleCommandUnsupportedError$default$4() {
        return None$.MODULE$;
    }

    public Throwable operationNotAllowedError(String message, ParserRuleContext ctx) {
        return new ParseException(new StringBuilder(23).append("Operation not allowed: ").append(message).toString(), ctx);
    }

    public Throwable computeStatisticsNotExpectedError(MixedFormatSqlExtendParser.IdentifierContext ctx) {
        return new ParseException(new StringBuilder(31).append("Expected `NOSCAN` instead of `").append(ctx.getText()).append("`").toString(), (ParserRuleContext)ctx);
    }

    public Throwable showFunctionsUnsupportedError(String identifier, MixedFormatSqlExtendParser.IdentifierContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX", (String[])((Object[])new String[]{new StringBuilder(16).append(this.toSQLStmt("SHOW")).append(" ").append(identifier).append(" ").append(this.toSQLStmt("FUNCTIONS")).append(" not supported").toString()}), (ParserRuleContext)ctx);
    }

    public Throwable showFunctionsInvalidPatternError(String pattern, ParserRuleContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX", (String[])((Object[])new String[]{new StringBuilder(45).append("Invalid pattern in ").append(this.toSQLStmt("SHOW FUNCTIONS")).append(": ").append(this.toSQLId(pattern)).append(". ").append("It must be a ").append(this.toSQLType((DataType)StringType$.MODULE$)).append(" literal.").toString()}), ctx);
    }

    public Throwable duplicateCteDefinitionNamesError(String duplicateNames, MixedFormatSqlExtendParser.CtesContext ctx) {
        return new ParseException(new StringBuilder(44).append("CTE definition can't have duplicate names: ").append(duplicateNames).append(".").toString(), (ParserRuleContext)ctx);
    }

    public Throwable sqlStatementUnsupportedError(String sqlText, Origin position) {
        return new ParseException(Option$.MODULE$.apply((Object)sqlText), "Unsupported SQL statement", position, position, ParseException$.MODULE$.$lessinit$greater$default$5(), ParseException$.MODULE$.$lessinit$greater$default$6());
    }

    public Throwable unquotedIdentifierError(String ident, MixedFormatSqlExtendParser.ErrorIdentContext ctx) {
        return new ParseException(new StringBuilder(89).append("Possibly unquoted identifier ").append(ident).append(" detected. ").append("Please consider quoting it with back-quotes as `").append(ident).append("`").toString(), (ParserRuleContext)ctx);
    }

    public Throwable duplicateClausesError(String clauseName, ParserRuleContext ctx) {
        return new ParseException(new StringBuilder(25).append("Found duplicate clauses: ").append(clauseName).toString(), ctx);
    }

    public Throwable duplicateKeysError(String key, ParserRuleContext ctx) {
        return new ParseException("DUPLICATE_KEY", (String[])((Object[])new String[]{this.toSQLId(key)}), ctx);
    }

    public Throwable unexpectedFomatForSetConfigurationError(ParserRuleContext ctx) {
        return new ParseException(new StringOps(Predef$.MODULE$.augmentString("\n         |Expected format is 'SET', 'SET key', or 'SET key=value'. If you want to include\n         |special characters in key, or include semicolon in value, please use quotes,\n         |e.g., SET `ke y`=`v;alue`.\n       ")).stripMargin().replaceAll("\n", " "), ctx);
    }

    public ParseException invalidPropertyKeyForSetQuotedConfigurationError(String keyCandidate, String valueStr, ParserRuleContext ctx) {
        return new ParseException("INVALID_PROPERTY_KEY", (String[])((Object[])new String[]{this.toSQLConf(keyCandidate), this.toSQLConf(keyCandidate), this.toSQLConf(valueStr)}), ctx);
    }

    public ParseException invalidPropertyValueForSetQuotedConfigurationError(String valueCandidate, String keyStr, ParserRuleContext ctx) {
        return new ParseException("INVALID_PROPERTY_VALUE", (String[])((Object[])new String[]{this.toSQLConf(valueCandidate), this.toSQLConf(keyStr), this.toSQLConf(valueCandidate)}), ctx);
    }

    public Throwable intervalValueOutOfRangeError(MixedFormatSqlExtendParser.IntervalContext ctx) {
        return new ParseException("The interval value must be in the range of [-18, +18] hours with second precision", (ParserRuleContext)ctx);
    }

    public Throwable useDefinedRecordReaderOrWriterClassesError(ParserRuleContext ctx) {
        return new ParseException("Unsupported operation: Used defined record reader/writer classes.", ctx);
    }

    public Throwable invalidGroupingSetError(String element, MixedFormatSqlExtendParser.GroupingAnalyticsContext ctx) {
        return new ParseException(new StringBuilder(45).append("Empty set in ").append(element).append(" grouping sets is not supported.").toString(), (ParserRuleContext)ctx);
    }

    public Throwable invalidTableValuedFunctionNameError(Seq<String> name, MixedFormatSqlExtendParser.TableValuedFunctionContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX", (String[])((Object[])new String[]{"table valued function cannot specify database name ", this.toSQLId(name)}), (ParserRuleContext)ctx);
    }

    public Throwable unclosedBracketedCommentError(String command, Origin position) {
        return new ParseException((Option)new Some((Object)command), "Unclosed bracketed comment", position, position, ParseException$.MODULE$.$lessinit$greater$default$5(), ParseException$.MODULE$.$lessinit$greater$default$6());
    }

    public Throwable invalidTimeTravelSpec(String reason, ParserRuleContext ctx) {
        return new ParseException(new StringBuilder(27).append("Invalid time travel spec: ").append(reason).append(".").toString(), ctx);
    }

    public Throwable invalidNameForDropTempFunc(Seq<String> name, ParserRuleContext ctx) {
        return new ParseException(new StringBuilder(61).append("DROP TEMPORARY FUNCTION requires a single part name but got: ").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(name).quoted()).toString(), ctx);
    }

    private QueryParsingErrors$() {
        MODULE$ = this;
        QueryErrorsBase.$init$((QueryErrorsBase)this);
    }
}

