/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks.mailbox;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.streaming.runtime.tasks.mailbox.Mail;
import org.apache.flink.streaming.runtime.tasks.mailbox.TaskMailbox;

@ThreadSafe
public class TaskMailboxImpl
implements TaskMailbox {
    private final ReentrantLock lock = new ReentrantLock();
    @GuardedBy(value="lock")
    private final Deque<Mail> queue = new ArrayDeque<Mail>();
    @GuardedBy(value="lock")
    private final Condition notEmpty = this.lock.newCondition();
    @GuardedBy(value="lock")
    private TaskMailbox.State state = TaskMailbox.State.OPEN;
    @Nonnull
    private final Thread taskMailboxThread;
    private final Deque<Mail> batch = new ArrayDeque<Mail>();
    private volatile boolean hasNewMail = false;

    public TaskMailboxImpl(@Nonnull Thread taskMailboxThread) {
        this.taskMailboxThread = taskMailboxThread;
    }

    @VisibleForTesting
    public TaskMailboxImpl() {
        this(Thread.currentThread());
    }

    @Override
    public boolean isMailboxThread() {
        return Thread.currentThread() == this.taskMailboxThread;
    }

    @Override
    public boolean hasMail() {
        this.checkIsMailboxThread();
        return !this.batch.isEmpty() || this.hasNewMail;
    }

    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.batch.size() + this.queue.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Mail> tryTake(int priority) {
        this.checkIsMailboxThread();
        this.checkTakeStateConditions();
        Mail head = this.takeOrNull(this.batch, priority);
        if (head != null) {
            return Optional.of(head);
        }
        if (!this.hasNewMail) {
            return Optional.empty();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Mail value = this.takeOrNull(this.queue, priority);
            if (value == null) {
                Optional<Mail> optional = Optional.empty();
                return optional;
            }
            this.hasNewMail = !this.queue.isEmpty();
            Optional<Mail> optional = Optional.ofNullable(value);
            return optional;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Mail take(int priority) throws InterruptedException, IllegalStateException {
        this.checkIsMailboxThread();
        this.checkTakeStateConditions();
        Mail head = this.takeOrNull(this.batch, priority);
        if (head != null) {
            return head;
        }
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            Mail headMail;
            while ((headMail = this.takeOrNull(this.queue, priority)) == null) {
                this.notEmpty.await(1L, TimeUnit.SECONDS);
            }
            this.hasNewMail = !this.queue.isEmpty();
            Mail mail = headMail;
            return mail;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createBatch() {
        this.checkIsMailboxThread();
        if (!this.hasNewMail) {
            return !this.batch.isEmpty();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Mail mail;
            while ((mail = this.queue.pollFirst()) != null) {
                this.batch.addLast(mail);
            }
            this.hasNewMail = false;
            boolean bl = !this.batch.isEmpty();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Optional<Mail> tryTakeFromBatch() {
        this.checkIsMailboxThread();
        this.checkTakeStateConditions();
        return Optional.ofNullable(this.batch.pollFirst());
    }

    @Override
    public void put(@Nonnull Mail mail) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.checkPutStateConditions();
            this.queue.addLast(mail);
            this.hasNewMail = true;
            this.notEmpty.signal();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void putFirst(@Nonnull Mail mail) {
        if (this.isMailboxThread()) {
            this.checkPutStateConditions();
            this.batch.addFirst(mail);
        } else {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                this.checkPutStateConditions();
                this.queue.addFirst(mail);
                this.hasNewMail = true;
                this.notEmpty.signal();
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Nullable
    private Mail takeOrNull(Deque<Mail> queue, int priority) {
        if (queue.isEmpty()) {
            return null;
        }
        Iterator<Mail> iterator = queue.iterator();
        while (iterator.hasNext()) {
            Mail mail = iterator.next();
            if (mail.getPriority() < priority) continue;
            iterator.remove();
            return mail;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Mail> drain() {
        ArrayList<Mail> drainedMails = new ArrayList<Mail>(this.batch);
        this.batch.clear();
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            drainedMails.addAll(this.queue);
            this.queue.clear();
            this.hasNewMail = false;
            ArrayList<Mail> arrayList = drainedMails;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    private void checkIsMailboxThread() {
        if (!this.isMailboxThread()) {
            throw new IllegalStateException("Illegal thread detected. This method must be called from inside the mailbox thread!");
        }
    }

    private void checkPutStateConditions() {
        if (this.state != TaskMailbox.State.OPEN) {
            throw new TaskMailbox.MailboxClosedException("Mailbox is in state " + (Object)((Object)this.state) + ", but is required to be in state " + (Object)((Object)TaskMailbox.State.OPEN) + " for put operations.");
        }
    }

    private void checkTakeStateConditions() {
        if (this.state == TaskMailbox.State.CLOSED) {
            throw new TaskMailbox.MailboxClosedException("Mailbox is in state " + (Object)((Object)this.state) + ", but is required to be in state " + (Object)((Object)TaskMailbox.State.OPEN) + " or " + (Object)((Object)TaskMailbox.State.QUIESCED) + " for take operations.");
        }
    }

    @Override
    public void quiesce() {
        this.checkIsMailboxThread();
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.state == TaskMailbox.State.OPEN) {
                this.state = TaskMailbox.State.QUIESCED;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public List<Mail> close() {
        this.checkIsMailboxThread();
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.state == TaskMailbox.State.CLOSED) {
                List<Mail> list = Collections.emptyList();
                return list;
            }
            List<Mail> droppedMails = this.drain();
            this.state = TaskMailbox.State.CLOSED;
            this.notEmpty.signalAll();
            List<Mail> list = droppedMails;
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @Nonnull
    public TaskMailbox.State getState() {
        if (this.isMailboxThread()) {
            return this.state;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            TaskMailbox.State state = this.state;
            return state;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void runExclusively(Runnable runnable) {
        this.lock.lock();
        try {
            runnable.run();
        }
        finally {
            this.lock.unlock();
        }
    }
}

