/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.JavaEitherSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Either;

@Internal
public class EitherSerializer<L, R>
extends TypeSerializer<Either<L, R>> {
    private static final long serialVersionUID = 1L;
    private final TypeSerializer<L> leftSerializer;
    private final TypeSerializer<R> rightSerializer;

    public EitherSerializer(TypeSerializer<L> leftSerializer, TypeSerializer<R> rightSerializer) {
        this.leftSerializer = leftSerializer;
        this.rightSerializer = rightSerializer;
    }

    public TypeSerializer<R> getRightSerializer() {
        return this.rightSerializer;
    }

    public TypeSerializer<L> getLeftSerializer() {
        return this.leftSerializer;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public TypeSerializer<Either<L, R>> duplicate() {
        TypeSerializer<L> duplicateLeft = this.leftSerializer.duplicate();
        TypeSerializer<R> duplicateRight = this.rightSerializer.duplicate();
        if (this.leftSerializer != duplicateLeft || this.rightSerializer != duplicateRight) {
            return new EitherSerializer<L, R>(duplicateLeft, duplicateRight);
        }
        return this;
    }

    @Override
    public Either<L, R> createInstance() {
        return Either.Right(this.rightSerializer.createInstance());
    }

    @Override
    public Either<L, R> copy(Either<L, R> from) {
        if (from.isLeft()) {
            L left = from.left();
            L copyLeft = this.leftSerializer.copy(left);
            return Either.Left(copyLeft);
        }
        R right = from.right();
        R copyRight = this.rightSerializer.copy(right);
        return Either.Right(copyRight);
    }

    @Override
    public Either<L, R> copy(Either<L, R> from, Either<L, R> reuse) {
        if (from.isLeft()) {
            Either.Left<L, R> to = Either.obtainLeft(reuse, this.leftSerializer);
            L left = this.leftSerializer.copy(from.left(), to.left());
            to.setValue(left);
            return to;
        }
        Either.Right<L, R> to = Either.obtainRight(reuse, this.rightSerializer);
        R right = this.rightSerializer.copy(from.right(), to.right());
        to.setValue(right);
        return to;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(Either<L, R> record, DataOutputView target) throws IOException {
        if (record.isLeft()) {
            target.writeBoolean(true);
            this.leftSerializer.serialize(record.left(), target);
        } else {
            target.writeBoolean(false);
            this.rightSerializer.serialize(record.right(), target);
        }
    }

    @Override
    public Either<L, R> deserialize(DataInputView source) throws IOException {
        boolean isLeft = source.readBoolean();
        if (isLeft) {
            return Either.Left(this.leftSerializer.deserialize(source));
        }
        return Either.Right(this.rightSerializer.deserialize(source));
    }

    @Override
    public Either<L, R> deserialize(Either<L, R> reuse, DataInputView source) throws IOException {
        boolean isLeft = source.readBoolean();
        if (isLeft) {
            Either.Left<L, R> to = Either.obtainLeft(reuse, this.leftSerializer);
            L left = this.leftSerializer.deserialize(to.left(), source);
            to.setValue(left);
            return to;
        }
        Either.Right<L, R> to = Either.obtainRight(reuse, this.rightSerializer);
        R right = this.rightSerializer.deserialize(to.right(), source);
        to.setValue(right);
        return to;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        boolean isLeft = source.readBoolean();
        target.writeBoolean(isLeft);
        if (isLeft) {
            this.leftSerializer.copy(source, target);
        } else {
            this.rightSerializer.copy(source, target);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof EitherSerializer) {
            EitherSerializer other = (EitherSerializer)obj;
            return this.leftSerializer.equals(other.leftSerializer) && this.rightSerializer.equals(other.rightSerializer);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 * this.leftSerializer.hashCode() + this.rightSerializer.hashCode();
    }

    public JavaEitherSerializerSnapshot<L, R> snapshotConfiguration() {
        return new JavaEitherSerializerSnapshot(this);
    }
}

