/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3.signer;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.aws.s3.signer.S3SignResponse;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="S3SignResponse", generator="Immutables")
@Immutable
public final class ImmutableS3SignResponse
implements S3SignResponse {
    private final URI uri;
    private final Map<String, List<String>> headers;

    private ImmutableS3SignResponse(URI uri, Map<String, List<String>> headers) {
        this.uri = uri;
        this.headers = headers;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public final ImmutableS3SignResponse withUri(URI value) {
        if (this.uri == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "uri");
        return new ImmutableS3SignResponse(newValue, this.headers);
    }

    public final ImmutableS3SignResponse withHeaders(Map<String, ? extends List<String>> entries) {
        if (this.headers == entries) {
            return this;
        }
        Map<String, List<String>> newValue = ImmutableS3SignResponse.createUnmodifiableMap(true, false, entries);
        return new ImmutableS3SignResponse(this.uri, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableS3SignResponse && this.equalTo(0, (ImmutableS3SignResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableS3SignResponse another) {
        return this.uri.equals(another.uri) && this.headers.equals(another.headers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.uri.hashCode();
        h += (h << 5) + this.headers.hashCode();
        return h;
    }

    public String toString() {
        return "S3SignResponse{uri=" + this.uri + ", headers=" + this.headers + "}";
    }

    public static ImmutableS3SignResponse copyOf(S3SignResponse instance) {
        if (instance instanceof ImmutableS3SignResponse) {
            return (ImmutableS3SignResponse)instance;
        }
        return ImmutableS3SignResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="S3SignResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_URI = 1L;
        private long initBits = 1L;
        @Nullable
        private URI uri;
        private Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(S3SignResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.uri(instance.uri());
            this.putAllHeaders(instance.headers());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uri(URI uri) {
            this.uri = Objects.requireNonNull(uri, "uri");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHeaders(String key, List<String> value) {
            this.headers.put(Objects.requireNonNull(key, "headers key"), Objects.requireNonNull(value, value == null ? "headers value for key: " + key : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putHeaders(Map.Entry<String, ? extends List<String>> entry) {
            List<String> v;
            String k = entry.getKey();
            this.headers.put(Objects.requireNonNull(k, "headers key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "headers value for key: " + k : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder headers(Map<String, ? extends List<String>> entries) {
            this.headers.clear();
            return this.putAllHeaders(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllHeaders(Map<String, ? extends List<String>> entries) {
            for (Map.Entry<String, ? extends List<String>> e : entries.entrySet()) {
                List<String> v;
                String k = e.getKey();
                this.headers.put(Objects.requireNonNull(k, "headers key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "headers value for key: " + k : null));
            }
            return this;
        }

        public ImmutableS3SignResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableS3SignResponse(this.uri, ImmutableS3SignResponse.createUnmodifiableMap(false, false, this.headers));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("uri");
            }
            return "Cannot build S3SignResponse, some of required attributes are not set " + attributes;
        }
    }
}

