/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.module.scala.ClassTagExtensions;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.fasterxml.jackson.module.scala.JavaTypeable;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.apache.spark.sql.execution.streaming.state.RocksDBCheckpointMetadata;
import org.apache.spark.sql.execution.streaming.state.RocksDBImmutableFile;
import org.apache.spark.sql.execution.streaming.state.RocksDBLogFile;
import org.apache.spark.sql.execution.streaming.state.RocksDBSstFile;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class RocksDBCheckpointMetadata$
implements Serializable {
    public static RocksDBCheckpointMetadata$ MODULE$;
    private ObjectMapper mapper;
    private final int VERSION;
    private final Formats format;
    private volatile boolean bitmap$0;

    static {
        new RocksDBCheckpointMetadata$();
    }

    public int VERSION() {
        return this.VERSION;
    }

    public Formats format() {
        return this.format;
    }

    /*
     * WARNING - void declaration
     */
    private ObjectMapper mapper$lzycompute() {
        RocksDBCheckpointMetadata$ rocksDBCheckpointMetadata$ = this;
        synchronized (rocksDBCheckpointMetadata$) {
            if (!this.bitmap$0) {
                void var2_2;
                ClassTagExtensions _mapper = new ClassTagExtensions(){

                    public final <Target, MixinSource> ObjectMapper addMixin(ClassTag<Target> evidence$1, ClassTag<MixinSource> evidence$2) {
                        return ClassTagExtensions.addMixin$((ClassTagExtensions)this, evidence$1, evidence$2);
                    }

                    public final <T> Class<?> findMixInClassFor(ClassTag<T> evidence$3) {
                        return ClassTagExtensions.findMixInClassFor$((ClassTagExtensions)this, evidence$3);
                    }

                    public <T> JavaType constructType(JavaTypeable<T> evidence$4) {
                        return ClassTagExtensions.constructType$((ClassTagExtensions)this, evidence$4);
                    }

                    public <T> T readValue(JsonParser jp, JavaTypeable<T> evidence$5) {
                        return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (JsonParser)jp, evidence$5);
                    }

                    public <T> MappingIterator<T> readValues(JsonParser jp, JavaTypeable<T> evidence$6) {
                        return ClassTagExtensions.readValues$((ClassTagExtensions)this, (JsonParser)jp, evidence$6);
                    }

                    public <T> T treeToValue(TreeNode n, JavaTypeable<T> evidence$7) {
                        return (T)ClassTagExtensions.treeToValue$((ClassTagExtensions)this, (TreeNode)n, evidence$7);
                    }

                    public <T> T readValue(File src, JavaTypeable<T> evidence$8) {
                        return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (File)src, evidence$8);
                    }

                    public <T> T readValue(URL src, JavaTypeable<T> evidence$9) {
                        return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (URL)src, evidence$9);
                    }

                    public <T> T readValue(String content, JavaTypeable<T> evidence$10) {
                        return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (String)content, evidence$10);
                    }

                    public <T> T readValue(Reader src, JavaTypeable<T> evidence$11) {
                        return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (Reader)src, evidence$11);
                    }

                    public <T> T readValue(InputStream src, JavaTypeable<T> evidence$12) {
                        return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (InputStream)src, evidence$12);
                    }

                    public <T> T readValue(byte[] src, JavaTypeable<T> evidence$13) {
                        return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (byte[])src, evidence$13);
                    }

                    public <T> T readValue(byte[] src, int offset, int len, JavaTypeable<T> evidence$14) {
                        return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (byte[])src, (int)offset, (int)len, evidence$14);
                    }

                    public <T> T updateValue(T valueToUpdate, File src, JavaTypeable<T> evidence$15) {
                        return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (File)src, evidence$15);
                    }

                    public <T> T updateValue(T valueToUpdate, URL src, JavaTypeable<T> evidence$16) {
                        return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (URL)src, evidence$16);
                    }

                    public <T> T updateValue(T valueToUpdate, String content, JavaTypeable<T> evidence$17) {
                        return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (String)content, evidence$17);
                    }

                    public <T> T updateValue(T valueToUpdate, Reader src, JavaTypeable<T> evidence$18) {
                        return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (Reader)src, evidence$18);
                    }

                    public <T> T updateValue(T valueToUpdate, InputStream src, JavaTypeable<T> evidence$19) {
                        return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (InputStream)src, evidence$19);
                    }

                    public <T> T updateValue(T valueToUpdate, byte[] src, JavaTypeable<T> evidence$20) {
                        return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (byte[])src, evidence$20);
                    }

                    public <T> T updateValue(T valueToUpdate, byte[] src, int offset, int len, JavaTypeable<T> evidence$21) {
                        return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (byte[])src, (int)offset, (int)len, evidence$21);
                    }

                    public <T> ObjectWriter writerWithView(ClassTag<T> evidence$23) {
                        return ClassTagExtensions.writerWithView$((ClassTagExtensions)this, evidence$23);
                    }

                    public <T> ObjectWriter writerFor(JavaTypeable<T> evidence$24) {
                        return ClassTagExtensions.writerFor$((ClassTagExtensions)this, evidence$24);
                    }

                    public <T> ObjectReader readerFor(JavaTypeable<T> evidence$25) {
                        return ClassTagExtensions.readerFor$((ClassTagExtensions)this, evidence$25);
                    }

                    public <T> ObjectReader readerWithView(ClassTag<T> evidence$26) {
                        return ClassTagExtensions.readerWithView$((ClassTagExtensions)this, evidence$26);
                    }

                    public <T> T convertValue(Object fromValue, JavaTypeable<T> evidence$27) {
                        return (T)ClassTagExtensions.convertValue$((ClassTagExtensions)this, (Object)fromValue, evidence$27);
                    }
                    {
                        ClassTagExtensions.$init$((ClassTagExtensions)this);
                    }
                };
                _mapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
                _mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                _mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
                this.mapper = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.mapper;
    }

    public ObjectMapper mapper() {
        return !this.bitmap$0 ? this.mapper$lzycompute() : this.mapper;
    }

    public RocksDBCheckpointMetadata readFromFile(File metadataFile) {
        RocksDBCheckpointMetadata rocksDBCheckpointMetadata;
        try (BufferedReader reader = Files.newBufferedReader(metadataFile.toPath(), StandardCharsets.UTF_8);){
            String versionLine;
            String string = versionLine = reader.readLine();
            String string2 = new StringBuilder(1).append("v").append(this.VERSION()).toString();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new IllegalStateException(new StringBuilder(51).append("Cannot read RocksDB checkpoint metadata of version ").append(versionLine).toString());
            }
            rocksDBCheckpointMetadata = (RocksDBCheckpointMetadata)Serialization$.MODULE$.read((Reader)reader, this.format(), ManifestFactory$.MODULE$.classType(RocksDBCheckpointMetadata.class));
        }
        return rocksDBCheckpointMetadata;
    }

    public RocksDBCheckpointMetadata apply(Seq<RocksDBImmutableFile> rocksDBFiles, long numKeys) {
        Seq sstFiles = (Seq)rocksDBFiles.collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends RocksDBImmutableFile, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof RocksDBSstFile) {
                    RocksDBSstFile rocksDBSstFile = (RocksDBSstFile)A1;
                    object = rocksDBSstFile;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(RocksDBImmutableFile x1) {
                RocksDBImmutableFile rocksDBImmutableFile = x1;
                boolean bl = rocksDBImmutableFile instanceof RocksDBSstFile;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq logFiles = (Seq)rocksDBFiles.collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends RocksDBImmutableFile, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof RocksDBLogFile) {
                    RocksDBLogFile rocksDBLogFile = (RocksDBLogFile)A1;
                    object = rocksDBLogFile;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(RocksDBImmutableFile x2) {
                RocksDBImmutableFile rocksDBImmutableFile = x2;
                boolean bl = rocksDBImmutableFile instanceof RocksDBLogFile;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new RocksDBCheckpointMetadata((Seq<RocksDBSstFile>)sstFiles, (Seq<RocksDBLogFile>)logFiles, numKeys);
    }

    public RocksDBCheckpointMetadata apply(Seq<RocksDBSstFile> sstFiles, Seq<RocksDBLogFile> logFiles, long numKeys) {
        return new RocksDBCheckpointMetadata(sstFiles, logFiles, numKeys);
    }

    public Option<Tuple3<Seq<RocksDBSstFile>, Seq<RocksDBLogFile>, Object>> unapply(RocksDBCheckpointMetadata x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3(x$0.sstFiles(), x$0.logFiles(), (Object)BoxesRunTime.boxToLong((long)x$0.numKeys())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RocksDBCheckpointMetadata$() {
        MODULE$ = this;
        this.VERSION = 1;
        this.format = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
    }
}

