/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.runtime.state.metrics.StateLatencyMetricBase;
import org.apache.flink.util.function.SupplierWithException;
import org.apache.flink.util.function.ThrowingRunnable;

class AbstractLatencyTrackState<K, N, V, S extends InternalKvState<K, N, V>, LSM extends StateLatencyMetricBase>
implements InternalKvState<K, N, V> {
    protected S original;
    protected LSM latencyTrackingStateMetric;

    AbstractLatencyTrackState(S original, LSM latencyTrackingStateMetric) {
        this.original = original;
        this.latencyTrackingStateMetric = latencyTrackingStateMetric;
    }

    @Override
    public TypeSerializer<K> getKeySerializer() {
        return this.original.getKeySerializer();
    }

    @Override
    public TypeSerializer<N> getNamespaceSerializer() {
        return this.original.getNamespaceSerializer();
    }

    @Override
    public TypeSerializer<V> getValueSerializer() {
        return this.original.getValueSerializer();
    }

    @Override
    public void setCurrentNamespace(N namespace) {
        this.original.setCurrentNamespace(namespace);
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<N> safeNamespaceSerializer, TypeSerializer<V> safeValueSerializer) throws Exception {
        return this.original.getSerializedValue(serializedKeyAndNamespace, safeKeySerializer, safeNamespaceSerializer, safeValueSerializer);
    }

    @Override
    public InternalKvState.StateIncrementalVisitor<K, N, V> getStateIncrementalVisitor(int recommendedMaxNumberOfReturnedRecords) {
        return this.original.getStateIncrementalVisitor(recommendedMaxNumberOfReturnedRecords);
    }

    public void clear() {
        if (((StateLatencyMetricBase)this.latencyTrackingStateMetric).trackLatencyOnClear()) {
            this.trackLatency(() -> this.original.clear(), "stateClearLatency");
        } else {
            this.original.clear();
        }
    }

    protected <T> T trackLatency(Supplier<T> supplier, String latencyLabel) {
        long startTime = System.nanoTime();
        T result = supplier.get();
        long latency = System.nanoTime() - startTime;
        ((StateLatencyMetricBase)this.latencyTrackingStateMetric).updateLatency(latencyLabel, latency);
        return result;
    }

    protected <T> T trackLatencyWithIOException(SupplierWithException<T, IOException> supplier, String latencyLabel) throws IOException {
        long startTime = System.nanoTime();
        Object result = supplier.get();
        long latency = System.nanoTime() - startTime;
        ((StateLatencyMetricBase)this.latencyTrackingStateMetric).updateLatency(latencyLabel, latency);
        return (T)result;
    }

    protected void trackLatencyWithIOException(ThrowingRunnable<IOException> runnable, String latencyLabel) throws IOException {
        long startTime = System.nanoTime();
        runnable.run();
        long latency = System.nanoTime() - startTime;
        ((StateLatencyMetricBase)this.latencyTrackingStateMetric).updateLatency(latencyLabel, latency);
    }

    protected <T> T trackLatencyWithException(SupplierWithException<T, Exception> supplier, String latencyLabel) throws Exception {
        long startTime = System.nanoTime();
        Object result = supplier.get();
        long latency = System.nanoTime() - startTime;
        ((StateLatencyMetricBase)this.latencyTrackingStateMetric).updateLatency(latencyLabel, latency);
        return (T)result;
    }

    protected void trackLatencyWithException(ThrowingRunnable<Exception> runnable, String latencyLabel) throws Exception {
        long startTime = System.nanoTime();
        runnable.run();
        long latency = System.nanoTime() - startTime;
        ((StateLatencyMetricBase)this.latencyTrackingStateMetric).updateLatency(latencyLabel, latency);
    }

    protected void trackLatency(Runnable runnable, String latencyLabel) {
        long startTime = System.nanoTime();
        runnable.run();
        long latency = System.nanoTime() - startTime;
        ((StateLatencyMetricBase)this.latencyTrackingStateMetric).updateLatency(latencyLabel, latency);
    }

    @VisibleForTesting
    LSM getLatencyTrackingStateMetric() {
        return this.latencyTrackingStateMetric;
    }
}

