/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.PartitionInfo;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobmaster.AllocatedSlotReport;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.rest.messages.LogInfo;
import org.apache.flink.runtime.rest.messages.ProfilingInfo;
import org.apache.flink.runtime.rest.messages.ThreadDumpInfo;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcTimeout;
import org.apache.flink.runtime.shuffle.PartitionWithMetrics;
import org.apache.flink.runtime.taskexecutor.FileType;
import org.apache.flink.runtime.taskexecutor.TaskExecutorOperatorEventGateway;
import org.apache.flink.runtime.taskexecutor.TaskExecutorThreadInfoGateway;
import org.apache.flink.types.SerializableOptional;
import org.apache.flink.util.SerializedValue;

public interface TaskExecutorGateway
extends RpcGateway,
TaskExecutorOperatorEventGateway,
TaskExecutorThreadInfoGateway {
    public CompletableFuture<Acknowledge> requestSlot(SlotID var1, JobID var2, AllocationID var3, ResourceProfile var4, String var5, ResourceManagerId var6, @RpcTimeout Time var7);

    public CompletableFuture<Acknowledge> submitTask(TaskDeploymentDescriptor var1, JobMasterId var2, @RpcTimeout Time var3);

    public CompletableFuture<Acknowledge> updatePartitions(ExecutionAttemptID var1, Iterable<PartitionInfo> var2, @RpcTimeout Time var3);

    public void releasePartitions(JobID var1, Set<ResultPartitionID> var2);

    public CompletableFuture<Acknowledge> promotePartitions(JobID var1, Set<ResultPartitionID> var2);

    public CompletableFuture<Acknowledge> releaseClusterPartitions(Collection<IntermediateDataSetID> var1, @RpcTimeout Time var2);

    public CompletableFuture<Acknowledge> triggerCheckpoint(ExecutionAttemptID var1, long var2, long var4, CheckpointOptions var6);

    public CompletableFuture<Acknowledge> confirmCheckpoint(ExecutionAttemptID var1, long var2, long var4, long var6);

    public CompletableFuture<Acknowledge> abortCheckpoint(ExecutionAttemptID var1, long var2, long var4, long var6);

    public CompletableFuture<Acknowledge> cancelTask(ExecutionAttemptID var1, @RpcTimeout Time var2);

    public CompletableFuture<Void> heartbeatFromJobManager(ResourceID var1, AllocatedSlotReport var2);

    public CompletableFuture<Void> heartbeatFromResourceManager(ResourceID var1);

    public void disconnectJobManager(JobID var1, Exception var2);

    public void disconnectResourceManager(Exception var1);

    public CompletableFuture<Acknowledge> freeSlot(AllocationID var1, Throwable var2, @RpcTimeout Time var3);

    public void freeInactiveSlots(JobID var1, @RpcTimeout Time var2);

    public CompletableFuture<TransientBlobKey> requestFileUploadByType(FileType var1, @RpcTimeout Time var2);

    public CompletableFuture<TransientBlobKey> requestFileUploadByName(String var1, @RpcTimeout Duration var2);

    public CompletableFuture<TransientBlobKey> requestFileUploadByNameAndType(String var1, FileType var2, @RpcTimeout Duration var3);

    public CompletableFuture<SerializableOptional<String>> requestMetricQueryServiceAddress(@RpcTimeout Time var1);

    public CompletableFuture<Boolean> canBeReleased();

    public CompletableFuture<Collection<LogInfo>> requestLogList(@RpcTimeout Time var1);

    @Override
    public CompletableFuture<Acknowledge> sendOperatorEventToTask(ExecutionAttemptID var1, OperatorID var2, SerializedValue<OperatorEvent> var3);

    public CompletableFuture<ThreadDumpInfo> requestThreadDump(@RpcTimeout Time var1);

    public CompletableFuture<Acknowledge> updateDelegationTokens(ResourceManagerId var1, byte[] var2);

    default public CompletableFuture<Collection<PartitionWithMetrics>> getAndRetainPartitionWithMetrics(JobID jobId) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ProfilingInfo> requestProfiling(int var1, ProfilingInfo.ProfilingMode var2, @RpcTimeout Duration var3);

    public CompletableFuture<Collection<ProfilingInfo>> requestProfilingList(@RpcTimeout Duration var1);
}

